/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.actiondispatcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.OperationContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.response.ResponseHeader;
import kd.bos.response.ResponseHeaderManage;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;
import org.eclipse.jetty.io.EofException;

@SdkPublic
public class ActionUtil {
    private static final String UTF_8 = "utf-8";
    private static Log logger = LogFactory.getLog(ActionUtil.class);
    private static final String PROECTION_CONTROL_KEY = "cosmic.http.proection.enable";
    private static final String CONTENT_HEADER_CONFIG_KEY = "cosmic.http.response.header.config";
    private static boolean enableCacheControl = Boolean.parseBoolean(System.getProperty("cosmic.http.proection.enable", "true"));
    private static Properties responseHeader = new Properties();

    public static void writeResponseResult(ServletResponse response, CharSequence result) throws IOException {
        ActionUtil.writeResponseHeader(response);
        response.setContentType("text/html;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), UTF_8);){
            writer.write(result.toString());
            writer.flush();
        }
        catch (IOException e) {
            OperationContextCreator.getOrCreateForBos();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static Properties loadPorperties() {
        String headerProperties = System.getProperty(CONTENT_HEADER_CONFIG_KEY);
        Properties p = new Properties();
        try {
            if (headerProperties != null) {
                StringReader reader = new StringReader(headerProperties);
                p.load(reader);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return p;
    }

    public static void writeResponseJson(ServletResponse response, CharSequence result) throws IOException {
        ActionUtil.writeResponseHeader(response);
        response.setContentType("text/json;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), UTF_8);){
            writer.write(result.toString());
            writer.flush();
        }
        catch (EofException e) {
            OperationContextCreator.getOrCreateForBos();
            throw e;
        }
        catch (IOException e) {
            OperationContextCreator.getOrCreateForBos();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void writeResponseXml(ServletResponse response, CharSequence result) throws IOException {
        ActionUtil.writeResponseHeader(response);
        response.setContentType("text/xml;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), UTF_8);){
            writer.write(result.toString());
            writer.flush();
        }
        catch (IOException e) {
            OperationContextCreator.getOrCreateForBos();
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static void writeResponseHeader(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            Object o;
            HttpServletResponse res = (HttpServletResponse)response;
            Map headers = ResponseHeaderManage.getHeaders();
            headers.forEach((k, v) -> res.addHeader(k, v));
            if (enableCacheControl) {
                res.setHeader("Cache-Control", "max-age=0");
                res.setDateHeader("Expires", 0L);
                res.setHeader("X-XSS-Protection", "1;mode=block");
                res.setHeader("X-Frame-Options", "SAMEORIGIN");
                responseHeader.stringPropertyNames().forEach(key -> {
                    String value = responseHeader.getProperty((String)key);
                    if (value != null && value.length() > 0) {
                        res.setHeader(key, value);
                    }
                });
            }
            if ((o = ThreadTruck.get((Object)"web.request_enter_time")) != null) {
                res.addHeader("server-time", String.valueOf(System.currentTimeMillis() - (Long)o) + "ms");
            }
        }
    }

    public static void responseException(Throwable e, String action, String requestURI, ServletResponse response) throws IOException {
        Throwable responseException = TX.getResponseException();
        if (responseException != null) {
            e = responseException;
        } else if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        logger.error("Invoke action error: " + requestURI, e);
        ResponseHeader.get().error(new ErrorCode("ActionFilter/" + action, e.getMessage()));
        ActionUtil.writeResponseJson(response, ActionUtil.toJsonString(e, action));
        response.flushBuffer();
    }

    private static String toJsonString(Throwable t, String action) {
        if (t == null) {
            throw new NullPointerException();
        }
        try {
            Throwable detail;
            Throwable e = ActionUtil.extractException(t);
            if (e == null) {
                e = t;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (detail = e; detail != null && detail.getCause() != null; detail = detail.getCause()) {
            }
            if (detail != null) {
                detail.printStackTrace(pw);
            }
            pw.println("         ====================up is the cause exception,below is more =====================     ");
            e.printStackTrace(pw);
            pw.flush();
            ArrayList acts = new ArrayList(1);
            HashMap<String, Object> act = new HashMap<String, Object>();
            ArrayList params = new ArrayList(1);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("errorTitle", action);
            if (ActionUtil.isShowStackTrace()) {
                param.put("errorInfo", sw.toString());
            } else {
                param.put("errorInfo", e.getMessage());
                logger.error(e.getMessage(), e);
            }
            params.add(param);
            act.put("a", "showErrMsg");
            act.put("p", params);
            acts.add(act);
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(acts);
        }
        catch (Exception e2) {
            String msg = ActionUtil.maskQuote(t.getMessage());
            logger.error(e2.getMessage(), (Throwable)e2);
            return "[{\"p\":[{\"errorTitle\":\"" + action + "\",\"errorInfo\":\"" + msg + "\"}],\"a\":\"showErrMsg\"}]";
        }
    }

    public static boolean isShowStackTrace() {
        return "true".equals(System.getProperty("exception_showstacktrace", ""));
    }

    private static Throwable extractException(Throwable e) {
        Throwable result = e;
        while (e != null) {
            if (e instanceof KDException) {
                return e;
            }
            if (e.getClass().equals(RuntimeException.class)) {
                return e;
            }
            if (e instanceof NullPointerException) {
                return e;
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
                continue;
            }
            e = e.getCause();
        }
        return result;
    }

    private static String maskQuote(String s) {
        if (s != null) {
            s = s.replaceAll("\"", "\\\"").replaceAll("\n", " ").replaceAll("\r", " ");
        }
        return s;
    }

    public static String getServletPath(HttpServletRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        String servletPath = httpRequest.getRequestURI();
        if (StringUtils.isNotEmpty((String)contextPath)) {
            servletPath = servletPath.replaceFirst(contextPath, "");
        }
        return servletPath;
    }

    static {
        ConfigurationUtil.observeChange((String)PROECTION_CONTROL_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableCacheControl = Boolean.parseBoolean(System.getProperty(ActionUtil.PROECTION_CONTROL_KEY, "true"));
            }
        });
        responseHeader = ActionUtil.loadPorperties();
        ConfigurationUtil.observeChange((String)CONTENT_HEADER_CONFIG_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                responseHeader = ActionUtil.loadPorperties();
            }
        });
    }
}

