/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.client;

import java.util.HashMap;
import kd.bos.api.JsonSerde;
import kd.bos.api.client.HttpMethod;
import kd.bos.api.internal.JsonSerdeFactory;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.http.MimeTypes;

public class ApiRequest {
    private HttpMethod method;
    private String url;
    private HashMap<String, String> parameters;
    private HashMap<String, String> headers;
    private HashMap<String, String> cookies;
    private String postData;
    private ContentType contentType = null;
    private String characterEncoding;

    public ApiRequest(String method, String url) {
        this(ApiRequest.guessMethod(method), url);
    }

    public ApiRequest(HttpMethod method, String url) {
        this.method = method;
        this.url = url;
    }

    private static HttpMethod guessMethod(String method) {
        if ("get".equalsIgnoreCase(method)) {
            return HttpMethod.GET;
        }
        if ("post".equalsIgnoreCase(method)) {
            return HttpMethod.POST;
        }
        throw new IllegalArgumentException("Unsupported method: " + method);
    }

    public void addParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(key, value);
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(key, value);
    }

    public void addCookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap();
        }
        this.cookies.put(name, value);
    }

    public void setPostData(Object data) {
        this.setPostData(data, data.getClass());
    }

    public <T> void setPostData(Object data, Class<T> clazz) {
        String json;
        JsonSerde serde = JsonSerdeFactory.getJsonSerde(clazz);
        this.postData = json = serde.toJson(data, clazz);
    }

    public void setPostData(String json) {
        this.postData = json;
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, String> parameters) {
        this.parameters = parameters;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public HashMap<String, String> getCookies() {
        return this.cookies;
    }

    public String getPostData() {
        return this.postData;
    }

    public ContentType getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.characterEncoding != null) {
            this.contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (String)this.characterEncoding);
            return this.contentType;
        }
        return ContentType.APPLICATION_JSON;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setContentType(String contentType) {
        String charset = MimeTypes.getCharsetFromContentType((String)contentType);
        String mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentType);
        this.contentType = ContentType.create((String)mimeType, (String)charset);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public static void main(String[] args) {
        ApiRequest request = new ApiRequest("get", "");
        request.setContentType("application/x-www-form-urlencoded;charset=utf-8");
        request.setContentType("text/html;charset=UTF-8");
    }
}

