/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import kd.bos.api.JsonSerde;
import kd.bos.api.internal.JsonSerdeFactory;

public class ApiResult {
    private int statusCode = 200;
    private String data;
    private Throwable exception;
    private Map<String, String> headers;

    public ApiResult(Throwable t) {
        this.statusCode = -1;
        this.exception = t;
    }

    public ApiResult(String data) {
        this.data = data;
    }

    public ApiResult(int statusCode) {
        this.statusCode = statusCode;
    }

    public ApiResult(int statusCode, String data) {
        this.statusCode = statusCode;
        this.data = data;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getData() {
        if (!this.isOk() || this.data == null) {
            return null;
        }
        return this.data;
    }

    public <T> T getData(Class<T> clazz) {
        if (!this.isOk() || this.data == null) {
            return null;
        }
        JsonSerde serde = JsonSerdeFactory.getJsonSerde(clazz);
        return serde.fromJson(this.data, clazz);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getHeader(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return "{}";
        }
    }
}

