/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.client.impl;

import java.util.Locale;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.api.client.impl.DefaultApiClient;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class InternalApiClient
extends DefaultApiClient {
    public InternalApiClient() {
    }

    public InternalApiClient(ApiClient.Option option) {
        super(option);
    }

    @Override
    protected ApiRequest wrapRequest(ApiRequest request) {
        request = super.wrapRequest(request);
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            request.addCookie("KERPSESSIONID", rc.getGlobalSessionId());
        }
        return request;
    }

    @Override
    protected ApiResult wrapResult(ApiResult result) {
        return super.wrapResult(result);
    }

    @Override
    protected String completeUrl(String url) {
        if (url.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            return url;
        }
        String key = "bos.api.internal.url";
        String prefix = System.getProperty(key);
        if (prefix == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{String.format("%s not configured.", key)});
        }
        url = prefix.endsWith("/") && url.startsWith("/") ? prefix + url.substring(1) : (!prefix.endsWith("/") && !url.startsWith("/") ? prefix + "/" + url : prefix + url);
        return url;
    }
}

