/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.api.JsonSerde;
import kd.bos.api.internal.JacksonJsonSerde;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class JsonSerdeFactory {
    private static JsonSerde defaultSerde = null;
    private static ConcurrentHashMap<Class<?>, JsonSerde> map = new ConcurrentHashMap();

    private static void load() {
        Properties properties = JsonSerdeFactory.getInternalProperties();
        JsonSerdeFactory.loadProperties(properties);
        properties = JsonSerdeFactory.getPropertiesForConfig();
        JsonSerdeFactory.loadProperties(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getInternalProperties() {
        try (InputStream in = JsonSerdeFactory.class.getResourceAsStream("internalJsonSerde.properties");){
            if (in == null) {
                Properties properties = null;
                return properties;
            }
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{"error parse internalJsonSerde.properties\uff1a" + e.getMessage()});
        }
    }

    private static Properties getPropertiesForConfig() {
        return null;
    }

    private static void loadProperties(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String name : properties.stringPropertyNames()) {
            String value = properties.getProperty(name);
            JsonSerdeFactory.register(name, value);
        }
    }

    private static void loadDefault() {
        defaultSerde = JsonSerdeFactory.createDefault();
    }

    public static void register(String className, String implClassName) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<?> implClazz = Class.forName(implClassName);
            JsonSerde serde = (JsonSerde)implClazz.newInstance();
            JsonSerdeFactory.register(clazz, serde);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.apiCommon, new Object[]{"can't register jsonSerde for " + className + ":" + implClassName});
        }
    }

    public static <T> void register(Class<T> clazz, JsonSerde serde) {
        map.put(clazz, serde);
    }

    public static <T> JsonSerde getJsonSerde(Class<T> clazz) {
        JsonSerde serde = map.get(clazz);
        return serde == null ? defaultSerde : serde;
    }

    private static JsonSerde createDefault() {
        return new JacksonJsonSerde();
    }

    static {
        JsonSerdeFactory.load();
        JsonSerdeFactory.loadDefault();
    }
}

