/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.DisCardUtil;

public class MessageInbound
implements AutoCloseable {
    private InputStream in;
    private HttpServletRequest request;
    private String body;

    public MessageInbound(HttpServletRequest request) {
        this.request = request;
        try {
            this.in = request.getInputStream();
        }
        catch (IOException e) {
            DisCardUtil.discard();
        }
    }

    public String getBody() {
        if (this.body != null) {
            return this.body;
        }
        try {
            int read;
            int len = this.request.getContentLength();
            byte[] bytes = new byte[len];
            int left = bytes.length;
            int begin = 0;
            while ((read = this.in.read(bytes, begin, left)) >= 0) {
                begin += read;
                if ((left -= read) != 0) continue;
            }
            this.body = new String(bytes, "UTF-8");
            this.in.close();
            this.in = null;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
        }
        return this.body;
    }

    public <T> T getBody(Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        if (this.body != null) {
            try {
                return (T)mapper.readValue(this.body, clazz);
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.apiCommon, new Object[]{"parse json error:" + e.getMessage()});
            }
        }
        if (this.in != null) {
            try {
                Object e = mapper.readValue(this.in, clazz);
                return (T)e;
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, BosErrorCode.apiCommon, new Object[]{"parse json error:" + e.getMessage()});
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException t) {
                    DisCardUtil.discard();
                }
                this.in = null;
            }
        }
        throw new KDException(BosErrorCode.apiIO, new Object[]{"inputStream closed."});
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException t) {
                DisCardUtil.discard();
            }
            this.in = null;
        }
    }
}

