/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.rpc.param;

import java.io.Serializable;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.mservice.auth.api.AuthContext;
import kd.bos.mservice.auth.intercept.AuthServiceFactory;
import kd.bos.mservice.context.BaseContext;

public class KdFeignContext
extends BaseContext
implements Serializable {
    private static final long serialVersionUID = 9020002226982399901L;
    private static final ThreadLocal<KdFeignContext> current = new ThreadLocal();
    private RequestContext requestContext;
    private KdtxRequestContext kdtxRequestContext;
    private AuthContext authContext;

    private KdFeignContext() {
        BaseContext.set((BaseContext)this);
    }

    public static KdFeignContext create() {
        KdFeignContext feignContext = KdFeignContext.createCurrent(true);
        RequestContext currentRequestContext = RequestContext.get();
        feignContext.setRequestContext(currentRequestContext);
        feignContext.setKdtxRequestContext(KdtxRequestContext.get());
        if (currentRequestContext != null) {
            feignContext.setAuthContext(AuthServiceFactory.createAuthContext((String)currentRequestContext.getTenantId(), (String)currentRequestContext.getAccountId(), (String)currentRequestContext.getUserId()));
        }
        return feignContext;
    }

    private static KdFeignContext createCurrent(boolean setCurrent) {
        KdFeignContext context = new KdFeignContext();
        if (setCurrent) {
            KdFeignContext.set(context);
        }
        return context;
    }

    public static KdFeignContext get() {
        return current.get();
    }

    public static void set(KdFeignContext rc) {
        BaseContext.set((BaseContext)rc);
        current.set(rc);
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public KdtxRequestContext getKdtxRequestContext() {
        return this.kdtxRequestContext;
    }

    public void setKdtxRequestContext(KdtxRequestContext kdtxRequestContext) {
        this.kdtxRequestContext = kdtxRequestContext;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    public void setAuthContext(AuthContext authContext) {
        this.authContext = authContext;
    }

    public static void remove() {
        BaseContext.remove();
        current.remove();
    }
}

