/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.monitor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.MserviceInfo;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.CoreConstants;
import kd.bos.util.JSONUtils;

public class ServiceInfoManger
implements MserviceInfo {
    private static final Log log = LogFactory.getLog(ServiceInfoManger.class);
    private static CopyOnWriteArrayList<ServiceInfo> serviceList = new CopyOnWriteArrayList();
    private static MserviceInfo instance = new ServiceInfoManger();

    public static MserviceInfo getInstance() {
        return instance;
    }

    public static void initServiceInfos() {
        CopyOnWriteArrayList<ServiceInfo> tempServiceList = new CopyOnWriteArrayList<ServiceInfo>();
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        try {
            for (Map.Entry entry : nodesMap.entrySet()) {
                ServiceInfo serviceInfo = (ServiceInfo)JSONUtils.cast((String)((String)entry.getValue()), ServiceInfo.class, (boolean)true);
                tempServiceList.add(serviceInfo);
            }
            serviceList = tempServiceList;
        }
        catch (Exception e) {
            log.warn("ServiceInfoManger.initServiceInfos JSONUtils.cast error,path: {}", (Object)CoreConstants.MONITORROOTPATH, (Object)e);
        }
    }

    @Override
    public String getInstanceIdByIp(String ip) {
        if (null == ip) {
            return null;
        }
        String instanceId = null;
        String[] ips = ip.split(":");
        if (ips.length > 1) {
            ip = ips[0];
        }
        for (ServiceInfo serviceInfo : serviceList) {
            if (!ip.equals(serviceInfo.getIp())) continue;
            instanceId = serviceInfo.getInstanceId();
            break;
        }
        return instanceId;
    }

    @Override
    public String getAppNameByIp(String ip) {
        if (null == ip) {
            return null;
        }
        String appName = null;
        String[] ips = ip.split(":");
        if (ips.length > 1) {
            ip = ips[0];
        }
        for (ServiceInfo serviceInfo : serviceList) {
            if (!ip.equals(serviceInfo.getIp())) continue;
            appName = serviceInfo.getAppName();
            break;
        }
        return appName;
    }

    @Override
    public ServiceInfo getServiceInfoByIp(String ip) {
        if (null == ip) {
            return null;
        }
        ServiceInfo serviceInfoTemp = null;
        String[] ips = ip.split(":");
        if (ips.length > 1) {
            ip = ips[0];
        }
        for (ServiceInfo serviceInfo : serviceList) {
            if (!ip.equals(serviceInfo.getIp())) continue;
            serviceInfoTemp = serviceInfo;
            break;
        }
        return serviceInfoTemp;
    }

    @Override
    public ServiceInfo getServiceInfoByAppName(String appName) {
        if (null == appName) {
            return null;
        }
        ServiceInfo service = null;
        for (ServiceInfo serviceInfo : serviceList) {
            if (!serviceInfo.getAppName().equals(appName)) continue;
            service = serviceInfo;
            break;
        }
        return service;
    }

    @Override
    public List<ServiceInfo> getServiceList() {
        return serviceList;
    }

    static {
        ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
        messageCenter.addWatch("configUrl", CoreConstants.MONITORROOTPATH, new NodeChangeListener(){

            public void onChange(String key, String value) {
                ServiceInfoManger.initServiceInfos();
            }
        });
    }
}

