/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.changetask;

import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.changetask.ShardChangeTaskInfo;
import kd.bos.xdb.changetask.ShardChangeTaskListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class ShardChangeTaskNotifier
extends ZKWatchValueNotifier {
    private static final String SHARD_TASK_CHANGE_WATCHER = "shard.task.change.watcher";
    private static final String FIRE_SHARD_TASK_CHANGE_LOCK_KEY = "/shard/fire_change_task";

    public static void registerChangeTaskListener(final ShardChangeTaskListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    ShardChangeTaskInfo ai = ShardChangeTaskListener.fromKey((String)newValue);
                    l.onReceiveChangeTask(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        ShardChangeTaskNotifier.observeChange((String)SHARD_TASK_CHANGE_WATCHER, (ConfigurationChangeListener)listener);
    }

    public static void fireChangeTask(String recordName) {
        String value = ShardChangeTaskListener.currentKey(recordName);
        log.info("ShardChangeTaskNotifier fireChangeTask " + recordName + " " + value);
        ShardChangeTaskNotifier.fireLimit((String)FIRE_SHARD_TASK_CHANGE_LOCK_KEY, (String)SHARD_TASK_CHANGE_WATCHER, (String)value);
    }
}

