/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.entity;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.bundle.util.MultiLangEnumBridge;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.BaseCustomStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.date.DateDayStrategy;
import kd.bos.xdb.sharding.strategy.date.DateMonthSrategy;
import kd.bos.xdb.sharding.strategy.date.DateYearStrategy;
import kd.bos.xdb.sharding.strategy.hash.DateHashModStrategy;
import kd.bos.xdb.sharding.strategy.hash.DateModStrategy;
import kd.bos.xdb.sharding.strategy.hash.HashModStrategy;
import kd.bos.xdb.sharding.strategy.hash.ModHashStrategy;
import kd.bos.xdb.sharding.strategy.id.IDSequenceStrategy;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.sharding.strategy.number.PKModStrategy;
import kd.bos.xdb.sharding.strategy.value.LongValueStrategy;

public class ShardConfigStrategyFactory {
    private static final String CUSTOM_STRATEGY = "custom_strategy";
    private static final String INDEX_PK = "index_pk";
    private static final String PK_FIELD = "pk_field";
    private static final String ID_SEQUENCE = "id_sequence";
    private static final Map<String, MultiLangEnumBridge> sampleParamMap = new HashMap<String, MultiLangEnumBridge>();

    public static ShardingStrategy create(String type, String params) {
        Properties ps = new Properties();
        try {
            ps.load(new StringReader(params));
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
        ShardingStrategy ss = ShardConfigStrategyFactory.doCreate(type, params, ps);
        ((AbstractShardingStrategy)ss).setIndexPK(Boolean.parseBoolean(ps.getProperty(INDEX_PK)));
        ((AbstractShardingStrategy)ss).setIDSequence(Boolean.parseBoolean(ps.getProperty(ID_SEQUENCE)));
        String pkField = ps.getProperty(PK_FIELD, "").trim();
        if (pkField.length() > 0) {
            ((AbstractShardingStrategy)ss).setPKField(pkField);
        }
        return ss;
    }

    private static ShardingStrategy doCreate(String type, String params, Properties ps) {
        switch (type) {
            case "DateDayStrategy": {
                return new DateDayStrategy();
            }
            case "DateMonthStrategy": {
                return new DateMonthSrategy();
            }
            case "DateYearStrategy": {
                return new DateYearStrategy();
            }
            case "PKModStrategy": {
                return new PKModStrategy(Integer.parseInt(ps.getProperty("mod", "3")));
            }
            case "DateModStrategy": {
                String pattern = ps.getProperty("pattern", "").trim();
                if (pattern.length() == 0) {
                    pattern = "yyyy-MM-dd";
                }
                return new DateModStrategy(pattern, Integer.parseInt(ps.getProperty("mod", "3")));
            }
            case "DateHashStrategy": 
            case "DateHashModStrategy": {
                String pattern = ps.getProperty("pattern", "").trim();
                if (pattern.length() == 0) {
                    pattern = "yyyy-MM-dd";
                }
                return new DateHashModStrategy(pattern, Integer.parseInt(ps.getProperty("mod", "3")));
            }
            case "DateValueStrategy": {
                break;
            }
            case "HashValueStrategy": {
                break;
            }
            case "LongMaskValueStrategy": {
                break;
            }
            case "LongValueStrategy": {
                return new LongValueStrategy();
            }
            case "IDSequenceStrategy": {
                String pattern = ps.getProperty("pattern", "").trim();
                if (pattern.length() == 0) {
                    pattern = "yyyy-MM";
                }
                return new IDSequenceStrategy(pattern);
            }
            case "ModHashStrategy": {
                String pattern = ps.getProperty("pattern", "").trim();
                if (pattern.length() == 0) {
                    return new ModHashStrategy(Integer.parseInt(ps.getProperty("mod", "3")));
                }
                return new ModHashStrategy(Integer.parseInt(ps.getProperty("mod", "3")), pattern);
            }
            case "HashModStrategy": {
                HashMap<Object, Object> paramMap = new HashMap<Object, Object>(ps);
                return new HashModStrategy(paramMap);
            }
            case "ConsistentHashStrategy": {
                break;
            }
            case "MapValueStrategy": {
                break;
            }
            case "RangeValueStrategy": {
                break;
            }
            case "MapStrategy": {
                HashMap<Object, Object> paramMap = new HashMap<Object, Object>(ps);
                if (paramMap.isEmpty()) {
                    throw new IllegalArgumentException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingStrategyFactory_3", (String)"When creating MapStrategy, parameter is empty.", (Object[])new Object[0]));
                }
                return new MapStrategy(paramMap);
            }
            case "custom_strategy": {
                String cls = ps.getProperty("cust_class");
                if (cls == null || cls.length() == 0) {
                    throw new IllegalArgumentException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingStrategyFactory_1", (String)"Missing Cls Parameter.", (Object[])new Object[0]));
                }
                ps.remove(cls);
                try {
                    return (BaseCustomStrategy)Class.forName(cls).getDeclaredConstructor(Map.class).newInstance(new HashMap<Object, Object>(ps));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingStrategyFactory_2", (String)"Error Creating Policy {0}.", (Object[])new Object[0]) + cls + BosRes.get((String)"bos-xdb-manager", (String)"ShardingStrategyFactory_9", (String)"Error", (Object[])new Object[0]), e);
                }
            }
        }
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingStrategyFactory_4", (String)"Shard type not supported: type= ", (Object[])new Object[0]) + type + ", params=" + params + ".");
    }

    public static String getSampleParameter(String type) {
        MultiLangEnumBridge code = sampleParamMap.get(type);
        return code == null ? "" : code.loadKDString();
    }

    public static Set<String> getStrategys() {
        return sampleParamMap.keySet();
    }

    static {
        sampleParamMap.put("DateDayStrategy", new MultiLangEnumBridge("index_pk=true\n#\u65e0\u9700\u5176\u5b83\u53c2\u6570", "ShardingStrategyFactory_5", "bos-xdb-manager"));
        sampleParamMap.put("DateMonthStrategy", new MultiLangEnumBridge("index_pk=true\n#\u65e0\u9700\u5176\u5b83\u53c2\u6570", "ShardingStrategyFactory_5", "bos-xdb-manager"));
        sampleParamMap.put("DateYearStrategy", new MultiLangEnumBridge("index_pk=true\n#\u65e0\u9700\u5176\u5b83\u53c2\u6570", "ShardingStrategyFactory_5", "bos-xdb-manager"));
        sampleParamMap.put("PKModStrategy", new MultiLangEnumBridge("index_pk=false\nmod=3"));
        sampleParamMap.put("DateHashStrategy", new MultiLangEnumBridge("index_pk=true\npattern=yyyy-MM-dd\nmod=3"));
        sampleParamMap.put("DateValueStrategy", new MultiLangEnumBridge("index_pk=true\npattern=yyyy-MM-dd"));
        sampleParamMap.put("HashValueStrategy", new MultiLangEnumBridge("index_pk=true\n#\u65e0\u9700\u5176\u5b83\u53c2\u6570", "ShardingStrategyFactory_5", "bos-xdb-manager"));
        sampleParamMap.put("LongMaskValueStrategy", new MultiLangEnumBridge("index_pk=true\nmask=0xFFFFFFF0"));
        sampleParamMap.put("LongValueStrategy", new MultiLangEnumBridge("index_pk=true\n#\u65e0\u9700\u5176\u5b83\u53c2\u6570", "ShardingStrategyFactory_5", "bos-xdb-manager"));
        sampleParamMap.put("ModHashStrategy", new MultiLangEnumBridge("index_pk=true\nmod=3"));
        sampleParamMap.put("ConsistentHashStrategy", new MultiLangEnumBridge("index_pk=true\n#\u6682\u4e0d\u652f\u6301\nseg=100000000,200000000,300000000,400000000,500000000,600000000,700000000,800000000,900000000,1000000000,1100000000,1200000000", "ShardingStrategyFactory_6", "bos-xdb-manager"));
        sampleParamMap.put("MapValueStrategy", new MultiLangEnumBridge("index_pk=true\n#\u6682\u4e0d\u652f\u6301\none2one=false\n1=A,B\n2=C,D,E\n3=*", "ShardingStrategyFactory_7", "bos-xdb-manager"));
        sampleParamMap.put("RangeValueStrategy", new MultiLangEnumBridge("index_pk=true\n#\u6682\u4e0d\u652f\u6301\ntype=date\n1=[,2017-01-01)\n2=[2017-01-01,2018-06-01)\n3=[2018-06-01,)", "ShardingStrategyFactory_8", "bos-xdb-manager"));
        sampleParamMap.put(CUSTOM_STRATEGY, new MultiLangEnumBridge("index_pk=true\ncls=kd.bos.xdb.biz.strategy.GLVoucherOrgPeriodStrategy\neach_year_period_mod=4\npk_field=fid\n#..."));
    }
}

