/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.mq.OperationLogBody;
import kd.bos.xdb.repository.ShardLogRepository;
import kd.bos.xdb.service.ShardTaskConfig;

public class ShardLogConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ShardLogConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)body;
            if (logger.isInfoEnabled() || ShardTaskConfig.isEnableMovingLog()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ShardLogConsumer body:{0}", str));
            }
            ObjectMapper objectMapper = new ObjectMapper();
            OperationLogBody logBody = (OperationLogBody)objectMapper.readValue(str, OperationLogBody.class);
            ShardLogRepository.get().insertOperationLog(logBody);
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            } else {
                acker.deny(messageId);
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ShardTaskMovingHandler ShardLogConsumer onMessage error, messageId:{0}, discard:{1}, errorinfo:{2}", messageId, discard, sw.toString());
            XDBManagerUtil.logError(error, e);
        }
    }
}

