/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.operationcollect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.operationcollect.CbsOperationCollectService;
import kd.bos.operationcollect.CollectInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.repository.ShardConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdbServiceOperationCollect
implements CbsOperationCollectService {
    Logger log = LoggerFactory.getLogger((String)"XDB");

    public List<CollectInfo> collect() {
        ArrayList<CollectInfo> collectInfoList = new ArrayList<CollectInfo>(2);
        CollectInfo collectInfo = new CollectInfo();
        collectInfo.setBusinessScene("XDB");
        HashMap<String, String> collectDataMap = new HashMap<String, String>(2);
        boolean xdbEnable = DB.isXDBEnable();
        collectDataMap.put("xdbEnable", String.valueOf(xdbEnable));
        ArrayList configMapList = new ArrayList(1);
        if (xdbEnable) {
            List<ShardConfigEntity> configEntityList = ShardConfigRepository.get().loadConfigList();
            for (ShardConfigEntity config : configEntityList) {
                if (StringUtils.isEmpty((String)config.getStrategy()) || StringUtils.isEmpty((String)config.getShardingfields()) || config.getConfigstatus() == ShardConfigStatusEnum.DISABLE && !DBShardingRuntime.get().getConfigLoaded().get()) continue;
                HashMap<String, String> configMap = new HashMap<String, String>(2);
                configMap.put("entitynumber", config.getEntitynumber());
                configMap.put("shardingfields", config.getShardingfields());
                configMap.put("strategy", config.getStrategy());
                configMapList.add(configMap);
            }
        }
        try {
            collectDataMap.put("shardConfigs", JSONUtils.toString(configMapList));
        }
        catch (IOException e) {
            this.log.error("XdbServiceOperationCollect collectDataMap toString error", (Throwable)e);
        }
        collectInfo.setData(collectDataMap);
        collectInfoList.add(collectInfo);
        return collectInfoList;
    }
}

