/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.entity.ShardArchiEntity;
import kd.bos.xdb.enums.ShardArchiStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardArchiRepository;

public class ShardArchiRepositoryImpl
implements ShardArchiRepository {
    public static final ShardArchiRepositoryImpl instance = new ShardArchiRepositoryImpl();

    @Override
    public List<ShardArchiEntity> loadShardArchiList() {
        return this.loadShardArchiWithCondition(null);
    }

    private List<ShardArchiEntity> loadShardArchiWithCondition(String condition) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" fid,fentitynumber,fconfigid,fstatus,farchivefield,foperationlog,fversion,frwmark ");
            sql.append(" from t_cbs_shard_archi ");
            if (condition != null) {
                sql.append(" where ").append(condition);
            }
            return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), rs -> {
                ArrayList<ShardArchiEntity> ret = new ArrayList<ShardArchiEntity>(100);
                while (rs.next()) {
                    ShardArchiEntity chardArchiEntity = new ShardArchiEntity();
                    chardArchiEntity.setId(rs.getLong(1));
                    chardArchiEntity.setEntityNumber(rs.getString(2));
                    chardArchiEntity.setConfigId(rs.getLong(3));
                    chardArchiEntity.setShardArchiStatus(ShardArchiStatusEnum.from(rs.getString(4)));
                    chardArchiEntity.setArchivefield(rs.getString(5));
                    chardArchiEntity.setOperationLog(rs.getString(6));
                    chardArchiEntity.setVersion(rs.getLong(7));
                    chardArchiEntity.setRwMark(rs.getString(8));
                    ret.add(chardArchiEntity);
                }
                return ret;
            });
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    @Override
    public ShardArchiEntity loadShardArchi(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        List<ShardArchiEntity> ret = this.loadShardArchiWithCondition(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ShardArchiEntity loadShardArchi(long id) {
        String condition = " fid = '" + id + "' ";
        List<ShardArchiEntity> ret = this.loadShardArchiWithCondition(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setShardArchiStatus(long id, ShardArchiStatusEnum curStatus, ShardArchiStatusEnum nextStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_archi ");
        sql.append(" set fstatus = ? ");
        sql.append(" where fid = ? and fstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextStatus.getKey(), id, curStatus.getKey()});
    }

    @Override
    public int setShardArchiRWMark(long id, String rwMark, ShardArchiStatusEnum statusEnum) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_archi ");
        sql.append(" set frwmark = ? ");
        sql.append(" where fid = ? and fstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{rwMark, id, statusEnum.getKey()});
    }

    @Override
    public void clearArchi(String entityNumber) {
        ShardArchiEntity shardArchiEntity = this.loadShardArchi(entityNumber);
        if (shardArchiEntity != null) {
            String deleteArchiConfig = "delete from t_cbs_shard_archi where fid = " + shardArchiEntity.getId();
            String deleteArchiRoute = "delete from t_cbs_shard_archi_route where farchiconfigid = " + shardArchiEntity.getId();
            String deleteArchiCondi = "delete from t_cbs_shard_archi_condi where fid = " + shardArchiEntity.getId();
            DB.execute((DBRoute)DBRoute.base, (String)deleteArchiConfig);
            DB.execute((DBRoute)DBRoute.base, (String)deleteArchiRoute);
            DB.execute((DBRoute)DBRoute.base, (String)deleteArchiCondi);
        }
    }
}

