/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.entity.ShardArchiRouteEntity;
import kd.bos.xdb.enums.ShardArchiDetailStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardArchiRouteRepository;

public class ShardArchiRouteRepositoryImpl
implements ShardArchiRouteRepository {
    public static final ShardArchiRouteRepositoryImpl instance = new ShardArchiRouteRepositoryImpl();

    @Override
    public List<ShardArchiRouteEntity> loadShardArchiRouteList() {
        return this.loadShardArchiDetailWithCondition(null);
    }

    private List<ShardArchiRouteEntity> loadShardArchiDetailWithCondition(String condition) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" fid,fversion,farchiconfigid,fentitynumber,findex,foriginaltable,fshardtable, ");
            sql.append(" foriginal_route,ftarget_route,fstatus,farchivefield ");
            sql.append(" from t_cbs_shard_archi_route ");
            if (condition != null) {
                sql.append(" where ").append(condition);
            }
            return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), rs -> {
                ArrayList<ShardArchiRouteEntity> ret = new ArrayList<ShardArchiRouteEntity>(100);
                while (rs.next()) {
                    ShardArchiRouteEntity archiDetailEntity = new ShardArchiRouteEntity();
                    archiDetailEntity.setId(rs.getLong(1));
                    archiDetailEntity.setVersioin(rs.getLong(2));
                    archiDetailEntity.setArchiConfigId(rs.getLong(3));
                    archiDetailEntity.setEntityNumber(rs.getString(4));
                    archiDetailEntity.setIndex(rs.getLong(5));
                    archiDetailEntity.setOriginalTable(rs.getString(6));
                    archiDetailEntity.setShardTable(rs.getString(7));
                    archiDetailEntity.setOriginalRoute(rs.getString(8));
                    archiDetailEntity.setTargetRoute(rs.getString(9));
                    archiDetailEntity.setDetailStatusEnum(ShardArchiDetailStatusEnum.from(rs.getString(10)));
                    archiDetailEntity.setArchivefield(rs.getString(11));
                    ret.add(archiDetailEntity);
                }
                return ret;
            });
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    @Override
    public List<ShardArchiRouteEntity> loadShardArchiRouteList(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        return this.loadShardArchiDetailWithCondition(condition);
    }

    @Override
    public List<ShardArchiRouteEntity> loadShardArchiRouteListByVersion(String entityNumber, long version) {
        String condition = " fentitynumber = '" + entityNumber + "'  and fversion = '" + version + "' ";
        return this.loadShardArchiDetailWithCondition(condition);
    }
}

