/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardLogEntity;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.mq.OperationLogBody;
import kd.bos.xdb.repository.ShardLogRepository;
import kd.bos.xdb.util.DateUtil;

public class ShardLogRepositoryImpl
implements ShardLogRepository {
    private static final Log logger = LogFactory.getLog(ShardLogRepositoryImpl.class);
    public static final ShardLogRepositoryImpl instance = new ShardLogRepositoryImpl();

    @Override
    public void insertOperationLog(long taskId, String entityName, String log, String progresstype) {
        String sql = "insert into t_cbs_shard_log(fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime) values (?,?,?,?,?,?)";
        sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
        if (null == progresstype) {
            progresstype = "";
        }
        SimpleDateFormat sdf = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
        log = "[" + sdf.format(new Date()) + "] " + log;
        long id = IDUtil.id();
        int N = 1333;
        if (log.length() > 1333) {
            log = log.substring(0, 1333);
        }
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{id, taskId, entityName, log, progresstype, new Date()});
        if (logger.isInfoEnabled()) {
            XDBManagerUtil.logInfo(MessageFormat.format("XdbTaskMovingLog, taskId:{0}, entitynumber:{1}, progresstype:{2}, log:{3}", taskId, entityName, progresstype, log));
        }
    }

    @Override
    public void insertOperationLog(OperationLogBody logBody) {
        String sql = "insert into t_cbs_shard_log(fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime) values (?,?,?,?,?,?)";
        sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{logBody.getId(), logBody.getTaskId(), logBody.getEntityName(), logBody.getLog(), logBody.getProgresstype(), logBody.getDate()});
        if (logger.isInfoEnabled()) {
            XDBManagerUtil.logInfo(MessageFormat.format("XdbTaskMovingLog,taskId:{0}, entitynumber:{1}, progresstype:{2}, log:{3}", logBody.getTaskId(), logBody.getEntityName(), logBody.getProgresstype(), logBody.getLog()));
        }
    }

    @Override
    public ShardLogEntity loadLatestLog(long taskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1 ");
        sql.append(" fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime ");
        sql.append(" from t_cbs_shard_log where ftaskid = ? ");
        sql.append(" order by fid desc ");
        return (ShardLogEntity)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{taskid}, rs -> {
            if (rs.next()) {
                ShardLogEntity logEntity = new ShardLogEntity();
                logEntity.setId(rs.getLong("fid"));
                logEntity.setTaskid(rs.getLong("ftaskid"));
                logEntity.setEntitynumber(rs.getString("fentitynumber"));
                logEntity.setOperationlog(rs.getString("foperationlog"));
                logEntity.setProgresstype(rs.getString("fprogresstype"));
                logEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                return logEntity;
            }
            return null;
        });
    }

    @Override
    public ShardLogEntity loadLatestLog(String entitynumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select top 1 ");
        sql.append(" fid,ftaskid,fentitynumber,foperationlog,fprogresstype,fcreatetime ");
        sql.append(" from t_cbs_shard_log where fentitynumber = ? ");
        sql.append(" order by fid desc ");
        return (ShardLogEntity)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entitynumber}, rs -> {
            if (rs.next()) {
                ShardLogEntity logEntity = new ShardLogEntity();
                logEntity.setId(rs.getLong("fid"));
                logEntity.setTaskid(rs.getLong("ftaskid"));
                logEntity.setEntitynumber(rs.getString("fentitynumber"));
                logEntity.setOperationlog(rs.getString("foperationlog"));
                logEntity.setProgresstype(rs.getString("fprogresstype"));
                logEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                return logEntity;
            }
            return null;
        });
    }
}

