/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.repository.ShardProgressRepository;

public class ShardProgressRepositoryImpl
implements ShardProgressRepository {
    public static final ShardProgressRepositoryImpl instance = new ShardProgressRepositoryImpl();

    @Override
    public List<ShardProgressEntity> loadUnexecutedProgressList(long taskId, String condition) {
        StringBuilder sql = new StringBuilder();
        sql.append(" ftaskid = ").append(taskId);
        sql.append(" and ftaskstatus in('").append(ShardTaskStatusEnum.UNEXECUTED.getKey()).append("')");
        if (condition != null) {
            sql.append(" and ").append(condition);
        }
        return this.loadProgressList(sql.toString(), " order by fshard_total_record asc,fshard_index asc ");
    }

    @Override
    public ShardProgressEntity loadProgress(long id) {
        String condition = " fid = " + id;
        List<ShardProgressEntity> ret = this.loadProgressList(condition, null);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ShardProgressEntity> loadProgressList(long taskId) {
        String condition = " ftaskid = " + taskId;
        return this.loadProgressList(condition, null);
    }

    public List<ShardProgressEntity> loadProgressList(String condition, String orderStr) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,ftaskid,fentitynumber,fshard_table,fshard_total_record,fshard_moving_record,fshard_index,fcreatetime,fmodifytime ");
        sql.append(" ,ftaskstatus,fstarttime,fendtime,fprogresssign,foriginalroute,ftargetroute ");
        sql.append(" from t_cbs_shard_progress ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        if (orderStr != null) {
            sql.append(orderStr);
        } else {
            sql.append(" order by fid asc ");
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            ArrayList<ShardProgressEntity> ret = new ArrayList<ShardProgressEntity>(100);
            while (rs.next()) {
                ShardProgressEntity progressEntity = new ShardProgressEntity();
                progressEntity.setId(rs.getLong(1));
                progressEntity.setTaskid(rs.getLong(2));
                progressEntity.setEntitynumber(rs.getString(3));
                progressEntity.setShardTable(rs.getString(4));
                progressEntity.setShardTotalRecord(rs.getLong(5));
                progressEntity.setShardMovingRecord(rs.getLong(6));
                progressEntity.setShardIndex(rs.getLong(7));
                progressEntity.setCreatetime(rs.getTimestamp(8));
                progressEntity.setModifytime(rs.getTimestamp(9));
                progressEntity.setTaskstatus(ShardTaskStatusEnum.from(rs.getString(10)));
                progressEntity.setStarttime(rs.getTimestamp(11));
                progressEntity.setEndtime(rs.getTimestamp(12));
                progressEntity.setProgresssign(rs.getString(13));
                progressEntity.setOriginalRoute(rs.getString(14));
                progressEntity.setTargetRoute(rs.getString(15));
                ret.add(progressEntity);
            }
            return ret;
        });
    }

    @Override
    public ShardProgressEntity loadProgress(long taskId, String shardTable) {
        String condition = " ftaskid = " + taskId + " and fshard_table = '" + shardTable + "' ";
        List<ShardProgressEntity> ret = this.loadProgressList(condition, null);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setProgressPause(long ftaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.PAUSE.getKey(), ftaskid, ShardTaskStatusEnum.EXECUTING.getKey()});
    }

    @Override
    public int setProgressContinue(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setProgressTerminated(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.TERMINATED.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setProgressUnexecuted(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), taskId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setProgressSuspended(long progressId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.SUSPENDED.getKey(), progressId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setProgressSuspendedByTaskId(long ftaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.SUSPENDED.getKey(), ftaskid, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setProgressFailedByTaskId(long ftaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?) ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.FAILED.getKey(), ftaskid, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setProgressFaileByProgressId(long progressId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.FAILED.getKey(), progressId, ShardTaskStatusEnum.EXECUTING.getKey()});
    }

    @Override
    public int updateProgressSuccess(long progressId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?) ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(ShardTaskStatusEnum.SUCCESS.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(progressId);
        paramList.add(ShardTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ShardTaskStatusEnum.PAUSE.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public long countProgressUnclosed(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_shard_progress ");
        sql.append(" where ftaskid = ? and ftaskstatus != ? ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(taskId);
        paramList.add(ShardTaskStatusEnum.SUCCESS.getKey());
        Object[] params = paramList.toArray();
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public int updateExecuting(long progressId) {
        return this.setTaskstatus(progressId, ShardTaskStatusEnum.UNEXECUTED, ShardTaskStatusEnum.EXECUTING, true, false);
    }

    private int setTaskstatus(long progressId, ShardTaskStatusEnum curTaskstatus, ShardTaskStatusEnum nextTaskstatus, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_progress ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        if (isStart) {
            sql.append(", fstarttime = ? ");
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (isStart) {
            paramList.add(new Date());
        }
        if (isEnd) {
            paramList.add(new Date());
        }
        paramList.add(progressId);
        paramList.add(curTaskstatus.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }
}

