/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.xdb.entity.ShardSplitTaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.service.analysis.entity.SplitInfo;

public class ShardSplitTaskRepositoryImpl
implements ShardSplitTaskRepository {
    public static final ShardSplitTaskRepositoryImpl instance = new ShardSplitTaskRepositoryImpl();

    @Override
    public List<ShardSplitTaskEntity> loadUnexecutedSplitTaskList(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" ftaskid = ?");
        sql.append(" and ftaskstatus = ?");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(taskId);
        paramList.add(ShardTaskStatusEnum.UNEXECUTED.getKey());
        return this.loadSplitTaskList(sql.toString(), paramList);
    }

    private List<ShardSplitTaskEntity> loadSplitTaskList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,ftaskid,fentitynumber,fnum,fheadpk,ftailpk,ftotalcount,ftaskstatus, ");
        sql.append(" fremark,fstarttime,fendtime,fprogresssign,fcreatetime,fmodifytime ");
        sql.append(" from t_cbs_shard_splittask ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        sql.append(" order by fnum asc ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(), rs -> {
            ArrayList<ShardSplitTaskEntity> ret = new ArrayList<ShardSplitTaskEntity>(100);
            while (rs.next()) {
                ShardSplitTaskEntity splitEntity = new ShardSplitTaskEntity();
                splitEntity.setId(rs.getLong("fid"));
                splitEntity.setTaskid(rs.getLong("ftaskid"));
                splitEntity.setEntitynumber(rs.getString("fentitynumber"));
                splitEntity.setNum(rs.getInt("fnum"));
                splitEntity.setHeadpk(rs.getString("fheadpk"));
                splitEntity.setTailpk(rs.getString("ftailpk"));
                splitEntity.setTotalcount(rs.getLong("ftotalcount"));
                splitEntity.setTaskstatus(ShardTaskStatusEnum.from(rs.getString("ftaskstatus")));
                splitEntity.setRemark(rs.getString("fremark"));
                splitEntity.setStarttime(rs.getTimestamp("fstarttime"));
                splitEntity.setEndtime(rs.getTimestamp("fendtime"));
                splitEntity.setProgresssign(rs.getString("fprogresssign"));
                splitEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                splitEntity.setModifytime(rs.getTimestamp("fmodifytime"));
                ret.add(splitEntity);
            }
            return ret;
        });
    }

    @Override
    public ShardSplitTaskEntity loadSplitTask(long taskId) {
        String condition = " fid = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(taskId);
        List<ShardSplitTaskEntity> ret = this.loadSplitTaskList(condition, paramList);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public List<ShardSplitTaskEntity> loadSplitTaskList(long taskId) {
        String condition = " ftaskid = ?";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(taskId);
        return this.loadSplitTaskList(condition, paramList);
    }

    @Override
    public int setSplitTaskPause(long ftaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.PAUSE.getKey(), ftaskid, ShardTaskStatusEnum.EXECUTING.getKey()});
    }

    @Override
    public int setSplitTaskTerminated(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.TERMINATED.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setSplitTaskContinue(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setSplitTaskUnexecuted(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), subTaskid, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setSplitTaskSuspended(long progressId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.SUSPENDED.getKey(), progressId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setSplitTaskFailedByTaskId(long ftaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where ftaskid = ? and ftaskstatus in(?,?) ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.FAILED.getKey(), ftaskid, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int updateSplitTaskSuccess(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?) ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(ShardTaskStatusEnum.SUCCESS.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(subTaskid);
        paramList.add(ShardTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ShardTaskStatusEnum.PAUSE.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public int setNextSplitTaskstatus(long taskId, ShardTaskStatusEnum curTaskstatus, ShardTaskStatusEnum nextTaskstatus) {
        return this.setTaskstatus(taskId, curTaskstatus, nextTaskstatus, false, false);
    }

    @Override
    public long countSplitTaskUnclosed(long subTaskid) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_shard_splittask ");
        sql.append(" where ftaskid = ? and ftaskstatus != ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(subTaskid);
        paramList.add(ShardTaskStatusEnum.SUCCESS.getKey());
        Object[] params = paramList.toArray();
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public int updateSplitTaskExecuting(long subTaskid) {
        return this.setTaskstatus(subTaskid, ShardTaskStatusEnum.UNEXECUTED, ShardTaskStatusEnum.EXECUTING, true, false);
    }

    private int setTaskstatus(long subTaskid, ShardTaskStatusEnum curTaskstatus, ShardTaskStatusEnum nextTaskstatus, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_splittask ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        if (isStart) {
            sql.append(", fstarttime = ? ");
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (isStart) {
            paramList.add(new Date());
        }
        if (isEnd) {
            paramList.add(new Date());
        }
        paramList.add(subTaskid);
        paramList.add(curTaskstatus.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public void deleteSplitTask(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from t_cbs_shard_splittask ");
        sql.append(" where ftaskid = ? ");
        DB.execute((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{taskId});
    }

    @Override
    public void insertSplitTask(long taskId, String entitynumber, List<SplitInfo> splitList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_shard_splittask (");
        sql.append(" fid,ftaskid,fentitynumber,fnum,fheadpk,ftailpk,fremark,");
        sql.append(" ftotalcount,ftaskstatus,fcreatetime ");
        sql.append(" )values (?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(splitList.size());
        for (int i = 0; i < splitList.size(); ++i) {
            ArrayList<Object> obj = new ArrayList<Object>(12);
            obj.add(ID.genLongId());
            obj.add(taskId);
            obj.add(entitynumber);
            SplitInfo splitInfo = splitList.get(i);
            obj.add(splitInfo.getNum());
            obj.add(splitInfo.getHeadPk());
            obj.add(splitInfo.getTailPk());
            obj.add(splitInfo.getRemark());
            obj.add(splitInfo.getTotalCount());
            obj.add(ShardTaskStatusEnum.UNEXECUTED.getKey());
            obj.add(new Date());
            paramList.add(obj.toArray());
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql.toString(), true, true), paramList);
    }
}

