/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.enums.ShardTaskWarningStatusEnum;
import kd.bos.xdb.repository.ShardTaskRepository;

public class ShardTaskRepositoryImpl
implements ShardTaskRepository {
    public static final ShardTaskRepositoryImpl instance = new ShardTaskRepositoryImpl();

    @Override
    public List<ShardTaskEntity> loadUnexecutedTaskList(String condition) {
        StringBuilder sql = new StringBuilder();
        sql.append(" where ftaskstatus in('").append(ShardTaskStatusEnum.UNEXECUTED.getKey()).append("','").append(ShardTaskStatusEnum.PAUSE.getKey()).append("')");
        if (condition != null) {
            sql.append(" and ").append(condition);
        }
        return this.loadTaskList(sql.toString());
    }

    @Override
    public List<ShardTaskEntity> loadRunningTaskList() {
        StringBuilder sql = new StringBuilder();
        sql.append(" where ftaskstatus = '").append(ShardTaskStatusEnum.EXECUTING.getKey()).append("'");
        return this.loadTaskList(sql.toString());
    }

    @Override
    public ShardTaskEntity loadUnexecutedTask(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        List<ShardTaskEntity> ret = this.loadUnexecutedTaskList(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    public List<ShardTaskEntity> loadTaskList(String condition) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fentitynumber,ftasktype,ftasknode,ftaskstatus,fwarningstatus,fstarttime,fendtime,fcount,frunnode, ");
        sql.append(" fprogress,fprogressdesc,fprogresssign,fcreatetime,fmodifytime,ftotal_record,fmoving_record,fconfigid, ");
        sql.append(" fversion,fhost,frunhost,fruninstance,ffastindex,flastfastindex ");
        sql.append(" from t_cbs_shard_task ");
        if (condition != null) {
            sql.append(condition);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), rs -> {
            ArrayList<ShardTaskEntity> ret = new ArrayList<ShardTaskEntity>(100);
            while (rs.next()) {
                ShardTaskEntity taskEntity = new ShardTaskEntity();
                taskEntity.setId(rs.getLong("fid"));
                taskEntity.setEntitynumber(rs.getString("fentitynumber"));
                taskEntity.setTasktype(ShardTaskTypeEnum.from(rs.getString("ftasktype")));
                taskEntity.setTasknode(ShardTaskNodeEnum.from(rs.getString("ftasknode")));
                taskEntity.setTaskstatus(ShardTaskStatusEnum.from(rs.getString("ftaskstatus")));
                taskEntity.setWarningstatus(ShardTaskWarningStatusEnum.from(rs.getString("fwarningstatus")));
                taskEntity.setStarttime(rs.getTimestamp("fstarttime"));
                taskEntity.setEndtime(rs.getTimestamp("fendtime"));
                taskEntity.setCount(rs.getInt("fcount"));
                taskEntity.setRunnode(rs.getString("frunnode"));
                taskEntity.setProgress(rs.getString("fprogress"));
                taskEntity.setProgressdesc(rs.getString("fprogressdesc"));
                taskEntity.setProgresssign(rs.getString("fprogresssign"));
                taskEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                taskEntity.setModifytime(rs.getTimestamp("fmodifytime"));
                taskEntity.setTotalRecord(rs.getLong("ftotal_record"));
                taskEntity.setMovingRecord(rs.getLong("fmoving_record"));
                taskEntity.setConfigid(rs.getLong("fconfigid"));
                taskEntity.setVersion(rs.getInt("fversion"));
                taskEntity.setHost(rs.getString("fhost"));
                taskEntity.setRunHost(rs.getString("frunhost"));
                taskEntity.setRunInstance(rs.getString("fruninstance"));
                taskEntity.setFastIndex(rs.getString("ffastindex"));
                taskEntity.setLastFastIndex(rs.getString("flastfastindex"));
                ret.add(taskEntity);
            }
            return ret;
        });
    }

    @Override
    public ShardTaskEntity loadTask(long taskId) {
        String condition = " where fid = " + taskId + " ";
        List<ShardTaskEntity> ret = this.loadTaskList(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setNextTaskNode(long taskId, ShardTaskNodeEnum curNode, ShardTaskNodeEnum nextNode) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftasknode = ?, fwarningstatus = ? ");
        sql.append(" where fid = ? and ftasknode = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextNode.getKey(), ShardTaskWarningStatusEnum.NORMAL.getKey(), taskId, curNode.getKey()});
    }

    @Override
    public int setTaskWarningstatus(long taskId, ShardTaskNodeEnum curNode) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set fwarningstatus = ?, ftaskstatus = ? ");
        sql.append(" where fid = ? and ftasknode = ? and ftaskstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskWarningStatusEnum.TIMEOUT.getKey(), ShardTaskStatusEnum.SUSPENDED.getKey(), taskId, curNode.getKey(), ShardTaskStatusEnum.EXECUTING.getKey()});
    }

    @Override
    public int setTaskPause(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus = ? and ftasknode in(?,?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.PAUSE.getKey(), taskId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskNodeEnum.SLICEANALYSIS.getKey(), ShardTaskNodeEnum.DATAMOVE.getKey(), ShardTaskNodeEnum.INDEXMOVE.getKey()});
    }

    @Override
    public int setTaskContinue(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ?, fwarningstatus = ?");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), ShardTaskWarningStatusEnum.NORMAL.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setTaskTerminated(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.TERMINATED.getKey(), taskId, ShardTaskStatusEnum.SUSPENDED.getKey(), ShardTaskStatusEnum.FAILED.getKey()});
    }

    @Override
    public int setTaskUnexecuted(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.UNEXECUTED.getKey(), taskId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int setTaskSuspended(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?)");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ShardTaskStatusEnum.SUSPENDED.getKey(), taskId, ShardTaskStatusEnum.EXECUTING.getKey(), ShardTaskStatusEnum.PAUSE.getKey()});
    }

    @Override
    public int updateExecuting(long taskId, String frunnode, String runhost, String runinstance) {
        return this.setTaskstatus(taskId, ShardTaskStatusEnum.UNEXECUTED, ShardTaskStatusEnum.EXECUTING, frunnode, runhost, runinstance, true, false);
    }

    @Override
    public int updateSuccess(long taskId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ?,fwarningstatus = ?, fmodifytime = ? ");
        sql.append(", fendtime = ? ");
        sql.append(" where fid = ? and ftaskstatus in(?,?) ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(ShardTaskStatusEnum.SUCCESS.getKey());
        paramList.add(ShardTaskWarningStatusEnum.NORMAL.getKey());
        paramList.add(new Date());
        paramList.add(new Date());
        paramList.add(taskId);
        paramList.add(ShardTaskStatusEnum.EXECUTING.getKey());
        paramList.add(ShardTaskStatusEnum.PAUSE.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }

    @Override
    public int setNextTaskstatus(long taskId, ShardTaskStatusEnum curTaskstatus, ShardTaskStatusEnum nextTaskstatus) {
        return this.setTaskstatus(taskId, curTaskstatus, nextTaskstatus, null, null, null, false, false);
    }

    private int setTaskstatus(long taskId, ShardTaskStatusEnum curTaskstatus, ShardTaskStatusEnum nextTaskstatus, String frunnode, String runhost, String runinstance, boolean isStart, boolean isEnd) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_task ");
        sql.append(" set ftaskstatus = ?,fmodifytime = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(nextTaskstatus.getKey());
        paramList.add(new Date());
        if (!StringUtils.isEmpty((String)frunnode)) {
            sql.append(", frunnode = ? ");
            paramList.add(frunnode);
        }
        if (!StringUtils.isEmpty((String)runhost)) {
            sql.append(", frunhost = ? ");
            paramList.add(runhost);
        }
        if (!StringUtils.isEmpty((String)runinstance)) {
            sql.append(", fruninstance = ? ");
            paramList.add(runinstance);
        }
        if (isStart) {
            sql.append(", fstarttime = ? ");
            paramList.add(new Date());
        }
        if (isEnd) {
            sql.append(", fendtime = ? ");
            paramList.add(new Date());
        }
        sql.append(" where fid = ? and ftaskstatus = ? ");
        paramList.add(taskId);
        paramList.add(curTaskstatus.getKey());
        Object[] params = paramList.toArray();
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params);
    }
}

