/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.service;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.orm.ORM;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.tablemanager.meta.PkInfo;
import kd.bos.xdb.temptable.pk.PKTempTableHint;

public final class ActionUtil {
    private static final int LONG_QUERY_TIMEOUT_SECONDS = 3000;
    private static final int DEFAULT_QUERY_TIMEOUT_SECONDS = XDBConfig.get().getQueryTimeoutSeconds();
    private static final AtomicInteger handlerCount = new AtomicInteger();

    public static long countTableRecord(DBRoute route, String tableName) {
        String sql = ActionUtil.wrapSQL("select count(1) c from " + tableName, true, true);
        if (DB.exitsTable((DBRoute)route, (String)tableName)) {
            return (Long)DB.query((DBRoute)route, (String)sql, rs -> {
                rs.next();
                return rs.getLong(1);
            });
        }
        return -1L;
    }

    public static void dropTable(DBRoute route, String tableName) {
        if (DB.exitsTable((DBRoute)route, (String)tableName)) {
            String sql = ActionUtil.wrapSQL("drop table " + tableName, true, true);
            DB.execute((DBRoute)route, (String)sql);
        }
    }

    public static void truncateTable(DBRoute route, String tableName) {
        if (DB.exitsTable((DBRoute)route, (String)tableName)) {
            String sql = ActionUtil.wrapSQL("truncate table " + tableName, true, true);
            DB.execute((DBRoute)route, (String)sql);
        }
    }

    public static void backupTable(DBRoute route, String tableName) {
        kd.bos.xdb.datasource.DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        if (DB.exitsTableForManager((DBRoute)route, (String)tableName)) {
            MetaFactory.getMeta().renameTable(tableName, tableName + "$bak");
        }
        ActionUtil.clearAllIndex(dbType, tableName + "$BAK");
    }

    static void clearAllIndex(kd.bos.xdb.datasource.DBType dbType, String tableName) {
        switch (dbType) {
            case derby: 
            case mysql: 
            case tdsql: 
            case tidb: {
                break;
            }
            case dm: 
            case oracle: 
            case yasdb: 
            case oceanbase_oracle: 
            case hana: 
            case postgresql: 
            case gs: 
            case gs100: 
            case gaussdb: 
            case gauss200: 
            case gbase: 
            case kingbase: 
            case vastbase: 
            case sqlserver: {
                PkInfo pkInfo = MetaFactory.getMeta().queryPkInfo(tableName);
                if (pkInfo != null && pkInfo.getIndexName() != null) {
                    MetaFactory.getMeta().dropPkIndex(tableName, pkInfo.getIndexName());
                }
                List indexInfoList = MetaFactory.getMeta().queryIndexInfos(tableName);
                for (IndexInfo indexInfo : indexInfoList) {
                    MetaFactory.getMeta().dropIndex(tableName, indexInfo.getIndexName());
                }
                break;
            }
        }
    }

    static void dropTableIndex(DBRoute dbRoute, String tableName, List<String> indexNames) {
        for (String indexName : indexNames) {
            StringBuilder dropTableIndex = new StringBuilder(256);
            dropTableIndex.append("EXEC p_DropIdx '");
            dropTableIndex.append(indexName);
            dropTableIndex.append("', '");
            dropTableIndex.append(tableName);
            dropTableIndex.append("';");
            String sql = ActionUtil.wrapSQL(dropTableIndex.toString(), false, true);
            DB.execute((DBRoute)dbRoute, (String)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startConfig() {
        AtomicInteger atomicInteger = handlerCount;
        synchronized (atomicInteger) {
            int c = handlerCount.incrementAndGet();
            if (c == 1) {
                XDBConfig xconfig = XDBConfig.get();
                xconfig.setQueryTimeoutSeconds(3000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endConfig() {
        AtomicInteger atomicInteger = handlerCount;
        synchronized (atomicInteger) {
            int c = handlerCount.decrementAndGet();
            if (c == 0) {
                XDBConfig xconfig = XDBConfig.get();
                xconfig.setQueryTimeoutSeconds(DEFAULT_QUERY_TIMEOUT_SECONDS);
            }
        }
    }

    public static String wrapSQL(String sql, boolean dialect, boolean noSharding) {
        if (noSharding) {
            sql = NoShardingHint.genNoShardingSQL((String)sql);
        }
        if (dialect) {
            sql = "/*dialect*/" + sql;
        }
        return sql;
    }

    public static String joinArray(String[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static int findPkindexInShardfields(String[] array, String delim) {
        int index = -1;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (!array[i].equalsIgnoreCase(delim)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void wrapSqlBuilderExecute(DBRoute dbRoute, SqlBuilder sqlBuilder) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        if (dbType == DBType.MySQL) {
            try (PKTempTableHint hint = PKTempTableHint.skip();){
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
            }
        } else {
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        }
    }

    public static PkTypeEnum getPkTypeEnum(String entitynumber) {
        ISimpleProperty property = ORM.create().getDataEntityType(entitynumber).getPrimaryKey();
        PkTypeEnum type = null;
        type = property.getPropertyType() == String.class ? PkTypeEnum.pk_string : PkTypeEnum.pk_long;
        return type;
    }

    public static PKTempTableType getPKTempTableTypeEnum(String entitynumber) {
        PkTypeEnum pkTypeEnum = ActionUtil.getPkTypeEnum(entitynumber);
        if (pkTypeEnum == PkTypeEnum.pk_string) {
            return PKTempTableType.PK_BIGSTRING;
        }
        return PKTempTableType.PK_LONG;
    }

    public static void renameTable(String fromTable, String toTable) {
        MetaFactory.getMeta().renameTable(fromTable, toTable);
    }

    public static void renameTable(String fromTable, String toTable, String route) {
        MetaFactory.getMeta().renameTable(route, fromTable, toTable);
    }
}

