/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.util.ConfigurationUtil;

public final class ShardTaskConfig {
    private static int shardingMovingThreads = 4;
    private static boolean enableMovingParallel = true;
    private static boolean enableMovingBackup = true;
    private static boolean enableStoreInTx = true;
    private static int movingParallelThreads = Runtime.getRuntime().availableProcessors() * 4;
    private static AtomicBoolean shardingMovingEnable = new AtomicBoolean(true);
    private static long interval = 5000L;
    private static Map<String, Set<String>> movingItems = new HashMap<String, Set<String>>();
    private static boolean enableCheckDuplicate = true;
    private static boolean shardingMovingDisableQuick = false;
    private static boolean enableMovingLog = false;
    private static boolean taskAbortRetryEnable = true;
    private static int taskRunningTimeOut = 10;
    private static int fastIndexCount = 6;
    private static boolean metaloadErrorIgnore = false;
    private static boolean configloadErrorIgnore = false;
    private static boolean configInitFromDetailEnable = true;
    private static boolean shardDisableOldMethodForce = false;
    private static long taskEmptyLoopTimes = 20L;

    public static void splitEntityName(String s, Map<String, Set<String>> map) {
        String accountId;
        int i = (s = s.trim()).indexOf(61);
        if (i != -1 && (accountId = s.substring(0, i).trim()).length() > 0) {
            if (s.endsWith("=")) {
                map.put(accountId, new HashSet());
            } else {
                String[] entityNames = s.substring(i + 1).split(",");
                HashSet<String> set = new HashSet<String>(entityNames.length);
                for (String name : entityNames) {
                    set.add(name.trim().toLowerCase());
                }
                map.put(accountId, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForShardingMovingEnable() {
        if (!shardingMovingEnable.get()) {
            AtomicBoolean atomicBoolean = shardingMovingEnable;
            synchronized (atomicBoolean) {
                while (!shardingMovingEnable.get()) {
                    try {
                        shardingMovingEnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static int getShardingMovingThreads() {
        return shardingMovingThreads;
    }

    public static boolean isEnableMovingParallel() {
        return enableMovingParallel;
    }

    public static void setEnableMovingParallel(boolean enableMovingParallel) {
        ShardTaskConfig.enableMovingParallel = enableMovingParallel;
    }

    public static boolean isEnableMovingBackup() {
        return enableMovingBackup;
    }

    public static void setEnableMovingBackup(boolean enableMovingBackup) {
        ShardTaskConfig.enableMovingBackup = enableMovingBackup;
    }

    public static boolean isEnableStoreInTx() {
        return enableStoreInTx;
    }

    public static void setEnableStoreInTx(boolean enableStoreInTx) {
        ShardTaskConfig.enableStoreInTx = enableStoreInTx;
    }

    public static int getMovingParallelThreads() {
        return movingParallelThreads;
    }

    public static void setMovingParallelThreads(int movingParallelThreads) {
        ShardTaskConfig.movingParallelThreads = movingParallelThreads;
    }

    public static long getInterval() {
        return interval;
    }

    public static boolean canMovingAccountId(String accountId) {
        return movingItems.isEmpty() || movingItems.containsKey(accountId);
    }

    public static boolean canMovingEntityName(String accountId, String entityName) {
        if (movingItems.isEmpty()) {
            return true;
        }
        Set<String> set = movingItems.get(accountId);
        if (set != null) {
            return set.contains("*") || set.contains(entityName);
        }
        return false;
    }

    public static boolean isEnableCheckDuplicate() {
        return enableCheckDuplicate;
    }

    public static void setEnableCheckDuplicate(boolean enableCheckDuplicate) {
        ShardTaskConfig.enableCheckDuplicate = enableCheckDuplicate;
    }

    public static boolean isEnableMovingLog() {
        return enableMovingLog;
    }

    public static void setEnableMovingLog(boolean enableMovingLog) {
        ShardTaskConfig.enableMovingLog = enableMovingLog;
    }

    public static boolean isShardingMovingDisableQuick() {
        return shardingMovingDisableQuick;
    }

    public static void setShardingMovingDisableQuick(boolean shardingMovingDisableQuick) {
        ShardTaskConfig.shardingMovingDisableQuick = shardingMovingDisableQuick;
    }

    public static boolean isTaskAbortRetryEnable() {
        return taskAbortRetryEnable;
    }

    public static int getTaskRunningTimeOut() {
        return taskRunningTimeOut;
    }

    public static int getFastIndexCount() {
        return fastIndexCount;
    }

    public static boolean isMetaloadErrorIgnore() {
        return metaloadErrorIgnore;
    }

    public static boolean isConfigloadErrorIgnore() {
        return configloadErrorIgnore;
    }

    public static boolean isConfigInitFromDetailEnable() {
        return configInitFromDetailEnable;
    }

    public static long getTaskEmptyLoopTimes() {
        return taskEmptyLoopTimes;
    }

    public static boolean isShardDisableOldMethodForce() {
        return shardDisableOldMethodForce;
    }

    static {
        shardingMovingThreads = Integer.parseInt(System.getProperty("xdb.shardingmoving.threads", String.valueOf(shardingMovingThreads)));
        enableMovingParallel = Boolean.parseBoolean(System.getProperty("xdb.shardingmoving.parallel.enable", "true"));
        enableMovingBackup = Boolean.parseBoolean(System.getProperty("xdb.shardingmoving.backup.enable", "true"));
        ConfigurationUtil.observeBoolean((String)"xdbmanager.store.intx.enable", (boolean)true, v -> {
            enableStoreInTx = v;
        });
        shardingMovingDisableQuick = Boolean.parseBoolean(System.getProperty("xdb.shardingmoving.disable.quick", "false"));
        movingParallelThreads = Integer.parseInt(System.getProperty("xdb.shardingmoving.parallel.threads", String.valueOf(movingParallelThreads)));
        ConfigurationUtil.observeBoolean((String)"xdb.shardingmoving.enable", (boolean)shardingMovingEnable.get(), v -> {
            shardingMovingEnable.set((boolean)v);
            AtomicBoolean atomicBoolean = shardingMovingEnable;
            synchronized (atomicBoolean) {
                shardingMovingEnable.notifyAll();
            }
        });
        ConfigurationUtil.observeLong((String)"xdb.shardingmoving.interval", (long)interval, v -> {
            interval = v;
        });
        ConfigurationUtil.observeString((String)"xdb.shardingmoving.items", (String)"", v -> {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
            if (v != null && v.length() > 0) {
                String[] ss;
                for (String s : ss = v.split(";")) {
                    ShardTaskConfig.splitEntityName(s, map);
                }
            }
            movingItems = map;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.manager.check.duplicate", (boolean)true, v -> {
            enableCheckDuplicate = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.manager.moving.log", (boolean)false, v -> {
            enableMovingLog = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdbmanager.task.abort.retry.enable", (boolean)true, v -> {
            taskAbortRetryEnable = v;
        });
        ConfigurationUtil.observeInteger((String)"xdbmanager.task.running.time.out", (int)10, v -> {
            taskRunningTimeOut = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.moving.fastIndex.count", (int)fastIndexCount, v -> {
            fastIndexCount = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdbmanager.metaload.error.ignore", (boolean)false, v -> {
            metaloadErrorIgnore = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdbmanager.configload.error.ignore", (boolean)false, v -> {
            configloadErrorIgnore = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdbmanager.configinit.fromdetail.enable", (boolean)true, v -> {
            configInitFromDetailEnable = v;
        });
        ConfigurationUtil.observeLong((String)"xdbmanager.task.empty.loop.times", (long)20L, v -> {
            taskEmptyLoopTimes = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.manager.shardDisable.oldmethod", (boolean)false, v -> {
            shardDisableOldMethodForce = v;
        });
    }
}

