/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.service;

import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.BosRes;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContext;
import kd.bos.context.OperationContextCreator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.util.AppUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.changetask.ShardChangeTaskInfo;
import kd.bos.xdb.changetask.ShardChangeTaskNotifier;
import kd.bos.xdb.entity.ShardLogEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardLogRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.TaskContainer;
import kd.bos.xdb.task.TaskContainerRunner;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.bos.xdb.xpm.MetricCleanService;

public class ShardTaskService {
    private static final Log log = LogFactory.getLog(ShardTaskService.class);
    private static final long LOCK_TIMEOUT = 120000L;
    public static final String XDB_MVTASK_RUNNING_APPID = System.getProperty("xdb.mvtask.running.appid", "bos");
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String SHARD_TASK_EMPTY_CACHE_KEY = "shard_task_empty";
    private static final String SHARD_TASK_ERROR_CACHE_KEY = "shard_task_error";
    private static Map<String, Boolean> errorAccountMap = new ConcurrentHashMap<String, Boolean>(3);
    private static ShardTaskService instance = new ShardTaskService();
    private volatile boolean terminal = false;
    private ThreadPoolExecutor es = new ThreadPoolExecutor(ShardTaskConfig.getShardingMovingThreads(), ShardTaskConfig.getShardingMovingThreads(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Set<String> movingEntitySet = new ConcurrentHashSet();
    private final Object waitForTaskFinish = new Object();
    private final Object waitForTaskNew = new Object();
    private final AtomicInteger runningTaskCount = new AtomicInteger();
    private static List<RequestContext> rcList = new CopyOnWriteArrayList<RequestContext>();
    private static final String ZK_URL = System.getProperty("configUrl");

    public static ShardTaskService get() {
        return instance;
    }

    public static String getShardTaskLockKey(String accountId, String entityName) {
        return "/xdbsharding/task_dispatch/" + accountId + "/" + entityName;
    }

    public void start() {
        if (DB.isEnableSharding() && this.isCurrentNodeDeployApp(XDB_MVTASK_RUNNING_APPID)) {
            XDBManagerUtil.logInfo("start sharding moving task service...");
            this.terminal = false;
            Timer timer = new Timer("XDB-MOVE-TASK", true);
            timer.schedule(ThreadLifeCycleManager.wrapTimerTask(() -> {
                ShardTaskConfig.waitForShardingMovingEnable();
                boolean allAccountTaskEmpty = true;
                for (RequestContext rc : rcList) {
                    Boolean errorBoolean = errorAccountMap.get(rc.getAccountId());
                    int taskEmptyLoopTimes = 0;
                    if (errorBoolean != null && errorBoolean.booleanValue()) {
                        String cacheErrorKey = ShardTaskService.getTaskErrorCachkey(rc.getTenantId(), rc.getAccountId());
                        String cacheErrorValue = (String)cache.get(cacheErrorKey);
                        if (cacheErrorValue != null && !"null".equals(cacheErrorValue)) {
                            taskEmptyLoopTimes = Integer.parseInt(cacheErrorValue);
                        }
                    } else {
                        String cacheKey = ShardTaskService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
                        String cacheValue = (String)cache.get(cacheKey);
                        if (cacheValue != null && !"null".equals(cacheValue)) {
                            taskEmptyLoopTimes = Integer.parseInt(cacheValue);
                        }
                    }
                    if ((long)taskEmptyLoopTimes > ShardTaskConfig.getTaskEmptyLoopTimes()) continue;
                    allAccountTaskEmpty = false;
                    break;
                }
                if (allAccountTaskEmpty) {
                    Object object = this.waitForTaskNew;
                    synchronized (object) {
                        try {
                            this.waitForTaskNew.wait();
                        }
                        catch (InterruptedException rc) {
                            // empty catch block
                        }
                    }
                }
                for (RequestContext rc : rcList) {
                    String cacheErrorKey = ShardTaskService.getTaskErrorCachkey(rc.getTenantId(), rc.getAccountId());
                    String cacheKey = ShardTaskService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
                    RequestContext.copyAndSet((RequestContext)rc);
                    if (DB.isXDBEnable()) {
                        try {
                            this.dispatchTask(rc);
                        }
                        catch (Exception e) {
                            log.error("XdbMovingTaskError,tenantId=" + rc.getTenantId() + ",accountId=" + rc.getAccountId() + ":\t\n" + e.getMessage(), (Throwable)e);
                            cache.inc(cacheErrorKey, 2, TimeUnit.HOURS);
                            cache.remove(cacheKey);
                            errorAccountMap.put(rc.getAccountId(), true);
                        }
                        continue;
                    }
                    cache.inc(cacheKey, 2, TimeUnit.HOURS);
                }
            }), 30000L, ShardTaskConfig.getInterval());
            MetricCleanService.start(rcList);
            ShardChangeTaskNotifier.registerChangeTaskListener(di -> {
                log.info("[ShardChangeTaskNotifier] changeTaskListener " + di);
                ShardTaskService.get().fireHeartBeat(di);
            });
        }
    }

    public void stop() {
        if (DB.isEnableSharding() || !this.terminal) {
            XDBManagerUtil.logInfo("stop sharding moving task service...");
            this.terminal = true;
            this.fireTaskFinished();
            this.es.shutdown();
        }
        MetricCleanService.stop();
    }

    private boolean isCurrentNodeDeployApp(String string) {
        if (Instance.isAppSplit()) {
            String[] appids = Instance.getAppIds();
            if (appids == null) {
                return false;
            }
            for (String appid : appids) {
                if (!appid.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        String[] deployAppIds = Instance.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])deployAppIds);
        if (isCurrentDeployAlone) {
            for (String deployAppId : deployAppIds) {
                if (!string.equals(deployAppId)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandOver(ShardTaskEntity taskEntity, DLock lock, RequestContext rc, boolean isFinish) {
        block6: {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler onHandOver over, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}, isFinish:{4}", taskEntity.getId(), rc.getAccountId() + "#" + taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString(), isFinish));
            try {
                if (!isFinish) break block6;
                Set<String> set = this.movingEntitySet;
                synchronized (set) {
                    this.movingEntitySet.remove(rc.getAccountId() + "#" + taskEntity.getEntitynumber());
                }
                this.runningTaskCount.decrementAndGet();
                this.fireTaskFinished();
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler  onHandOver finish, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}", taskEntity.getId(), rc.getAccountId() + "#" + taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString()));
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTaskFinished() {
        Object object = this.waitForTaskFinish;
        synchronized (object) {
            this.waitForTaskFinish.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHeartBeat(ShardChangeTaskInfo ai) {
        String cacheKey = ShardTaskService.getTaskEmptyCachkey(ai.getTenantId(), ai.getAccountId());
        cache.remove(cacheKey);
        String cacheErrorKey = ShardTaskService.getTaskErrorCachkey(ai.getTenantId(), ai.getAccountId());
        cache.remove(cacheErrorKey);
        Object object = this.waitForTaskNew;
        synchronized (object) {
            this.waitForTaskNew.notifyAll();
        }
    }

    public void submitChangeTask(String recordName) {
        ShardChangeTaskNotifier.fireChangeTask(recordName);
    }

    public static String getTaskEmptyCachkey(String tenantId, String accountId) {
        return tenantId + "#" + accountId + "#" + SHARD_TASK_EMPTY_CACHE_KEY + "#" + Instance.getInstanceId();
    }

    public static String getTaskErrorCachkey(String tenantId, String accountId) {
        return tenantId + "#" + accountId + "#" + SHARD_TASK_ERROR_CACHE_KEY + "#" + Instance.getInstanceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchTask(RequestContext rc) {
        int maxTaskCount = this.es.getMaximumPoolSize();
        String cacheKey = ShardTaskService.getTaskEmptyCachkey(rc.getTenantId(), rc.getAccountId());
        while (!this.terminal && ShardTaskConfig.canMovingAccountId(rc.getAccountId())) {
            String cacheValue = (String)cache.get(cacheKey);
            int taskEmptyLoopTimes = 0;
            if (cacheValue != null && !"null".equals(cacheValue)) {
                taskEmptyLoopTimes = Integer.parseInt(cacheValue);
            }
            if ((long)taskEmptyLoopTimes > ShardTaskConfig.getTaskEmptyLoopTimes()) break;
            if (this.dispatchOneTask(rc)) {
                if (this.runningTaskCount.get() < maxTaskCount) {
                    try {
                        SecureRandom number = new SecureRandom();
                        Thread.sleep(number.nextInt(10000));
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                Object object = this.waitForTaskFinish;
                synchronized (object) {
                    if (this.runningTaskCount.get() < maxTaskCount) {
                        continue;
                    }
                    try {
                        this.waitForTaskFinish.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            cache.inc(cacheKey, 2, TimeUnit.HOURS);
            break;
        }
        if (!ShardTaskConfig.canMovingAccountId(rc.getAccountId())) {
            cache.inc(cacheKey, 2, TimeUnit.HOURS);
        }
    }

    private boolean dispatchOneTask(RequestContext rc) {
        try (TXHandle h = TX.requiresNew();
             DBAnyRWContext ctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();){
            List<ShardTaskEntity> unexecutedTaskList = ShardTaskRepository.get().loadUnexecutedTaskList(null);
            if (!unexecutedTaskList.isEmpty()) {
                if (this.doDispatchOneTask(unexecutedTaskList, rc)) {
                    boolean bl = true;
                    return bl;
                }
                this.doTaskAbort(rc);
            } else {
                this.doTaskAbort(rc);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTaskAbort(RequestContext rc) {
        if (!ShardTaskConfig.isTaskAbortRetryEnable()) {
            return;
        }
        List<ShardTaskEntity> runningTaskEntities = ShardTaskRepository.get().loadRunningTaskList();
        if (!runningTaskEntities.isEmpty()) {
            ORM orm = ORM.create();
            for (ShardTaskEntity taskEntity : runningTaskEntities) {
                String lockKey;
                DLock lock;
                if (!this.isTaskAbort(taskEntity, rc) || !(lock = DLock.create((String)(lockKey = ShardTaskService.getShardTaskLockKey(rc.getAccountId(), taskEntity.getEntitynumber())))).tryLock()) continue;
                try {
                    ShardTaskEntity curTaskEntity = ShardTaskRepository.get().loadTask(taskEntity.getId());
                    if (curTaskEntity.getTaskstatus() != ShardTaskStatusEnum.EXECUTING && curTaskEntity.getTaskstatus() != ShardTaskStatusEnum.PAUSE || !this.isTaskAbort(taskEntity, rc)) continue;
                    TXHandle tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        ShardProgressRepository.get().setProgressUnexecuted(taskEntity.getId());
                        ShardSplitTaskRepository.get().setSplitTaskUnexecuted(taskEntity.getId());
                        ShardTaskRepository.get().setTaskUnexecuted(taskEntity.getId());
                        String runhost = NetAddressUtils.getLocalIpAddress();
                        String runinstance = Instance.getInstanceId();
                        String runNode = "instance=" + runinstance + "@" + runhost;
                        ShardLogRepository.get().insertOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardTaskService_1", (String)"Background task retry operation, retry node: {0}", (Object[])new Object[]{runNode}), "MOVINGHANDLER");
                        IDataEntityType dt = orm.getDataEntityType(taskEntity.getEntitynumber());
                        ShardingManager.get().notifyLimitTaskPaused(curTaskEntity.getTaskstatus() == ShardTaskStatusEnum.PAUSE, dt.getAlias());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private boolean isTaskAbort(ShardTaskEntity taskEntity, RequestContext rc) {
        String entityKey = rc.getAccountId() + "#" + taskEntity.getEntitynumber();
        if (this.movingEntitySet.contains(entityKey)) {
            return false;
        }
        List instanceNodes = ClusterInstances.getAllInstanceNodes();
        ShardLogEntity shardLogEntity = ShardLogRepository.get().loadLatestLog(taskEntity.getEntitynumber());
        return !StringUtils.isEmpty((String)taskEntity.getRunInstance()) && !instanceNodes.contains(taskEntity.getRunInstance()) && shardLogEntity != null && (System.currentTimeMillis() - shardLogEntity.getCreatetime().getTime()) / 60000L > (long)ShardTaskConfig.getTaskRunningTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doDispatchOneTask(List<ShardTaskEntity> unexecutedTasks, RequestContext rc) {
        for (ShardTaskEntity taskEntity : unexecutedTasks) {
            Set<String> set;
            String entityKey;
            if (!ShardTaskConfig.canMovingEntityName(rc.getAccountId(), taskEntity.getEntitynumber()) || !this.isCanRunMov(taskEntity, entityKey = rc.getAccountId() + "#" + taskEntity.getEntitynumber())) continue;
            String lockKey = ShardTaskService.getShardTaskLockKey(rc.getAccountId(), taskEntity.getEntitynumber());
            DLock lock = DLock.create((String)lockKey);
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler doDispatchOneTasktrylock into,entitynumber:{0}, taskId:{1}, lockKey:{2} ", taskEntity.getEntitynumber(), taskEntity.getId(), lockKey));
            if (!lock.tryLock(120000L)) continue;
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler doDispatchOneTasklock into,entitynumber:{0}, taskId:{1}, lockKey:{2}", taskEntity.getEntitynumber(), taskEntity.getId(), lockKey));
            ShardTaskEntity curTaskEntity = ShardTaskRepository.get().loadUnexecutedTask(taskEntity.getEntitynumber());
            if (curTaskEntity == null || !this.isCanRunMov(curTaskEntity, entityKey)) {
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            String runhost = NetAddressUtils.getLocalIpAddress();
            if (!StringUtils.isEmpty((String)taskEntity.getHost()) && !runhost.equals(taskEntity.getHost())) {
                this.onHandOver(taskEntity, lock, rc, false);
                continue;
            }
            Set<String> set2 = this.movingEntitySet;
            synchronized (set2) {
                if (this.movingEntitySet.contains(entityKey)) {
                    this.onHandOver(taskEntity, lock, rc, false);
                    continue;
                }
                this.movingEntitySet.add(entityKey);
            }
            String runinstance = Instance.getInstanceId();
            String runNode = "instance=" + runinstance + "@" + runhost;
            try {
                int c;
                if (runinstance.length() > 50) {
                    runinstance = runinstance.substring(0, 50);
                }
                if (runNode.length() > 200) {
                    runNode = runNode.substring(0, 200);
                }
                if ((c = ShardTaskRepository.get().updateExecuting(taskEntity.getId(), runNode, runhost, runinstance)) <= 0) {
                    this.onHandOver(taskEntity, lock, rc, false);
                    set = this.movingEntitySet;
                    synchronized (set) {
                        this.movingEntitySet.remove(entityKey);
                        continue;
                    }
                }
            }
            catch (Exception e) {
                this.onHandOver(taskEntity, lock, rc, false);
                set = this.movingEntitySet;
                synchronized (set) {
                    this.movingEntitySet.remove(entityKey);
                }
                throw e;
            }
            this.es.submit(this.wrapRunnable(new TaskContainerRunner(new TaskContainer(this, curTaskEntity, lock, rc), curTaskEntity), rc));
            this.runningTaskCount.incrementAndGet();
            ShardLogPublish.get().publishOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), MessageFormat.format(BosRes.get((String)"bos-xdb-manager", (String)"ShardTaskService_0", (String)"Execute Node:", (Object[])new Object[0]) + "{0}, runningTaskCount:{1}, movingEntitySet:{2}", runNode, this.runningTaskCount, this.movingEntitySet.toString()), "MOVINGHANDLER");
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler executing submit on handler, taskId:{0}, entitynumber:{1}, runningTaskCount:{2}, movingEntitySet:{3}", taskEntity.getId(), taskEntity.getEntitynumber(), this.runningTaskCount, this.movingEntitySet.toString()));
            return true;
        }
        return false;
    }

    private boolean isCanRunMov(ShardTaskEntity taskEntity, String entityKey) {
        if (taskEntity.getTaskstatus() == ShardTaskStatusEnum.PAUSE) {
            IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)taskEntity.getEntitynumber(), null);
            TableName mainTN = TableName.of((String)rootDT.getAlias());
            ShardingManager.get().notifyLimitTaskPaused(true, mainTN.getAliasName());
            return false;
        }
        return taskEntity.getTaskstatus() == ShardTaskStatusEnum.UNEXECUTED && !this.movingEntitySet.contains(entityKey);
    }

    private Runnable wrapRunnable(Runnable r, RequestContext rc) {
        OperationContext oc = new OperationContext();
        oc.setAppId("xdb");
        return ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(r, rc, oc));
    }

    static {
        List<Object> allAccounts = new ArrayList();
        try {
            allAccounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception e) {
            allAccounts = Collections.emptyList();
            log.warn("ShardTaskService getAllAccountsOfCurrentEnv failed: " + e.getMessage(), (Throwable)e);
        }
        for (Account account : allAccounts) {
            RequestContext rc = RequestContext.create();
            rc.setAccountId(account.getAccountId());
            rc.setTenantId(account.getTenantId());
            rcList.add(rc);
        }
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            RequestContext rc = RequestContext.create((boolean)false);
                            rc.setTenantId(tenantListenerInfo.getTenantnumber());
                            rc.setAccountId(account.getAccountId());
                            rcList.add(rc);
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    XDBManagerUtil.logError("TenantListener onTenantAccountsAdded failed: " + e.getMessage(), e);
                }
            }

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            Iterator it = rcList.iterator();
                            while (it.hasNext()) {
                                RequestContext requestContext = (RequestContext)it.next();
                                if (!requestContext.getAccountId().equals(account.getAccountId()) || !requestContext.getTenantId().equals(tenantListenerInfo.getTenantnumber())) continue;
                                it.remove();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    XDBManagerUtil.logError("TenantListener onTenantAccountsRemoved failed: " + e.getMessage(), e);
                }
            }
        });
    }
}

