/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.service;

import com.google.common.collect.Multimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.progress.MainProgress;

public class ShardingTerminateServiceHelper {
    static TableManager tm;

    public static void dropShardingProcessTable(ShardTaskEntity taskEntity) {
        String entityNumber = taskEntity.getEntitynumber();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        List<ShardingConfig> shardingConfigs = configEntity.toShardingConfigs();
        IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
        DBRoute route = DBRoute.of((String)rootDT.getDBRouteKey());
        MainProgress sp = MainProgress.of(taskEntity.getId(), entityNumber, taskEntity.getProgresssign());
        try {
            DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)false, () -> {
                tm = XDBConfig.getTableManager();
                sp.setProgressType("ShardingTerminal");
                ShardingConfig mainShardingConfig = (ShardingConfig)shardingConfigs.get(0);
                String mainTable = mainShardingConfig.getTable();
                String[] movingTables = tm.getMovingTable(mainTable);
                ArrayList<String> movingTabList = new ArrayList<String>(Arrays.asList(movingTables));
                for (ShardingConfig sc : shardingConfigs) {
                    ShardingTerminateServiceHelper.dropShardingTables(route, sc, tm, sp);
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_0", (String)"Delete Intermediate Table", (Object[])new Object[0]));
                sp.store(true);
                for (String movingTable : movingTabList) {
                    ActionUtil.dropTable(route, movingTable);
                    tm.removeCahce(movingTable);
                    sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_1", (String)"Delete Intermediate Table: {0}", (Object[])new Object[]{movingTable}));
                    sp.store(true);
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionEnableDataMove_8", (String)"Delete Sub-table Intermediate Table", (Object[])new Object[0]));
                sp.store(true);
                Multimap<ShardingConfig, ShardingConfig> multimap = XDBManagerUtil.getGroupConfigs(shardingConfigs);
                Map map = multimap.asMap();
                for (Map.Entry entry : map.entrySet()) {
                    ShardingConfig key = (ShardingConfig)entry.getKey();
                    if (key instanceof MainTableConfig) continue;
                    for (String movingTable : movingTabList) {
                        TableName entryTN = TableName.of((String)movingTable);
                        String subMovingTable = TableName.of((String)key.getTable()).getMovingTable(entryTN.getMovingIndex());
                        ActionUtil.dropTable(route, subMovingTable);
                        tm.removeCahce(movingTable);
                    }
                }
                for (ShardingConfig shardingConfig : shardingConfigs) {
                    shardingConfig.setEnabled(false);
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_2", (String)"Migration is complete", (Object[])new Object[0]));
                sp.store(true);
                return null;
            });
        }
        catch (Exception e) {
            ShardTaskRepository.get().setNextTaskstatus(taskEntity.getId(), ShardTaskStatusEnum.TERMINATED, ShardTaskStatusEnum.SUSPENDED);
            ShardLogPublish.get().publishOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), "ShardingTerminal Failed", sp.getProgressType());
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    public static void dropShardingTables(DBRoute route, ShardingConfig shardingConfig, TableManager tm, MainProgress sp) throws SQLException {
        String tableName = shardingConfig.getTable();
        TableName tn = TableName.of((String)tableName);
        ActionUtil.dropTable(route, tn.getPrototypeTable());
        ActionUtil.dropTable(route, tn.getOriginalsnapTable());
        sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_0", (String)"Delete Prototype Table: {0}", (Object[])new Object[]{tn.getPrototypeTable()}));
        sp.store(true);
        if (shardingConfig instanceof MainTableConfig) {
            ActionUtil.dropTable(route, tn.getMapTable());
            sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_1", (String)"Delete Map Table: {0}", (Object[])new Object[]{tn.getMapTable()}));
            sp.store(true);
            ActionUtil.dropTable(route, tn.getPKTable());
            sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_2", (String)"Delete Pk Table: {0}", (Object[])new Object[]{tn.getPKTable()}));
            sp.store(true);
        }
        tm.clearCahce(tableName);
        for (String sharingTable : tm.getShardingTable(tableName)) {
            ActionUtil.dropTable(route, sharingTable);
            sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_3", (String)"Delete Shard Table: {0}", (Object[])new Object[]{sharingTable}));
            sp.store(true);
        }
    }

    public static void dropMoveIndexProcessTable(ShardTaskEntity taskEntity) {
        String entityNumber = taskEntity.getEntitynumber();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        List<ShardingConfig> shardingConfigs = configEntity.toShardingConfigs();
        IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
        DBRoute route = DBRoute.of((String)rootDT.getDBRouteKey());
        MainProgress sp = MainProgress.of(taskEntity.getId(), entityNumber, taskEntity.getProgresssign());
        try {
            DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)false, () -> {
                tm = XDBConfig.getTableManager();
                sp.setProgressType("MoveIndexTerminal");
                ShardingConfig mainShardingConfig = (ShardingConfig)shardingConfigs.get(0);
                String mainTable = mainShardingConfig.getTable();
                TableName tn = TableName.of((String)mainTable);
                String[] movingTables = tm.getMovingTable(mainTable);
                ArrayList<String> movingTabList = new ArrayList<String>(Arrays.asList(movingTables));
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_0", (String)"Delete Intermediate Table", (Object[])new Object[0]));
                sp.store(true);
                if (movingTabList.isEmpty()) {
                    String movingTable = tn.getMovingTable(-1L);
                    ShardingTerminateServiceHelper.deleteWithSetProgress(sp, route, movingTable);
                } else {
                    for (String movingTable : movingTabList) {
                        ShardingTerminateServiceHelper.deleteWithSetProgress(sp, route, movingTable);
                    }
                }
                MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(taskEntity.getEntitynumber());
                Set allShardRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
                allShardRoutes.add(route.getRouteKey());
                for (String routeStr : allShardRoutes) {
                    ActionUtil.dropTable(DBRoute.of((String)routeStr), tn.getPKTempTable());
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_4", (String)"Delete Pktp Table: {0}", (Object[])new Object[]{tn.getPKTempTable()}));
                sp.store(true);
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_2", (String)"Migration is complete", (Object[])new Object[0]));
                sp.store(true);
                return null;
            });
        }
        catch (Exception e) {
            ShardTaskRepository.get().setNextTaskstatus(taskEntity.getId(), ShardTaskStatusEnum.TERMINATED, ShardTaskStatusEnum.SUSPENDED);
            ShardLogPublish.get().publishOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), "ShardingTerminal Failed", sp.getProgressType());
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private static void deleteWithSetProgress(MainProgress sp, DBRoute route, String movingTable) {
        ActionUtil.dropTable(route, movingTable);
        tm.removeCahce(movingTable);
        sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_1", (String)"Delete Intermediate Table: {0}", (Object[])new Object[]{movingTable}));
        sp.store(true);
    }

    public static void dropArchiveMoveProcessTable(ShardTaskEntity taskEntity) {
        String entityNumber = taskEntity.getEntitynumber();
        IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
        DBRoute route = DBRoute.of((String)rootDT.getDBRouteKey());
        MainProgress sp = MainProgress.of(taskEntity.getId(), entityNumber, taskEntity.getProgresssign());
        try {
            DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)false, () -> {
                String shardTable;
                DBRoute targetRoute;
                tm = XDBConfig.getTableManager();
                sp.setProgressType("MoveIndexTerminal");
                List<ShardProgressEntity> shardProgressEntities = ShardProgressRepository.get().loadProgressList(taskEntity.getId());
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_3", (String)"Deete archive DB route prototype table", (Object[])new Object[0]));
                sp.store(true);
                for (ShardProgressEntity shardProgressEntity : shardProgressEntities) {
                    TableName shardTN;
                    String prototypeTable;
                    targetRoute = DBRoute.of((String)shardProgressEntity.getTargetRoute());
                    if (DB.exitsTable((DBRoute)targetRoute, (String)(prototypeTable = (shardTN = TableName.of((String)(shardTable = shardProgressEntity.getShardTable()))).getPrototypeTable()))) {
                        ActionUtil.dropTable(targetRoute, prototypeTable);
                    }
                    long shardIndex = shardProgressEntity.getShardIndex();
                    if (!DB.exitsTable((DBRoute)targetRoute, (String)shardTN.getPKTable())) continue;
                    String deleteShardingIndexRouteSQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)("delete from " + shardTN.getPKTable() + " where findex = ? ")));
                    DBAnyRWContext ctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();
                    Throwable throwable = null;
                    try {
                        DB.execute((DBRoute)targetRoute, (String)deleteShardingIndexRouteSQL, (Object[])new Object[]{shardIndex});
                        String countSql = "select count(*) from " + shardTN.getPKTable();
                        long count = (Long)DB.query((DBRoute)targetRoute, (String)countSql, null, rs -> {
                            if (rs.next()) {
                                return rs.getLong(1);
                            }
                            return 0L;
                        });
                        if (count != 0L) continue;
                        ActionUtil.dropTable(targetRoute, shardTN.getPKTable());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ctx == null) continue;
                        if (throwable != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ctx.close();
                    }
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_4", (String)"Delete archive DB Shard Table", (Object[])new Object[0]));
                sp.store(true);
                for (ShardProgressEntity shardProgressEntity : shardProgressEntities) {
                    targetRoute = DBRoute.of((String)shardProgressEntity.getTargetRoute());
                    if (!DB.exitsTable((DBRoute)targetRoute, (String)(shardTable = shardProgressEntity.getShardTable()))) continue;
                    ActionUtil.dropTable(targetRoute, shardTable);
                }
                sp.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingTerminateServiceHelper_2", (String)"Migration is complete", (Object[])new Object[0]));
                sp.store(true);
                return null;
            });
        }
        catch (Exception e) {
            ShardTaskRepository.get().setNextTaskstatus(taskEntity.getId(), ShardTaskStatusEnum.TERMINATED, ShardTaskStatusEnum.SUSPENDED);
            ShardLogPublish.get().publishOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), "ShardingTerminal Failed", sp.getProgressType());
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }
}

