/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.progress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDExceptionKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.MainProgress;
import kd.bos.xdb.util.DateUtil;

public class SubProgress
implements IChildProgress,
Serializable {
    private static final long serialVersionUID = 8384640737012615429L;
    private static final Log log = LogFactory.getLog(SubProgress.class);
    private boolean isSplit = false;
    private long taskId;
    private String entitynumber;
    private String movingTable;
    private MainProgress parentSp;
    private boolean originTableCreated = false;
    private int runRound = 0;
    private long tsUsed = 0L;
    private long tsLastFrom = 0L;
    private boolean continueSharding = false;
    private boolean needDel = false;
    private Object toPk = null;
    private long movingShardingIndex = -1L;
    private transient long tsLastStore = 0L;
    private String execSql;
    private Map<String, Object> progressDescMap = new HashMap<String, Object>();

    public static SubProgress of(long taskId, String entitynumber, String s) {
        SubProgress sp;
        if (s == null || s.trim().length() == 0) {
            sp = new SubProgress();
        } else {
            try {
                SubProgress sp2 = SubProgress.unserialize(s);
                sp2.tsLastFrom = System.currentTimeMillis();
                sp2.continueSharding = true;
                sp2.needDel = true;
                sp2.setExecSql(null);
                ++sp2.runRound;
                return sp2;
            }
            catch (Exception e) {
                sp = new SubProgress();
            }
        }
        sp.taskId = taskId;
        sp.entitynumber = entitynumber;
        return sp;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean split) {
        this.isSplit = split;
    }

    public SubProgress() {
        this.tsLastFrom = System.currentTimeMillis();
    }

    @Override
    public Object getToPk() {
        return this.toPk;
    }

    @Override
    public void setToPk(Object toPk) {
        this.toPk = toPk;
    }

    public long getMovingShardingIndex() {
        return this.movingShardingIndex;
    }

    @Override
    public void setMovingShardingIndex(long movingShardingIndex) {
        this.movingShardingIndex = movingShardingIndex;
    }

    @Override
    public void setProgressDesc(String key, Object value) {
        if (value == null) {
            this.progressDescMap.remove(key);
        } else {
            this.progressDescMap.put(key, value);
        }
    }

    @Override
    public void setProgressDesc_1(Object value) {
        this.setProgressDesc("p1", value);
        this.setProgressDesc_2(null);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_2(Object value) {
        this.setProgressDesc("p2", value);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_3(Object value) {
        this.setProgressDesc("p3", value);
    }

    public String getMovingTable() {
        return this.movingTable;
    }

    public void setMovingTable(String movingTable) {
        this.movingTable = movingTable;
    }

    @Override
    public MainProgress getParentSp() {
        return this.parentSp;
    }

    public void setParentSp(MainProgress parentSp) {
        this.parentSp = parentSp;
    }

    @Override
    public void setExecSql(String execSql) {
        this.execSql = execSql;
    }

    String progress() {
        return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_0", (String)"{0}, {1} source tables, executed {2} times, elapsed time {3}, last start time {4}", (Object[])new Object[]{this.getParentSp().recordPercent(), this.getParentSp().getSourceTableCount(), this.runRound, this.formatUsedTS(), DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss").format(new Date(this.tsLastFrom))});
    }

    private String formatUsedTS() {
        long s = this.tsUsed / 1000L;
        if (s < 60L) {
            return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_4", (String)"{0} Seconds", (Object[])new Object[]{s});
        }
        long m = s / 60L;
        if (m < 60L) {
            return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_5", (String)"{0}minutes{1}seconds", (Object[])new Object[]{m, s % 60L});
        }
        long h = m / 60L;
        return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_6", (String)"{0}hours{1}minutes{2}seconds", (Object[])new Object[]{h, m % 60L, s % 60L});
    }

    String progressDesc() {
        return this.progressDescMap.toString();
    }

    String progressSign() {
        return this.serialize();
    }

    public boolean isOriginTableCreated() {
        return this.originTableCreated;
    }

    public void setOriginTableCreated(boolean originTableCreated) {
        this.originTableCreated = originTableCreated;
    }

    private String serialize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(this);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    private static SubProgress unserialize(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return (SubProgress)is.readObject();
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isContinueSharding() {
        return this.continueSharding;
    }

    @Override
    public boolean isNeedDel() {
        return this.needDel;
    }

    @Override
    public void setNeedDel(boolean needDel) {
        this.needDel = needDel;
    }

    @Override
    public void store(boolean isLog) {
        long segUsed = this.tsLastStore == 0L ? System.currentTimeMillis() - this.tsLastFrom : System.currentTimeMillis() - this.tsLastStore;
        this.tsUsed += segUsed;
        this.tsLastStore = System.currentTimeMillis();
        String sql = this.isSplit ? "update t_cbs_shard_splittask set fprogresssign = ? where fid = ? " : "update t_cbs_shard_progress set fprogresssign = ? where fid = ? ";
        Object[] parmas = new Object[]{this.progressSign(), this.taskId};
        sql = ActionUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
        if (isLog) {
            String msg = this.progress() + "\r\n" + this.progressDesc();
            if (!StringUtils.isEmpty((String)this.execSql)) {
                msg = msg + "\r\n" + this.execSql;
            }
            ShardLogPublish.get().publishOperationLog(this.taskId, this.entitynumber, msg, this.getParentSp().getProgressType() + (null != this.movingTable ? "#" + this.movingTable : ""));
        }
    }

    @Override
    public void store() {
        this.store(true);
    }
}

