/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.analysis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.id.ID;
import kd.bos.id.IDRange;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardSplitTaskEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.analysis.entity.SplitInfo;
import kd.bos.xdb.task.service.analysis.work.SplitMoveWork;
import kd.bos.xdb.task.service.analysis.work.SplitMoveWorkRunner;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;
import kd.bos.xdb.taskgroup.runner.AnalysisReaderRunner;
import kd.bos.xdb.util.DateUtil;
import kd.bos.xdb.util.Threads;

public final class ShardingAnalysisService
extends ShardingTaskServiceAbst {
    private ArrayBlockingQueue<ShardSplitTaskEntity> splitTaskQueue = new ArrayBlockingQueue(10000);

    public ShardingAnalysisService(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.SLICEANALYSIS);
    }

    public ArrayBlockingQueue<ShardSplitTaskEntity> getSplitTaskQueue() {
        return this.splitTaskQueue;
    }

    @Override
    public boolean doSharding() throws Exception {
        AbstractShardingStrategy mainShardingStrategy = (AbstractShardingStrategy)this.configuration.getMainShardingConfig().getShardingStrategy();
        mainShardingStrategy.ensureTableInited();
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias().toLowerCase();
        PkTypeEnum pkTypeEnum = XDBManagerUtil.getPkTypeEnum(this.configuration.getEntitynumber());
        Object minPk = this.getMinPk(this.configuration.getRoute(), this.configuration.getMainTable(), pkField);
        Communication analysisCommunication = new Communication();
        if (!this.mainProgress.isCurStepExecuted()) {
            if (minPk != null) {
                if (mainShardingStrategy.isIDSequence() && pkTypeEnum == PkTypeEnum.pk_long) {
                    Object maxPk = this.getMaxPk(this.configuration.getRoute(), this.configuration.getMainTable(), pkField);
                    Date minDate = ID.getCreateTime((long)((Long)minPk));
                    Date maxDate = ID.getCreateTime((long)((Long)maxPk));
                    long dValue = (maxDate.getTime() - minDate.getTime()) / 1000L / 60L / 60L / 24L + 1L;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(minDate);
                    Calendar nexCalendar = Calendar.getInstance();
                    nexCalendar.setTime(minDate);
                    nexCalendar.add(5, 1);
                    SimpleDateFormat simpleDateFormat = DateUtil.getDateFormat((String)"yyyyMMdd");
                    String maxDay = simpleDateFormat.format(maxDate);
                    ArrayList<SplitInfo> splitList = new ArrayList<SplitInfo>(10000);
                    int i = 0;
                    while ((long)i <= dValue) {
                        String day = simpleDateFormat.format(calendar.getTime());
                        if (Integer.parseInt(maxDay) - Integer.parseInt(day) >= 0) {
                            Date curDate = calendar.getTime();
                            IDRange idRange = ID.getIDRangeOfDay((Date)curDate);
                            calendar.add(5, 1);
                            Date nextDate = nexCalendar.getTime();
                            IDRange nextIdRange = ID.getIDRangeOfDay((Date)nextDate);
                            nexCalendar.add(5, 1);
                            SplitInfo splitInfo = new SplitInfo();
                            splitList.add(splitInfo);
                            splitInfo.setRemark(day);
                            splitInfo.setHeadPk(idRange.getMinId());
                            splitInfo.setTailPk(nextIdRange.getMinId());
                            splitInfo.setTotalCount(0L);
                            splitInfo.setNum(i + 1);
                        }
                        ++i;
                    }
                    ShardSplitTaskRepository.get().deleteSplitTask(this.taskEntity.getId());
                    ShardSplitTaskRepository.get().insertSplitTask(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), splitList);
                    this.mainProgress.setCurStepExecuted(true);
                    this.mainProgress.setSourceTableCount(this.configuration.getShardingConfigs().size());
                    this.mainProgress.store(false);
                    List<ShardSplitTaskEntity> splitTaskEntities = ShardSplitTaskRepository.get().loadUnexecutedSplitTaskList(this.taskEntity.getId());
                    this.splitTaskQueue.drainTo(Collections.singleton(splitTaskEntities));
                    analysisCommunication.setState(State.SUCCEEDED);
                } else {
                    AnalysisReaderRunner analysisReaderRunner = new AnalysisReaderRunner(this, this.taskEntity, this.configuration, minPk, this.mainProgress);
                    analysisReaderRunner.setRunnerCommunication(analysisCommunication);
                    analysisReaderRunner.setTaskId(this.taskEntity.getId());
                    Thread analysisThreadReader = new Thread(Threads.wrapRunnable((Runnable)analysisReaderRunner), "XDB-AnalysisReaderRunner-" + this.taskEntity.getEntitynumber());
                    analysisThreadReader.start();
                    if (!analysisThreadReader.isAlive() || analysisCommunication.getState() == State.FAILED) {
                        analysisCommunication.setState(State.FAILED);
                        analysisCommunication.setTimestamp(System.currentTimeMillis());
                    }
                }
            } else {
                analysisCommunication.setState(State.SUCCEEDED);
            }
        } else {
            analysisCommunication.setState(State.SUCCEEDED);
        }
        boolean isPaused = false;
        boolean isException = false;
        String runtimeException = "";
        try (ShardThreadPool threadPool = new ShardThreadPool();){
            List<ShardSplitTaskEntity> splitTaskEntities;
            threadPool.setTable(this.taskEntity.getEntitynumber());
            threadPool.setName("XDB-AnalysisParallelThread-");
            threadPool.start();
            ArrayList futureList = new ArrayList(10000);
            while (!analysisCommunication.isFinished()) {
                ShardSplitTaskEntity splitEntity = this.getSplitTaskQueue().poll();
                if (splitEntity != null) {
                    SubProgress subProgress = SubProgress.of(splitEntity.getId(), this.taskEntity.getEntitynumber(), splitEntity.getProgresssign());
                    subProgress.setParentSp(this.mainProgress);
                    subProgress.setMovingTable(splitEntity.getRemark());
                    subProgress.setSplit(true);
                    Future future = threadPool.submit(Threads.wrapCallable((Callable)new SplitMoveWorkRunner(new SplitMoveWork(splitEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), splitEntity)));
                    futureList.add(future);
                }
                Thread.sleep(2000L);
            }
            if (analysisCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                analysisCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String string = MessageFormat.format("ShardTaskMovingHandler AnalysisWork error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, sw.toString());
                XDBManagerUtil.logError(string, analysisCommunication.getThrowable());
                ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), string, this.getProgressType());
                if (!isException) {
                    runtimeException = sw.toString();
                    isException = true;
                }
            } else if (analysisCommunication.getState() == State.PAUSED) {
                isPaused = true;
            }
            if (!(isException || isPaused || (splitTaskEntities = ShardSplitTaskRepository.get().loadUnexecutedSplitTaskList(this.taskEntity.getId())).isEmpty())) {
                for (ShardSplitTaskEntity splitEntity : splitTaskEntities) {
                    SubProgress subProgress = SubProgress.of(splitEntity.getId(), this.taskEntity.getEntitynumber(), splitEntity.getProgresssign());
                    subProgress.setParentSp(this.mainProgress);
                    subProgress.setMovingTable(splitEntity.getRemark());
                    subProgress.setSplit(true);
                    Future future = threadPool.submit(Threads.wrapCallable((Callable)new SplitMoveWorkRunner(new SplitMoveWork(splitEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), splitEntity)));
                    futureList.add(future);
                }
            }
            for (Future future : futureList) {
                try {
                    if (isException) {
                        future.cancel(true);
                        continue;
                    }
                    if (!isPaused) {
                        isPaused = (Boolean)future.get();
                        continue;
                    }
                    future.get();
                }
                catch (Throwable e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("ShardTaskMovingHandler ShardingAnalysisService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, sw.toString());
                    XDBManagerUtil.logError(error, e);
                    ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                    if (isException) continue;
                    runtimeException = sw.toString();
                    isException = true;
                }
            }
            if (isException) {
                threadPool.shutdown();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(200L);
                }
                throw ExceptionUtil.wrap((String)runtimeException);
            }
        }
        long unclosed = ShardSplitTaskRepository.get().countSplitTaskUnclosed(this.taskEntity.getId());
        if (isPaused) {
            ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
            XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingAnalysisService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
            ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_0", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
            return true;
        }
        if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
            ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
            XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingAnalysisService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
            ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_0", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
            return true;
        }
        if (unclosed > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingAnalysisService_0", (String)"There are outstanding analysis task", (Object[])new Object[0]));
        }
        return false;
    }

    private Object getMinPk(DBRoute route, String table, String pkField) {
        StringBuilder sql = new StringBuilder(128);
        sql.append(" select min(").append(pkField).append(") from ").append(table);
        return DB.query((DBRoute)route, (String)sql.toString(), rs -> {
            if (rs.next()) {
                return rs.getObject(1);
            }
            return null;
        });
    }

    private Object getMaxPk(DBRoute route, String table, String pkField) {
        StringBuilder sql = new StringBuilder(128);
        sql.append(" select max(").append(pkField).append(") from ").append(table);
        return DB.query((DBRoute)route, (String)sql.toString(), rs -> {
            if (rs.next()) {
                return rs.getObject(1);
            }
            return null;
        });
    }
}

