/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.analysis.reader;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardSplitTaskEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class AnalysisReader
implements Reader {
    private Configuration configuration;
    private ShardSplitTaskEntity splitTaskEntity;
    private Object lastPk;
    private PkTypeEnum pkTypeEnum;

    public AnalysisReader(ShardSplitTaskEntity splitTaskEntity, Configuration configuration, Object lastPk) {
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.lastPk = lastPk;
        this.pkTypeEnum = XDBManagerUtil.getPkTypeEnum(configuration.getEntitynumber());
    }

    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias();
        String[] fields = this.configuration.getMainShardingConfig().getShardingFields();
        String mainTable = this.configuration.getMainTable();
        DBRoute route = this.configuration.getRoute();
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE);
            int shardFieldsPkIndex = ActionUtil.findPkindexInShardfields(fields, pkField);
            if (shardFieldsPkIndex == -1) {
                sql.append(" ").append(pkField).append(",");
            }
            sql.append(" ").append(ActionUtil.joinArray(fields, ","));
            sql.append(" from ").append(mainTable);
            StringBuilder condition = new StringBuilder(128);
            if (fromPK != null) {
                condition.append(" ").append(pkField).append(" > ? ");
                paramList.add(fromPK);
            } else if (this.splitTaskEntity.getHeadpk() != null && !this.splitTaskEntity.getHeadpk().isEmpty()) {
                condition.append(" ").append(pkField).append(" >= ? ");
                paramList.add(this.pkTypeEnum == PkTypeEnum.pk_long ? Long.valueOf(Long.parseLong(this.splitTaskEntity.getHeadpk())) : this.splitTaskEntity.getHeadpk());
            }
            if (this.splitTaskEntity.getTailpk() != null && !this.splitTaskEntity.getTailpk().trim().isEmpty()) {
                condition.append(" and ").append(pkField).append(" < ? ");
                paramList.add(this.pkTypeEnum == PkTypeEnum.pk_long ? Long.valueOf(Long.parseLong(this.splitTaskEntity.getTailpk())) : this.splitTaskEntity.getTailpk());
            }
            if (condition.length() > 0) {
                sql.append(" where ").append((CharSequence)condition);
            }
            sql.append(" order by ").append(pkField).append(" asc");
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"AnalysisReader", (DBRoute)route, (String)s, (Object[])paramList.toArray());){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(fields.length);
                    fromPK = pkValue = row.get(shardFieldsPkIndex == -1 ? 0 : shardFieldsPkIndex);
                    rowRecord.setPk(pkValue);
                    for (int i = 0; i < fields.length; ++i) {
                        rowRecord.setColumn(i, row.get(i + (shardFieldsPkIndex == -1 ? 1 : 0)));
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= XDBManagerConstant.PAGE_SIZE);
        return false;
    }
}

