/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.analysis.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardSplitTaskEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.IWork;
import kd.bos.xdb.task.service.analysis.reader.AnalysisReader;
import kd.bos.xdb.task.service.analysis.writer.AnalysisWriter;
import kd.bos.xdb.taskgroup.TaskGroupExecutor;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public class SplitMoveWork
implements IWork {
    protected ShardSplitTaskEntity splitTaskEntity;
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected SubProgress subProgress;

    public SplitMoveWork(ShardSplitTaskEntity splitTaskEntity, ShardTaskEntity taskEntity, Configuration configuration, SubProgress subProgress) {
        this.splitTaskEntity = splitTaskEntity;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.subProgress = subProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork begin,entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork interrupted,entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
            return false;
        }
        try (TXHandle tx = TX.notSupported((String)"SplitMoveWork.doWork");
             DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            int c = ShardSplitTaskRepository.get().updateSplitTaskExecuting(this.splitTaskEntity.getId());
            if (c <= 0) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork updateSplitTaskExecuting error,entitynumber:{0}, remark:{1},taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
                boolean bl = false;
                return bl;
            }
            boolean isContinue = false;
            Object prePk = null;
            long lastIndex = -1L;
            if (this.subProgress.getToPk() != null) {
                prePk = this.subProgress.getToPk();
                lastIndex = this.subProgress.getMovingShardingIndex();
                isContinue = true;
            }
            if (isContinue) {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"SplitMoveWork_0", (String)"Continue sharding analysis, remark: {0}, interrupt position pk: {1}, index: {2}", (Object[])new Object[]{this.splitTaskEntity.getRemark(), prePk, lastIndex}));
            } else {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"SplitMoveWork_1", (String)"Start shard analysis, remark: {0}, first execution...", (Object[])new Object[]{this.splitTaskEntity.getRemark()}));
            }
            this.subProgress.store();
            AnalysisReader pkReader = new AnalysisReader(this.splitTaskEntity, this.configuration, prePk);
            AnalysisWriter pkWriter = new AnalysisWriter(this.splitTaskEntity, this.configuration, this.subProgress, lastIndex);
            pkWriter.setBufferSize(XDBManagerConstant.PAGE_SIZE);
            Communication runnerCommunication = new Communication();
            TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "SPLIT#" + this.splitTaskEntity.getRemark());
            pkGroupExecutor.doStart();
            if (runnerCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ShardTaskMovingHandler SplitMoveWork stateReturnFailed,entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId(), sw.toString());
                XDBManagerUtil.logError(error, runnerCommunication.getThrowable());
                ShardLogPublish.get().publishOperationLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "SPLIT#" + this.splitTaskEntity.getRemark());
                throw ExceptionUtil.asRuntimeException((String)sw.toString(), (Throwable)runnerCommunication.getThrowable());
            }
            if (runnerCommunication.getState() == State.PAUSED) {
                ShardSplitTaskRepository.get().setSplitTaskSuspended(this.splitTaskEntity.getId());
                ShardLogPublish.get().publishOperationLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"SplitMoveWork_2", (String)"task paused, remark: {0}", (Object[])new Object[]{this.splitTaskEntity.getRemark()}), "SPLIT#" + this.splitTaskEntity.getRemark());
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork paused,entitynumber:{0}, remark:{1}, taskId:{1}, splitTaskId:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
                boolean bl = true;
                return bl;
            }
            if (Thread.currentThread().isInterrupted()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork interrupted,entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
                boolean bl = false;
                return bl;
            }
            this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"SplitMoveWork_3", (String)"Shard analysis completed, remark: {0}", (Object[])new Object[]{this.splitTaskEntity.getRemark()}));
            this.subProgress.setExecSql(null);
            this.subProgress.store();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            XDBManagerUtil.logError(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork error, entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId(), runtimeException), e);
            ShardSplitTaskRepository.get().setNextSplitTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.EXECUTING, ShardTaskStatusEnum.FAILED);
            throw ExceptionUtil.asRuntimeException((String)runtimeException, (Throwable)e);
        }
        ShardSplitTaskRepository.get().updateSplitTaskSuccess(this.splitTaskEntity.getId());
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler SplitMoveWork end,entitynumber:{0}, remark:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.splitTaskEntity.getRemark(), this.taskEntity.getId(), this.splitTaskEntity.getId()));
        return false;
    }
}

