/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.archivemove;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardArchiEntity;
import kd.bos.xdb.entity.ShardArchiKanbanEntity;
import kd.bos.xdb.entity.ShardArchiRouteEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardArchiKanbanRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.service.calc.CountShardingTableCall;
import kd.bos.xdb.service.calc.CountTableCall;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.archivemove.work.ArchiveMoveWork;
import kd.bos.xdb.task.service.archivemove.work.ArchiveMoveWorkRunner;
import kd.bos.xdb.util.Threads;

public class ShardingArchiveMoveSrvice
extends ShardingTaskServiceAbst {
    public ShardingArchiveMoveSrvice(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.ARCHIVEMOVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doSharding() throws Exception {
        String entityNumber;
        boolean isPaused;
        TableManager tm;
        block50: {
            Object threadPool;
            block52: {
                Object runtimeException;
                List<ShardProgressEntity> shardProgressEntities;
                Serializable totalCount;
                block51: {
                    tm = XDBConfig.getTableManager();
                    this.mainProgress.setTerminable(true);
                    this.mainProgress.store(false);
                    if (this.mainProgress.isCurStepExecuted()) {
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_3", (String)"Continue sharding archive data migration", (Object[])new Object[0]));
                        this.mainProgress.setTotalRecord(this.taskEntity.getTotalRecord());
                        this.mainProgress.setMovedRecord(this.taskEntity.getMovingRecord());
                        this.mainProgress.store(true);
                    } else {
                        Iterator iterator;
                        List<ShardArchiRouteEntity> shardArchiRouteEntities = this.configuration.getShardArchiRouteEntities();
                        Map archiRouteMap = shardArchiRouteEntities.stream().collect(Collectors.toMap(ShardArchiRouteEntity::getIndex, Function.identity()));
                        if (shardArchiRouteEntities.isEmpty()) {
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_0", (String)"No changes in sharding table routing", (Object[])new Object[0]));
                            this.mainProgress.store(true);
                            return false;
                        }
                        Set targetRouteSet = shardArchiRouteEntities.stream().map(ShardArchiRouteEntity::getTargetRoute).collect(Collectors.toSet());
                        for (String targetRoute : targetRouteSet) {
                            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                                ShardingConfig sc = this.configuration.getShardingConfigs().get(seq);
                                String string = TableName.of((String)sc.getTable()).getPrototypeTable();
                                if (DB.exitsTableForManager((DBRoute)DBRoute.of((String)targetRoute), (String)string)) continue;
                                tm.createCrossTable(ExtContext.get().getDBRoute(), string, targetRoute, string);
                                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_1", (String)"Create prototype table {1} in target database {0}", (Object[])new Object[]{targetRoute, string}));
                                this.mainProgress.store(true);
                            }
                            String pkTable = TableName.of((String)this.configuration.getMainTable()).getPKTable();
                            if (DB.exitsTableForManager((DBRoute)DBRoute.of((String)targetRoute), (String)pkTable)) continue;
                            tm.createPKTable(targetRoute, pkTable, XDBManagerUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()), this.configuration.getMainShardingConfig().getOptions().getDataRowsRange(), this.configuration.getMainShardingConfig().getOptions().getIndexDefines());
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_9", (String)"Create fast index table {1} in target database {0}", (Object[])new Object[]{targetRoute, pkTable}));
                            this.mainProgress.store(true);
                        }
                        totalCount = new AtomicLong(0L);
                        ArrayList results = new ArrayList(shardArchiRouteEntities.size());
                        int sourceTableCount = 0;
                        int seq = 0;
                        while (true) {
                            Iterator<ShardArchiRouteEntity> iterator2;
                            String string;
                            if (seq < this.configuration.getShardingConfigs().size()) {
                                ShardingConfig shardingConfig = this.configuration.getShardingConfigs().get(seq);
                                string = TableName.of((String)shardingConfig.getTable()).getOriginalName();
                                sourceTableCount += shardArchiRouteEntities.size();
                                iterator2 = shardArchiRouteEntities.iterator();
                            } else {
                                ArrayList countTableCalls = new ArrayList(results.size());
                                for (Future future : results) {
                                    countTableCalls.add(future.get());
                                }
                                iterator = countTableCalls.iterator();
                                break;
                            }
                            while (iterator2.hasNext()) {
                                String shardTable;
                                ShardArchiRouteEntity archiRouteEntity = iterator2.next();
                                DBRoute route = DBRoute.of((String)archiRouteEntity.getOriginalRoute());
                                if (DB.exitsTableForManager((DBRoute)route, (String)(shardTable = TableName.of((String)string).getShardingTable(archiRouteEntity.getIndex())))) {
                                    results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(route, shardTable, string))));
                                    continue;
                                }
                                String error = MessageFormat.format("ShardTaskMovingHandler TaskContainer original table not exits, taskId:{0}, entitynumber:{1}, originalRoute:{2}, shardTable:{3}", this.taskEntity.getId(), this.taskEntity.getEntitynumber(), route.getRouteKey(), shardTable);
                                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "TABLENOTEXITS");
                            }
                            ++seq;
                        }
                        while (iterator.hasNext()) {
                            CountTableCall countTableCall = (CountTableCall)iterator.next();
                            String shardTable = countTableCall.getShardTable();
                            TableName tableName = TableName.of((String)shardTable);
                            long count = countTableCall.getCount();
                            ((AtomicLong)totalCount).addAndGet(count);
                            long shardingIndex = tableName.isPrototypeTable() ? -1L : tableName.getShardingIndex();
                            ShardArchiRouteEntity routeEntity = (ShardArchiRouteEntity)archiRouteMap.get(shardingIndex);
                            ProgressUtil.insertProgressTable(this.taskEntity, shardTable, shardingIndex, count, routeEntity.getOriginalRoute(), routeEntity.getTargetRoute());
                        }
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_2", (String)"Start sharding archive data migration, first execution...", (Object[])new Object[0]));
                        this.mainProgress.setMovedRecord(0L);
                        this.mainProgress.setSourceTableCount(sourceTableCount);
                        this.mainProgress.setCurStepExecuted(true);
                        ProgressUtil.storeTotalRecord(this.taskEntity, ((AtomicLong)totalCount).get(), this.mainProgress);
                    }
                    shardProgressEntities = ShardProgressRepository.get().loadUnexecutedProgressList(this.taskEntity.getId(), null);
                    isPaused = false;
                    if (!shardProgressEntities.isEmpty()) break block51;
                    if (ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId()) > 0L) {
                        throw ExceptionUtil.wrap((String)BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_4", (String)"There are unfinished parallel sharding archive migration tasks", (Object[])new Object[0]));
                    }
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler archiveMove doArchiveMoving end,entitynumber:{0}, taskId:{1}, progressCount:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), shardProgressEntities.size()));
                    break block50;
                }
                if (ShardTaskConfig.isEnableMovingParallel()) {
                    threadPool = new ShardThreadPool();
                    totalCount = null;
                    try {
                        ((ShardThreadPool)threadPool).setTable(this.taskEntity.getEntitynumber());
                        ((ShardThreadPool)threadPool).setName("XDB-ArchiveMoveParallelThread-");
                        ((ShardThreadPool)threadPool).start();
                        ArrayList futureList = new ArrayList(shardProgressEntities.size());
                        for (ShardProgressEntity progressEntity : shardProgressEntities) {
                            SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                            subProgress.setParentSp(this.mainProgress);
                            subProgress.setMovingTable(progressEntity.getShardTable());
                            Future future = ((ShardThreadPool)threadPool).submit(Threads.wrapCallable((Callable)new ArchiveMoveWorkRunner(new ArchiveMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), progressEntity)));
                            futureList.add(future);
                        }
                        boolean isException = false;
                        runtimeException = "";
                        for (Future future : futureList) {
                            try {
                                if (isException) {
                                    future.cancel(true);
                                    continue;
                                }
                                if (!isPaused) {
                                    isPaused = (Boolean)future.get();
                                    continue;
                                }
                                future.get();
                            }
                            catch (Throwable e) {
                                Iterator<ShardArchiRouteEntity> sw = new StringWriter();
                                e.printStackTrace(new PrintWriter((Writer)((Object)sw)));
                                String error = MessageFormat.format("ShardTaskMovingHandler ShardingArchiveMoveService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, ((StringWriter)((Object)sw)).toString());
                                XDBManagerUtil.logError(error, e);
                                ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                                if (isException) continue;
                                runtimeException = ((StringWriter)((Object)sw)).toString();
                                isException = true;
                            }
                        }
                        if (isException) {
                            ((ShardThreadPool)threadPool).shutdown();
                        }
                        break block50;
                    }
                    catch (Throwable futureList) {
                        totalCount = futureList;
                        throw futureList;
                    }
                    finally {
                        if (threadPool != null) {
                            if (totalCount != null) {
                                try {
                                    ((ShardThreadPool)threadPool).close();
                                }
                                catch (Throwable futureList) {
                                    ((Throwable)totalCount).addSuppressed(futureList);
                                }
                            } else {
                                ((ShardThreadPool)threadPool).close();
                            }
                        }
                    }
                }
                threadPool = shardProgressEntities.iterator();
                break block52;
                while (true) {
                    if (((ShardThreadPool)threadPool).isTerminated()) {
                        throw ExceptionUtil.wrap((String)runtimeException);
                    }
                    Thread.sleep(200L);
                }
            }
            while (threadPool.hasNext()) {
                ShardProgressEntity progressEntity = (ShardProgressEntity)threadPool.next();
                if (this.shardTaskRuntime.isTaskPaused(this.configuration.getMainTable())) {
                    isPaused = true;
                    break;
                }
                SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                subProgress.setParentSp(this.mainProgress);
                subProgress.setMovingTable(progressEntity.getShardTable());
                ArchiveMoveWork archiveMoveWork = new ArchiveMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress);
                isPaused = archiveMoveWork.doWork();
                if (isPaused) break;
                this.mainProgress.setExecSql(null);
                this.mainProgress.store(false);
            }
        }
        long unclosed = ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId());
        if (isPaused) {
            if (unclosed != 0L) {
                ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
                XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingArchiveMoveService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_5", (String)"Task paused", (Object[])new Object[0]), this.getProgressType());
                return true;
            }
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        } else if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        }
        if (unclosed > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_6", (String)"There are unfinished parallel migration tasks", (Object[])new Object[0]));
        }
        this.mainProgress.setTerminable(false);
        this.mainProgress.store(false);
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_7", (String)"Delete sharding table in original database", (Object[])new Object[0]));
        this.mainProgress.store(true);
        List<ShardProgressEntity> entityList = ShardProgressRepository.get().loadProgressList(this.taskEntity.getId());
        int from = (int)this.mainProgress.getMovingShardingIndex() + 1;
        for (ShardProgressEntity shardProgressEntity : entityList) {
            if (shardProgressEntity.getId() <= (long)from) continue;
            String string = shardProgressEntity.getShardTable();
            ActionUtil.dropTable(DBRoute.of((String)shardProgressEntity.getOriginalRoute()), string);
            this.mainProgress.setMovingShardingIndex(shardProgressEntity.getId());
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_8", (String)"Delete", (Object[])new Object[0]) + string);
            this.mainProgress.store(true);
        }
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_10", (String)"Delete data in original database pk index table", (Object[])new Object[0]));
        this.mainProgress.store(true);
        TableName mainTN = TableName.of((String)this.configuration.getMainTable());
        if (!tm.existTable(mainTN.getRTTable())) {
            tm.createRTTable(mainTN.getRTTable());
        }
        for (ShardProgressEntity shardProgressEntity : entityList) {
            this.deleteShardingIndexRoute(shardProgressEntity.getShardIndex());
            this.insertShardingIndexRoute(shardProgressEntity.getShardIndex(), shardProgressEntity.getTargetRoute());
        }
        List<ShardArchiRouteEntity> list = this.configuration.getShardArchiRouteEntities();
        Set set = list.stream().map(ShardArchiRouteEntity::getOriginalRoute).collect(Collectors.toSet());
        HashSet<String> hasDropPk = new HashSet<String>(1);
        for (String originalRoute : set) {
            if (originalRoute.equalsIgnoreCase(this.configuration.getRoute().getRouteKey()) || this.countShardingIndexRoute(originalRoute) != 0L) continue;
            if (DB.exitsTableForManager((DBRoute)DBRoute.of((String)originalRoute), (String)mainTN.getPKTable())) {
                ActionUtil.dropTable(DBRoute.of((String)originalRoute), mainTN.getPKTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_12", (String)"Delete sharding database pk table, sharding route:", (Object[])new Object[]{originalRoute}));
                this.mainProgress.store(true);
            }
            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                ShardingConfig sc = this.configuration.getShardingConfigs().get(seq);
                String prototypeTable = TableName.of((String)sc.getTable()).getPrototypeTable();
                if (!DB.exitsTable((DBRoute)DBRoute.of((String)originalRoute), (String)prototypeTable)) continue;
                ActionUtil.dropTable(DBRoute.of((String)originalRoute), prototypeTable);
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_13", (String)"Delete sharding database prototype table, sharding route ", (Object[])new Object[]{originalRoute}));
                this.mainProgress.store(true);
            }
            hasDropPk.add(originalRoute);
        }
        for (ShardArchiRouteEntity archiRouteEntity : list) {
            if (hasDropPk.contains(archiRouteEntity.getOriginalRoute())) continue;
            this.deletePkData(archiRouteEntity);
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingArchiveMoveSrvice_11", (String)"Delete data in original database pk table, sharding findex:", (Object[])new Object[0]) + archiRouteEntity.getIndex());
            this.mainProgress.store(true);
        }
        Configuration configuration = new Configuration(this.taskEntity);
        ShardArchiKanbanRepository kanbanRepository = ShardArchiKanbanRepository.get();
        ShardArchiKanbanEntity kanbanEntity = kanbanRepository.loadShardArchiKanban(entityNumber = this.taskEntity.getEntitynumber());
        if (kanbanEntity == null) {
            ShardArchiEntity archiEntity = configuration.getArchiEntity();
            kanbanRepository.insertShardArchiKanban(entityNumber, archiEntity.getConfigId(), archiEntity.getId());
            kanbanEntity = kanbanRepository.loadShardArchiKanban(entityNumber);
        }
        kanbanRepository.updateDate(kanbanEntity.getId());
        return false;
    }

    private void deleteShardingIndexRoute(long shardingIndex) {
        String deleteShardingIndexRouteSQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)("delete from " + TableName.of((String)this.configuration.getMainTable()).getRTTable() + " where findex = ? ")));
        DB.execute((DBRoute)this.configuration.getRoute(), (String)deleteShardingIndexRouteSQL, (Object[])new Object[]{shardingIndex});
    }

    private void insertShardingIndexRoute(long shardingIndex, String route) {
        String insertShardingIndexRouteSQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)("insert into " + TableName.of((String)this.configuration.getMainTable()).getRTTable() + "(findex,froute) values (?,?)")));
        DB.execute((DBRoute)this.configuration.getRoute(), (String)insertShardingIndexRouteSQL, (Object[])new Object[]{shardingIndex, route});
    }

    private long countShardingIndexRoute(String route) {
        String countShardingIndexRouteSQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)("select count(1) from " + TableName.of((String)this.configuration.getMainTable()).getRTTable() + " where froute = ? ")));
        return (Long)DB.query((DBRoute)this.configuration.getRoute(), (String)countShardingIndexRouteSQL, (Object[])new Object[]{route}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private void deletePkData(ShardArchiRouteEntity archiRouteEntity) {
        String deletePkDataSQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)("delete from " + TableName.of((String)this.configuration.getMainTable()).getPKTable() + " where findex = ? ")));
        DB.execute((DBRoute)DBRoute.of((String)archiRouteEntity.getOriginalRoute()), (String)deletePkDataSQL, (Object[])new Object[]{archiRouteEntity.getIndex()});
    }
}

