/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.archivemove.reader;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.service.archivemove.work.ArchiveSqlInfo;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class ArchiveMoveReader
implements Reader {
    private Configuration configuration;
    private ShardProgressEntity progressEntity;
    private String pkField;
    private ArchiveSqlInfo archiveSqlInfo;
    private int columnLength;
    private Object lastPk;

    public ArchiveMoveReader(ShardProgressEntity progressEntity, Configuration configuration, String pkField, ArchiveSqlInfo archiveSqlInfo, Object lastPk) {
        this.progressEntity = progressEntity;
        this.configuration = configuration;
        this.pkField = pkField;
        this.archiveSqlInfo = archiveSqlInfo;
        String[] fields = this.archiveSqlInfo.getSelectColumn().split(",");
        this.columnLength = fields.length;
        this.lastPk = lastPk;
    }

    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(XDBManagerConstant.CROSS_PAGE_SIZE).append(" ").append(this.archiveSqlInfo.getSelectColumn());
            sql.append(" from ").append(this.archiveSqlInfo.getFromTable());
            Object[] params = null;
            if (fromPK != null) {
                params = new Object[]{fromPK};
                sql.append(" where A.").append(this.pkField).append(" > ?");
            }
            sql.append(" order by A.").append(this.pkField).append(" asc ");
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"ArchiveMoveReader", (DBRoute)DBRoute.of((String)this.progressEntity.getOriginalRoute()), (String)s, (Object[])params);){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(this.columnLength);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    rowRecord.setColumn(0, pkValue);
                    for (int i = 1; i < this.columnLength; ++i) {
                        rowRecord.setColumn(i, row.get(i));
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= XDBManagerConstant.CROSS_PAGE_SIZE);
        return false;
    }
}

