/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.archivemove.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.IWork;
import kd.bos.xdb.task.service.archivemove.reader.ArchiveMoveReader;
import kd.bos.xdb.task.service.archivemove.work.ArchiveSqlInfo;
import kd.bos.xdb.task.service.archivemove.writer.ArchiveMoveWriter;
import kd.bos.xdb.taskgroup.TaskGroupExecutor;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public class ArchiveMoveWork
implements IWork {
    protected ShardProgressEntity progressEntity;
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected SubProgress subProgress;
    protected Object prePk = null;

    public ArchiveMoveWork(ShardProgressEntity progressEntity, ShardTaskEntity taskEntity, Configuration configuration, SubProgress subProgress) {
        this.progressEntity = progressEntity;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.subProgress = subProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        block60: {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork begin,entitynumber:{0}, shardTable:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
            if (Thread.currentThread().isInterrupted()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork interrupted,entitynumber:{0}, shardTable:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                return false;
            }
            try (TXHandle tx = TX.notSupported((String)"ArchiveMoveWork.doWork");
                 DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
                ArchiveSqlInfo archiveSqlInfo;
                String pkField;
                block64: {
                    HashMap<String, Integer> indexMap;
                    HashMap<String, Character> joinTableAliasMap;
                    StringBuilder columnStr;
                    block62: {
                        int n;
                        IndexDefine[] indexDefineArray;
                        int indexApend;
                        HashMap<String, Integer> columnMap;
                        String mainTable;
                        IndexDefine[] defs;
                        int len;
                        block63: {
                            block61: {
                                int c = ShardProgressRepository.get().updateExecuting(this.progressEntity.getId());
                                if (c <= 0) {
                                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork updateExecuting error,entitynumber:{0}, shardTable:{1},taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                                    boolean bl = false;
                                    return bl;
                                }
                                boolean isContinue = false;
                                if (this.subProgress.getToPk() != null) {
                                    this.prePk = this.subProgress.getToPk();
                                    isContinue = true;
                                }
                                if (isContinue) {
                                    this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWork_0", (String)"Continue sharding archive migration, index: {0}, table heads pks: {1}, lastPk: {2}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.progressEntity.getShardTotalRecord(), this.prePk}));
                                } else {
                                    this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWork_1", (String)"Start sharding archive migration, index: {0}, table heads pks: {1}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.progressEntity.getShardTotalRecord()}));
                                }
                                this.subProgress.store();
                                TableManager tm = XDBConfig.getTableManager();
                                String originalName = TableName.of((String)this.progressEntity.getShardTable()).getOriginalName();
                                tm.createShardingTable(this.progressEntity.getTargetRoute(), originalName, this.progressEntity.getShardIndex());
                                ShardingConfig shardingConfig = null;
                                for (ShardingConfig sc : this.configuration.getShardingConfigs()) {
                                    if (!TableName.of((String)sc.getTable()).getOriginalName().equals(originalName)) continue;
                                    shardingConfig = sc;
                                    break;
                                }
                                if (shardingConfig == null) break block60;
                                pkField = ShardConfigEntity.isTcTableShardingDBConfig(shardingConfig) ? "FID" : (ShardConfigEntity.isWbTableShardingDBConfig(shardingConfig) ? "FEntryId" : (ShardConfigEntity.isLangTableShardingDBConfig(shardingConfig) ? "fpkid" : (ShardConfigEntity.isPrivacyTableShardingDBConfig(shardingConfig) ? "fpkid" : ORM.create().getDataEntityType(shardingConfig.getName()).getPrimaryKey().getAlias())));
                                String columnFields = this.getColumns(pkField);
                                String[] columnList = columnFields.split(",");
                                len = columnList.length;
                                columnStr = new StringBuilder();
                                for (int i = 0; i < len; ++i) {
                                    String columnName = columnList[i];
                                    columnStr.append("A.").append(columnName);
                                    if (i == len - 1) continue;
                                    columnStr.append(',');
                                }
                                archiveSqlInfo = new ArchiveSqlInfo(columnFields);
                                if (shardingConfig != this.configuration.getMainShardingConfig()) break block61;
                                defs = this.configuration.getMainShardingConfig().getOptions().getIndexDefines();
                                joinTableAliasMap = new HashMap<String, Character>();
                                mainTable = this.configuration.getMainShardingConfig().getTable();
                                columnMap = new HashMap<String, Integer>();
                                indexMap = new HashMap<String, Integer>();
                                for (int i = 0; i < len; ++i) {
                                    columnMap.put(columnList[i].toLowerCase(), i);
                                }
                                if (defs == null || defs.length <= 0) break block62;
                                indexApend = 0;
                                indexDefineArray = defs;
                                n = indexDefineArray.length;
                                break block63;
                            }
                            archiveSqlInfo.setSelectColumn(columnStr.toString());
                            archiveSqlInfo.setFromTable(this.progressEntity.getShardTable() + " A");
                            break block64;
                        }
                        for (int i = 0; i < n; ++i) {
                            IndexDefine def = indexDefineArray[i];
                            String belongTable = def.getTable();
                            String column = def.getField().toLowerCase();
                            if (belongTable.equalsIgnoreCase(mainTable)) {
                                indexMap.put(column, (Integer)columnMap.get(column));
                                continue;
                            }
                            Character alias = (Character)joinTableAliasMap.get(belongTable);
                            if (alias == null) {
                                alias = Character.valueOf((char)(66 + joinTableAliasMap.size()));
                                joinTableAliasMap.put(belongTable, alias);
                            }
                            indexMap.put(column, len + indexApend);
                            ++indexApend;
                        }
                        for (IndexDefine def : defs) {
                            if (joinTableAliasMap.get(def.getTable()) == null) continue;
                            columnStr.append(',').append(joinTableAliasMap.get(def.getTable())).append('.').append(def.getField());
                        }
                    }
                    long shardingIndex = TableName.of((String)this.progressEntity.getShardTable()).getShardingIndex();
                    StringBuilder fromStr = new StringBuilder();
                    fromStr.append(this.progressEntity.getShardTable()).append(" A");
                    for (Map.Entry join : joinTableAliasMap.entrySet()) {
                        fromStr.append(" left join ").append(TableName.of((String)((String)join.getKey())).getShardingTable(shardingIndex)).append(' ').append(join.getValue()).append(" on A.").append(pkField).append(" = ").append(join.getValue()).append('.').append(pkField);
                    }
                    archiveSqlInfo.setSelectColumn(columnStr.toString());
                    archiveSqlInfo.setFromTable(fromStr.toString());
                    archiveSqlInfo.setIndexMap(indexMap);
                }
                ArchiveMoveReader pkReader = new ArchiveMoveReader(this.progressEntity, this.configuration, pkField, archiveSqlInfo, this.prePk);
                ArchiveMoveWriter pkWriter = new ArchiveMoveWriter(this.progressEntity, this.configuration, pkField, archiveSqlInfo, this.subProgress);
                pkWriter.setBufferSize(XDBManagerConstant.CROSS_INSERT_PAGE_SIZE);
                Communication runnerCommunication = new Communication();
                TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "MOVE#" + this.progressEntity.getShardTable(), true);
                pkGroupExecutor.doStart();
                if (runnerCommunication.getState() == State.FAILED) {
                    StringWriter sw = new StringWriter();
                    runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork stateReturnFailed,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), sw.toString());
                    XDBManagerUtil.logError(error, runnerCommunication.getThrowable());
                    ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), error, "MOVE#" + this.progressEntity.getShardTable());
                    throw ExceptionUtil.asRuntimeException((String)sw.toString(), (Throwable)runnerCommunication.getThrowable());
                }
                if (runnerCommunication.getState() == State.PAUSED) {
                    ShardProgressRepository.get().setProgressSuspended(this.progressEntity.getId());
                    ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWork_3", (String)"Task paused, shardTable: {0}", (Object[])new Object[]{this.progressEntity.getShardTable()}), "MOVE#" + this.progressEntity.getShardTable());
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork paused,entitynumber:{0}, shardTable:{1}, taskId:{1}, splitTaskId:{2}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                    boolean bl = true;
                    return bl;
                }
                if (Thread.currentThread().isInterrupted()) {
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork interrupted,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                    boolean bl = false;
                    return bl;
                }
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWork_4", (String)"Data migration completed for sharding archive, targetRoute: {0}, shardingTable: {1}", (Object[])new Object[]{this.progressEntity.getTargetRoute(), this.progressEntity.getShardTable()}));
                this.subProgress.setExecSql(null);
                this.subProgress.store();
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String runtimeException = sw.toString();
                XDBManagerUtil.logError(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork error, entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), runtimeException), e);
                ShardProgressRepository.get().setProgressFailedByTaskId(this.progressEntity.getId());
                throw ExceptionUtil.asRuntimeException((String)runtimeException, (Throwable)e);
            }
        }
        ShardProgressRepository.get().updateProgressSuccess(this.progressEntity.getId());
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ArchiveMoveWork end,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        return false;
    }

    private String getColumns(String pkField) throws SQLException {
        List columnList = MetaFactory.getMeta().queryColumns(this.progressEntity.getOriginalRoute(), this.progressEntity.getShardTable());
        if (columnList.size() == 1 && pkField.equalsIgnoreCase(((Column)columnList.get(0)).getColumnName())) {
            return pkField;
        }
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = ((Column)columnList.get(i)).getColumnName();
            if (columnName.equalsIgnoreCase(pkField)) {
                if (i != n - 1) continue;
                columnStr.delete(columnStr.length() - 1, columnStr.length());
                continue;
            }
            columnStr.append(((Column)columnList.get(i)).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, pkField + ',');
        return columnStr.toString();
    }
}

