/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.archivemove.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.service.archivemove.work.ArchiveSqlInfo;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class ArchiveMoveWriter
extends WriterAbst {
    private ShardProgressEntity progressEntity;
    private DBRoute targetRoute;
    private boolean isReplace;
    private String pkField;
    private ArchiveSqlInfo archiveSqlInfo;
    private String columnFields;
    private int columnLength;
    private String crossInsetSql;
    private Object fromPK;
    private Object toPK;
    private int bufferSize;
    private boolean isMain;
    private long shardIndex;
    private String crossInsetPkSql;
    private int loop = 0;

    public ArchiveMoveWriter(ShardProgressEntity progressEntity, Configuration configuration, String pkField, ArchiveSqlInfo archiveSqlInfo, IChildProgress progress) {
        super(configuration, progress);
        this.progressEntity = progressEntity;
        this.targetRoute = DBRoute.of((String)progressEntity.getTargetRoute());
        this.isReplace = DBType.mysql == this.dbType;
        this.pkField = pkField;
        this.archiveSqlInfo = archiveSqlInfo;
        this.columnFields = this.archiveSqlInfo.getColumnFields();
        String[] fields = this.columnFields.split(",");
        this.columnLength = fields.length;
        this.crossInsetSql = ActionUtil.wrapSQL(this.getCrossInsetSql(this.columnFields), true, true);
        this.isMain = TableName.of((String)progressEntity.getShardTable()).getOriginalName().equalsIgnoreCase(configuration.getMainTable());
        this.crossInsetPkSql = this.isMain ? ActionUtil.wrapSQL(this.getCrossInsetPkSql(), true, true) : null;
        this.shardIndex = TableName.of((String)progressEntity.getShardTable()).getShardingIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws Exception {
        this.fromPK = writerBuffer.get(0).getPk();
        this.toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        this.bufferSize = writerBuffer.size();
        String pkTable = TableName.of((String)this.configuration.getMainTable()).getPKTable();
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (!this.isReplace && this.progress.isNeedDel()) {
            sql.setLength(0);
            sql.append("select ").append(this.pkField).append(" from ").append(this.progressEntity.getShardTable()).append(" where ").append(this.pkField).append(" >=? and ").append(this.pkField).append(" <=?");
            List existsList = (List)DB.query((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK}, rs -> {
                ArrayList<Object> dataList = new ArrayList<Object>(10);
                while (rs.next()) {
                    dataList.add(rs.getObject(1));
                }
                return dataList;
            });
            if (existsList.size() > 0) {
                if (this.isMain) {
                    sql.setLength(0);
                    sql.append("delete from ").append(pkTable).append(" where findex=? and fpk>=? and fpk<=?");
                    Semaphore sp = this.progress.getParentSp().getDeletePKSemaphore();
                    sp.acquire();
                    try {
                        DB.execute((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.progressEntity.getShardIndex(), this.fromPK, this.toPK});
                    }
                    finally {
                        sp.release();
                    }
                }
                sql.setLength(0);
                sql.append("delete from ").append(this.progressEntity.getShardTable()).append(" where ").append(this.pkField).append(" >= ? and ").append(this.pkField).append("<=?");
                DB.execute((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
                this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWriter_1", (String)"Sharding archive migration exception recovery and clearing of exception data, targetRoute: {0}, shardingTable: {1}, fromPK={2}, toPK={3}, size={4}", (Object[])new Object[]{this.progressEntity.getTargetRoute(), this.progressEntity.getShardTable(), this.fromPK, this.toPK, this.bufferSize}));
                this.progress.setExecSql(sql.toString());
                this.progress.store();
            }
        }
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWriter_2", (String)"Sharding archive migration,targetRoute:{0},shardingTable:{1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.progressEntity.getTargetRoute(), this.progressEntity.getShardTable(), this.fromPK, this.toPK, this.bufferSize}));
        this.progress.store();
        if (this.isMain) {
            ArrayList<Object[]> pkValuesList = new ArrayList<Object[]>(writerBuffer.size());
            IndexDefine[] defs = this.configuration.getMainShardingConfig().getOptions().getIndexDefines();
            Map<String, Integer> indexMap = this.archiveSqlInfo.getIndexMap();
            ArrayList<Object[]> fieldValuesList = new ArrayList<Object[]>(writerBuffer.size());
            for (RowRecord rowRecord : writerBuffer) {
                Object[] columns = rowRecord.getColumns();
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(columns[0]);
                if (defs != null && defs.length > 0) {
                    for (IndexDefine def : defs) {
                        row.add(columns[indexMap.get(def.getField())]);
                    }
                }
                row.add(this.shardIndex);
                pkValuesList.add(row.toArray(new Object[row.size()]));
                Object[] fieldValues = new Object[this.columnLength];
                System.arraycopy(columns, 0, fieldValues, 0, this.columnLength);
                fieldValuesList.add(fieldValues);
            }
            DB.executeBatch((DBRoute)this.targetRoute, (String)this.crossInsetPkSql, pkValuesList);
            DB.executeBatch((DBRoute)this.targetRoute, (String)this.crossInsetSql, fieldValuesList);
        } else {
            List fieldValuesList = writerBuffer.stream().map(RowRecord::getColumns).collect(Collectors.toList());
            DB.executeBatch((DBRoute)this.targetRoute, (String)this.crossInsetSql, fieldValuesList);
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(this.toPK);
        ProgressUtil.incrMoveRecordAndStore((ITaskEntity)this.progressEntity, this.progressEntity.getShardTable(), (long)this.bufferSize, this.progress);
    }

    private String getCrossInsetSql(String fieldsString) {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (this.isReplace) {
            sql.append("replace into ").append(this.progressEntity.getShardTable());
        } else {
            sql.append("insert into ").append(this.progressEntity.getShardTable());
        }
        sql.append(" (").append(fieldsString).append(") values (");
        int n = fieldsString.split(",").length;
        for (int i = 0; i < n; ++i) {
            sql.append("?");
            if (i == n - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }

    private String getCrossInsetPkSql() {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        String pkTable = TableName.of((String)this.configuration.getMainTable()).getPKTable();
        IndexDefine[] defs = this.configuration.getMainShardingConfig().getOptions().getIndexDefines();
        if (defs == null || defs.length == 0) {
            sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
            sql.append(" into ").append(pkTable).append("(fpk,findex) values (?,?)");
        } else {
            sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
            sql.append(" into ").append(pkTable).append("(fpk");
            for (IndexDefine def : defs) {
                sql.append(',').append(def.getField());
            }
            sql.append(",findex )  values (?");
            for (IndexDefine def : defs) {
                sql.append(",?");
            }
            sql.append(",?)");
        }
        return sql.toString();
    }
}

