/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.service.calc.CountShardingTableCall;
import kd.bos.xdb.service.calc.CountTableCall;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.disablemove.work.DisableMoveWork;
import kd.bos.xdb.task.service.disablemove.work.DisableMoveWorkRunner;
import kd.bos.xdb.util.Threads;

public final class ShardingDisableService
extends ShardingTaskServiceAbst {
    public ShardingDisableService(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.DATAMOVE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doSharding() throws Exception {
        TableManager tm;
        block45: {
            boolean isPaused;
            block44: {
                Iterator<ShardProgressEntity> threadPool2;
                block47: {
                    Object tableName;
                    List<ShardProgressEntity> shardProgressEntities;
                    block46: {
                        tm = XDBConfig.getTableManager();
                        if (ShardTaskConfig.isShardingMovingDisableQuick()) break block45;
                        if (this.mainProgress.isCurStepExecuted()) {
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_1", (String)"Continue Data Migration", (Object[])new Object[0]));
                            this.mainProgress.setTotalRecord(this.taskEntity.getTotalRecord());
                            this.mainProgress.setMovedRecord(this.taskEntity.getMovingRecord());
                            this.mainProgress.store(true);
                        } else {
                            Object sc;
                            AtomicLong totalCount = new AtomicLong(0L);
                            ArrayList results = new ArrayList(this.configuration.getShardingConfigs().size());
                            int sourceTableCount = 0;
                            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                                sc = this.configuration.getShardingConfigs().get(seq);
                                String originalName = TableName.of((String)sc.getTable()).getOriginalName();
                                List<String> list = Arrays.asList(tm.getShardingTable(originalName));
                                sourceTableCount += list.size();
                                if (list.size() == 0) {
                                    results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(this.configuration.getRoute(), TableName.of((String)originalName).getPrototypeTable(), originalName))));
                                    continue;
                                }
                                for (String table : list) {
                                    results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(this.configuration.getRoute(), table, originalName))));
                                }
                            }
                            ArrayList countTableCalls = new ArrayList(results.size());
                            sc = results.iterator();
                            while (sc.hasNext()) {
                                Iterator<ShardProgressEntity> f = (Future)sc.next();
                                countTableCalls.add(f.get());
                            }
                            Map<String, List<CountTableCall>> originalNameMap = countTableCalls.stream().collect(Collectors.groupingBy(CountTableCall::getOriginalName));
                            for (Map.Entry entry : originalNameMap.entrySet()) {
                                String originalName = (String)entry.getKey();
                                List callList = (List)entry.getValue();
                                AtomicLong originalNameCount = new AtomicLong(0L);
                                for (CountTableCall tableCall : callList) {
                                    totalCount.addAndGet(tableCall.getCount());
                                    originalNameCount.addAndGet(tableCall.getCount());
                                }
                                String mvTable = TableName.of((String)originalName).getMovingTable(-1L);
                                if (tm.existTable(mvTable)) continue;
                                tm.createMovingTable(mvTable, -1L, ActionUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()));
                                ProgressUtil.insertProgressTable(this.taskEntity, originalName, -1L, originalNameCount.get());
                            }
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_0", (String)"Start data migration, first execution...", (Object[])new Object[0]));
                            this.mainProgress.setMovedRecord(0L);
                            this.mainProgress.setSourceTableCount(sourceTableCount);
                            this.mainProgress.setCurStepExecuted(true);
                            ProgressUtil.storeTotalRecord(this.taskEntity, totalCount.get(), this.mainProgress);
                        }
                        shardProgressEntities = ShardProgressRepository.get().loadUnexecutedProgressList(this.taskEntity.getId(), null);
                        for (ShardProgressEntity progressEntity : shardProgressEntities) {
                            tableName = progressEntity.getShardTable();
                            XDBManagerUtil.checkAllShardTableColumn((String)tableName, this.taskEntity.getEntitynumber());
                        }
                        isPaused = false;
                        if (!shardProgressEntities.isEmpty()) break block46;
                        if (ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId()) > 0L) {
                            throw ExceptionUtil.wrap((String)BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
                        }
                        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler datamove doDataMoving end,entitynumber:{0}, taskId:{1}, progressCount:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), shardProgressEntities.size()));
                        break block44;
                    }
                    if (ShardTaskConfig.isEnableMovingParallel()) {
                        ShardThreadPool threadPool2 = new ShardThreadPool();
                        tableName = null;
                        try {
                            threadPool2.setTable(this.taskEntity.getEntitynumber());
                            threadPool2.setName("XDB-DisableParallelThread-");
                            threadPool2.start();
                            ArrayList futureList = new ArrayList(shardProgressEntities.size());
                            for (ShardProgressEntity shardProgressEntity : shardProgressEntities) {
                                SubProgress subProgress = SubProgress.of(shardProgressEntity.getId(), this.taskEntity.getEntitynumber(), shardProgressEntity.getProgresssign());
                                subProgress.setParentSp(this.mainProgress);
                                Future future = threadPool2.submit(Threads.wrapCallable((Callable)new DisableMoveWorkRunner(new DisableMoveWork(shardProgressEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), shardProgressEntity)));
                                futureList.add(future);
                            }
                            boolean isException = false;
                            String string = "";
                            for (Future future : futureList) {
                                try {
                                    if (isException) {
                                        future.cancel(true);
                                        continue;
                                    }
                                    if (!isPaused) {
                                        isPaused = (Boolean)future.get();
                                        continue;
                                    }
                                    future.get();
                                }
                                catch (Throwable e) {
                                    StringWriter sw = new StringWriter();
                                    e.printStackTrace(new PrintWriter(sw));
                                    String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, sw.toString());
                                    XDBManagerUtil.logError(error, e);
                                    ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                                    if (isException) continue;
                                    String string2 = sw.toString();
                                    isException = true;
                                }
                            }
                            if (isException) {
                                threadPool2.shutdown();
                            }
                            break block44;
                        }
                        catch (Throwable futureList) {
                            tableName = futureList;
                            throw futureList;
                        }
                        finally {
                            if (threadPool2 != null) {
                                if (tableName != null) {
                                    try {
                                        threadPool2.close();
                                    }
                                    catch (Throwable futureList) {
                                        ((Throwable)tableName).addSuppressed(futureList);
                                    }
                                } else {
                                    threadPool2.close();
                                }
                            }
                        }
                    }
                    threadPool2 = shardProgressEntities.iterator();
                    break block47;
                    while (true) {
                        if (threadPool2.isTerminated()) {
                            void var8_29;
                            throw ExceptionUtil.wrap((String)var8_29);
                        }
                        Thread.sleep(200L);
                    }
                }
                while (threadPool2.hasNext()) {
                    ShardProgressEntity progressEntity = threadPool2.next();
                    if (this.shardTaskRuntime.isTaskPaused(this.configuration.getMainTable())) {
                        isPaused = true;
                        break;
                    }
                    SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                    subProgress.setParentSp(this.mainProgress);
                    DisableMoveWork moveWork = new DisableMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress);
                    isPaused = moveWork.doWork();
                    if (isPaused) break;
                    this.mainProgress.setExecSql(null);
                    this.mainProgress.store(false);
                }
            }
            long unclosed = ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId());
            if (isPaused) {
                if (unclosed != 0L) {
                    ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
                    XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingDataMoveService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_0", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
                    return true;
                }
                ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
                ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
            } else if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
                ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
            }
            if (unclosed > 0L) {
                throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
            }
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_3", (String)"Delete Intermediate Table", (Object[])new Object[0]));
            this.mainProgress.store(true);
            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                ShardingConfig sc = this.configuration.getShardingConfigs().get(seq);
                String string = TableName.of((String)sc.getTable()).getMovingTable(-1L);
                ActionUtil.dropTable(this.configuration.getRoute(), string);
                tm.removeCahce(string);
            }
        }
        this.mainProgress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_4", (String)"Delete All Shard Tables", (Object[])new Object[0]));
        this.mainProgress.store(true);
        Iterator<ShardingConfig> iterator = this.configuration.getShardingConfigs().iterator();
        block22: while (true) {
            if (!iterator.hasNext()) {
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_4", (String)"Data Migration Complete", (Object[])new Object[0]));
                this.mainProgress.store(true);
                return false;
            }
            ShardingConfig shardingConfig = iterator.next();
            String tableName = shardingConfig.getTable();
            TableName tn = TableName.of((String)tableName);
            ActionUtil.dropTable(this.configuration.getRoute(), tn.getPrototypeTable());
            ActionUtil.dropTable(this.configuration.getRoute(), tn.getOriginalsnapTable());
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_0", (String)"Delete Prototype Table: {0}", (Object[])new Object[]{tn.getPrototypeTable()}));
            this.mainProgress.store(true);
            if (shardingConfig instanceof MainTableConfig) {
                ActionUtil.dropTable(this.configuration.getRoute(), tn.getMapTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_1", (String)"Delete Map Table: {0}", (Object[])new Object[]{tn.getMapTable()}));
                this.mainProgress.store(true);
                ActionUtil.dropTable(this.configuration.getRoute(), tn.getPKTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_2", (String)"Delete Pk Table: {0}", (Object[])new Object[]{tn.getPKTable()}));
                this.mainProgress.store(true);
            }
            tm.clearCahce(tableName);
            String[] stringArray = tm.getShardingTable(tableName);
            int n = stringArray.length;
            boolean bl = false;
            while (true) {
                void var8_35;
                if (var8_35 >= n) continue block22;
                String sharingTable = stringArray[var8_35];
                ActionUtil.dropTable(this.configuration.getRoute(), sharingTable);
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_3", (String)"Delete Shard Table: {0}", (Object[])new Object[]{sharingTable}));
                this.mainProgress.store(true);
                ++var8_35;
            }
            break;
        }
    }
}

