/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove.writer;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class DisableWriter
extends WriterAbst {
    private ShardProgressEntity progressEntity;
    private DBRoute route;
    private String shardingTable;
    private String pkField;
    private String columnFields;
    private Object fromPK;
    private Object toPK;
    private int bufferSize;
    private int loop = 0;

    public DisableWriter(ShardProgressEntity progressEntity, Configuration configuration, String shardingTable, String pkField, IChildProgress progress) {
        super(configuration, progress);
        this.progressEntity = progressEntity;
        this.route = configuration.getRoute();
        this.shardingTable = shardingTable;
        this.pkField = pkField;
        this.columnFields = this.getColumns(TableName.of((String)progressEntity.getShardTable()).getOriginalsnapTable());
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws Exception {
        this.fromPK = writerBuffer.get(0).getPk();
        this.toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        this.bufferSize = writerBuffer.size();
        String tableName = this.progressEntity.getShardTable();
        if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
            this.checkDuplicate();
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (DBType.mysql == this.dbType) {
            sql.append("replace ");
        } else {
            sql.append("insert ");
        }
        sql.append(" into ").append(tableName);
        sql.append(" (").append(this.columnFields).append(") ");
        sql.append(" select ").append(this.columnFields).append(" from ").append(this.shardingTable).append(" where ").append(this.pkField).append(">=? and ").append(this.pkField).append("<=?");
        DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_7", (String)"Data migration,tableName:{0},shardingTable:{1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{tableName, this.shardingTable, this.fromPK, this.toPK, this.bufferSize}));
        this.progress.setToPk(this.toPK);
        this.progress.setExecSql(sql.toString());
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        ProgressUtil.incrMoveRecordAndStore((ITaskEntity)this.progressEntity, this.progressEntity.getShardTable(), (long)this.bufferSize, this.progress);
    }

    private String getColumns(String table) {
        List columnList = MetaFactory.getMeta().queryColumns(table);
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            columnStr.append(((Column)columnList.get(i)).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        return columnStr.toString();
    }

    private void checkDuplicate() {
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        sql.append("select ").append(this.pkField).append(" from ").append(this.progressEntity.getShardTable()).append(" where ").append(this.pkField).append(" in (");
        sql.append("select ").append(this.pkField).append(" from ").append(this.shardingTable).append(" where ").append(this.pkField).append(" >= ? and ").append(this.pkField).append(" <= ?");
        sql.append(")");
        List existsList = (List)DB.query((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK}, rs -> {
            ArrayList<Object> dataList = new ArrayList<Object>(10);
            while (rs.next()) {
                dataList.add(rs.getObject(1));
            }
            return dataList;
        });
        if (existsList.size() > 0) {
            sql.setLength(0);
            sql.append("delete from ").append(this.progressEntity.getShardTable()).append(" where ").append(this.pkField).append(" in (");
            sql.append("select ").append(this.pkField).append(" from ").append(this.shardingTable).append(" where ").append(this.pkField).append(" >= ? and ").append(this.pkField).append(" <= ?");
            sql.append(")");
            DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_6", (String)"Abnormal data migration recovery Clear abnormal data, tableName:{0},shardingTable:{1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.progressEntity.getShardTable(), this.shardingTable, this.fromPK, this.toPK, this.bufferSize}));
            this.progress.setExecSql(sql.toString());
            this.progress.store();
        }
    }
}

