/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.enablemove;

import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.enablemove.work.EnableMoveWork;
import kd.bos.xdb.task.service.enablemove.work.EnableMoveWorkRunner;
import kd.bos.xdb.util.Threads;

public final class ShardingDataMoveService
extends ShardingTaskServiceAbst {
    public ShardingDataMoveService(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.DATAMOVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doSharding() throws Exception {
        String[] movingTables;
        boolean isPaused;
        DBRoute route;
        TableManager tm;
        block41: {
            Object threadPool;
            block43: {
                String runtimeException;
                List<ShardProgressEntity> shardProgressEntities;
                block42: {
                    tm = XDBConfig.getTableManager();
                    route = this.configuration.getRoute();
                    for (ShardingConfig sc : this.configuration.getShardingConfigs()) {
                        if (sc == this.configuration.getMainShardingConfig()) continue;
                        sc.getShardingStrategy().ensureTableInited();
                    }
                    boolean useIndexPK = this.configuration.getMainShardingConfig().isIndexPK();
                    TableName mainTN = TableName.of((String)this.configuration.getMainTable());
                    if (useIndexPK && !tm.existTable(mainTN.getPKTable())) {
                        tm.createPKTable(ExtContext.get().getDBRoute(), mainTN.getPKTable(), XDBManagerUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()), this.configuration.getMainShardingConfig().getOptions().getDataRowsRange(), this.configuration.getMainShardingConfig().getOptions().getIndexDefines());
                    }
                    if (ShardTaskConfig.isEnableMovingParallel()) {
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_1", (String)"Migrate Data in Parallel", (Object[])new Object[0]));
                    } else {
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_2", (String)"Serial Migration of Data", (Object[])new Object[0]));
                    }
                    this.mainProgress.setTotalRecord(this.taskEntity.getTotalRecord());
                    this.mainProgress.store(true);
                    shardProgressEntities = ShardProgressRepository.get().loadUnexecutedProgressList(this.taskEntity.getId(), null);
                    isPaused = false;
                    if (!shardProgressEntities.isEmpty()) break block42;
                    if (ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId()) > 0L) {
                        throw ExceptionUtil.wrap((String)BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
                    }
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler datamove doDataMoving end,entitynumber:{0}, taskId:{1}, progressCount:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), shardProgressEntities.size()));
                    break block41;
                }
                if (ShardTaskConfig.isEnableMovingParallel()) {
                    threadPool = new ShardThreadPool();
                    Throwable throwable = null;
                    try {
                        ((ShardThreadPool)threadPool).setTable(this.taskEntity.getEntitynumber());
                        ((ShardThreadPool)threadPool).setName("XDB-MoveParallelThread-");
                        ((ShardThreadPool)threadPool).start();
                        ArrayList futureList = new ArrayList(shardProgressEntities.size());
                        for (ShardProgressEntity progressEntity : shardProgressEntities) {
                            SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                            subProgress.setMovingTable(progressEntity.getShardTable());
                            subProgress.setParentSp(this.mainProgress);
                            Future future = ((ShardThreadPool)threadPool).submit(Threads.wrapCallable((Callable)new EnableMoveWorkRunner(new EnableMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), progressEntity)));
                            futureList.add(future);
                        }
                        boolean isException = false;
                        runtimeException = "";
                        for (Future future : futureList) {
                            try {
                                if (isException) {
                                    future.cancel(true);
                                    continue;
                                }
                                if (!isPaused) {
                                    isPaused = (Boolean)future.get();
                                    continue;
                                }
                                future.get();
                            }
                            catch (Throwable e) {
                                String[] sw = new StringWriter();
                                e.printStackTrace(new PrintWriter((Writer)sw));
                                String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, sw.toString());
                                XDBManagerUtil.logError(error, e);
                                ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                                if (isException) continue;
                                runtimeException = sw.toString();
                                isException = true;
                            }
                        }
                        if (isException) {
                            ((ShardThreadPool)threadPool).shutdown();
                        }
                        break block41;
                    }
                    catch (Throwable futureList) {
                        throwable = futureList;
                        throw futureList;
                    }
                    finally {
                        if (threadPool != null) {
                            if (throwable != null) {
                                try {
                                    ((ShardThreadPool)threadPool).close();
                                }
                                catch (Throwable futureList) {
                                    throwable.addSuppressed(futureList);
                                }
                            } else {
                                ((ShardThreadPool)threadPool).close();
                            }
                        }
                    }
                }
                threadPool = shardProgressEntities.iterator();
                break block43;
                while (true) {
                    if (((ShardThreadPool)threadPool).isTerminated()) {
                        throw ExceptionUtil.wrap((String)runtimeException);
                    }
                    Thread.sleep(200L);
                }
            }
            while (threadPool.hasNext()) {
                ShardProgressEntity progressEntity = (ShardProgressEntity)threadPool.next();
                if (this.shardTaskRuntime.isTaskPaused(this.configuration.getMainTable())) {
                    isPaused = true;
                    break;
                }
                SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                subProgress.setMovingTable(progressEntity.getShardTable());
                subProgress.setParentSp(this.mainProgress);
                EnableMoveWork moveWork = new EnableMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress);
                isPaused = moveWork.doWork();
                if (isPaused) break;
                this.mainProgress.setExecSql(null);
                this.mainProgress.store(false);
            }
        }
        long unclosed = ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId());
        if (isPaused) {
            if (unclosed != 0L) {
                ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
                XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingDataMoveService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_0", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
                return true;
            }
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        } else if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        }
        if (unclosed > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
        }
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionEnableDataMove_7", (String)"Delete Header Intermediate Table", (Object[])new Object[0]));
        this.mainProgress.store(true);
        for (String movingTable : movingTables = this.getMovingTable()) {
            ActionUtil.dropTable(route, movingTable);
            tm.removeCahce(movingTable);
        }
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionEnableDataMove_8", (String)"Delete Sub-table Intermediate Table", (Object[])new Object[0]));
        this.mainProgress.store(true);
        Multimap<ShardingConfig, ShardingConfig> multimap = this.configuration.getMultimap();
        Map map = multimap.asMap();
        for (Map.Entry entry : map.entrySet()) {
            ShardingConfig key = (ShardingConfig)entry.getKey();
            if (key instanceof MainTableConfig) continue;
            for (String movingTable : movingTables) {
                TableName entryTN = TableName.of((String)movingTable);
                String subMovingTable = TableName.of((String)key.getTable()).getMovingTable(entryTN.getMovingIndex());
                ActionUtil.dropTable(route, subMovingTable);
                tm.removeCahce(movingTable);
            }
        }
        if (ShardTaskConfig.isEnableMovingBackup()) {
            int from;
            for (int seq = from = (int)this.mainProgress.getMovingShardingIndex() + 1; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                ShardingConfig sc = this.configuration.getShardingConfigs().get(seq);
                String originalName = TableName.of((String)sc.getTable()).getOriginalName();
                if (DB.exitsTable((DBRoute)route, (String)originalName)) {
                    if (DB.exitsTable((DBRoute)route, (String)(originalName + "$bak"))) {
                        ActionUtil.dropTable(route, originalName + "$bak");
                    }
                    ActionUtil.backupTable(route, originalName);
                }
                this.mainProgress.setMovingShardingIndex(seq);
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_1", (String)"Backup", (Object[])new Object[0]) + originalName);
                this.mainProgress.store(true);
            }
        }
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_4", (String)"Data Migration Complete", (Object[])new Object[0]));
        this.mainProgress.store(true);
        return false;
    }

    private String[] getMovingTable() throws SQLException {
        String[] movingTables = XDBConfig.getTableManager().getMovingTable(this.configuration.getMainTable());
        movingTables = this.getSortTables(movingTables, "$m");
        return movingTables;
    }

    private String[] getSortTables(String[] sortTables, String split) {
        split = split.toUpperCase();
        if (sortTables.length > 1) {
            int i;
            HashMap<Long, String> map = new HashMap<Long, String>(sortTables.length);
            String[] sortedMovingtables = new String[sortTables.length];
            long[] indexes = new long[sortTables.length];
            int lastIndexOfMV = sortTables[0].toUpperCase().lastIndexOf(split);
            for (i = 0; i < sortTables.length; ++i) {
                long index;
                String mi = sortTables[i];
                indexes[i] = index = Long.parseLong(mi.substring(lastIndexOfMV + split.length()));
                map.put(index, mi);
            }
            Arrays.sort(indexes);
            for (i = 0; i < indexes.length; ++i) {
                sortedMovingtables[i] = (String)map.get(indexes[i]);
            }
            return sortedMovingtables;
        }
        return sortTables;
    }
}

