/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.enablemove.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.IWork;
import kd.bos.xdb.task.service.enablemove.reader.DataMoveReader;
import kd.bos.xdb.task.service.enablemove.writer.DataMoveWriter;
import kd.bos.xdb.taskgroup.TaskGroupExecutor;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public class EnableMoveWork
implements IWork {
    protected ShardProgressEntity progressEntity;
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected SubProgress subProgress;
    protected Object prePk = null;

    public EnableMoveWork(ShardProgressEntity progressEntity, ShardTaskEntity taskEntity, Configuration configuration, SubProgress subProgress) {
        this.progressEntity = progressEntity;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.subProgress = subProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork begin,entitynumber:{0}, shardTable:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork interrupted,entitynumber:{0}, shardTable:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
            return false;
        }
        try (TXHandle tx = TX.notSupported((String)"EnableMoveWork.doWork");
             DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            int c = ShardProgressRepository.get().updateExecuting(this.progressEntity.getId());
            if (c <= 0) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork updateExecuting error,entitynumber:{0}, shardTable:{1},taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = false;
                return bl;
            }
            boolean isContinue = false;
            if (this.subProgress.getToPk() != null) {
                this.prePk = this.subProgress.getToPk();
                isContinue = true;
            }
            if (isContinue) {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_1", (String)"Continue to migrate shards, index: {0}, header pks: {1}, lastPk: {2}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.progressEntity.getShardTotalRecord(), this.prePk}));
            } else {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_2", (String)"Start migrating shards, index: {0}, header pks: {1}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.progressEntity.getShardTotalRecord()}));
            }
            this.subProgress.store();
            TableManager tm = XDBConfig.getTableManager();
            for (ShardingConfig sc : this.configuration.getShardingConfigs()) {
                TableName entryTN = TableName.of((String)sc.getTable());
                String shardingTable = entryTN.getShardingTable(this.progressEntity.getShardIndex());
                if (tm.existTable(shardingTable)) continue;
                tm.createShardingTable(shardingTable, this.progressEntity.getShardIndex());
            }
            DataMoveReader pkReader = new DataMoveReader(this.progressEntity, this.configuration, this.prePk);
            DataMoveWriter pkWriter = new DataMoveWriter(this.progressEntity, this.configuration, this.subProgress);
            Communication runnerCommunication = new Communication();
            TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "MOVE#" + this.progressEntity.getShardTable());
            pkGroupExecutor.doStart();
            if (runnerCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ShardTaskMovingHandler EnableMoveWork stateReturnFailed,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), sw.toString());
                XDBManagerUtil.logError(error, runnerCommunication.getThrowable());
                ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), error, "MOVE#" + this.progressEntity.getShardTable());
                throw ExceptionUtil.asRuntimeException((String)sw.toString(), (Throwable)runnerCommunication.getThrowable());
            }
            if (runnerCommunication.getState() == State.PAUSED) {
                ShardProgressRepository.get().setProgressSuspended(this.progressEntity.getId());
                ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"DataMoveWork_2", (String)"Task paused, index:{0}", (Object[])new Object[]{this.progressEntity.getShardIndex()}), "MOVE#" + this.progressEntity.getShardTable());
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork paused,entitynumber:{0}, shardTable:{1}, taskId:{1}, splitTaskId:{2}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = true;
                return bl;
            }
            if (Thread.currentThread().isInterrupted()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork interrupted,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = false;
                return bl;
            }
            this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveWork_3", (String)"Shard migration completed, index:{0}", (Object[])new Object[]{this.progressEntity.getShardIndex()}));
            this.subProgress.setExecSql(null);
            this.subProgress.store();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            XDBManagerUtil.logError(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork error, entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), runtimeException), e);
            ShardProgressRepository.get().setProgressFailedByTaskId(this.progressEntity.getId());
            throw ExceptionUtil.asRuntimeException((String)runtimeException, (Throwable)e);
        }
        ShardProgressRepository.get().updateProgressSuccess(this.progressEntity.getId());
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler EnableMoveWork end,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        return false;
    }
}

