/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.enablemove.writer;

import com.google.common.collect.Multimap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.temptable.pk.PKTempTableUtil;
import kd.bos.db.temptable.pk.table.PKTempTableType;
import kd.bos.ksql.shell.KDResultSetUnwrapper;
import kd.bos.orm.ORM;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class DataMoveWriter
extends WriterAbst {
    private ShardProgressEntity progressEntity;
    private ShardingConfig mainShardingConfig;
    private DBRoute route;
    private TableManager tm = XDBConfig.getTableManager();
    private boolean useIndexPK;
    private TableName mainTN;
    private long shardingIndex;
    private String mainMovingTable;
    private Object fromPK;
    private Object toPK;
    private int bufferSize;
    private int loop = 0;

    public DataMoveWriter(ShardProgressEntity progressEntity, Configuration configuration, IChildProgress progress) {
        super(configuration, progress);
        this.progressEntity = progressEntity;
        this.mainShardingConfig = configuration.getMainShardingConfig();
        this.useIndexPK = this.mainShardingConfig.isIndexPK();
        this.mainTN = TableName.of((String)configuration.getMainTable());
        this.route = configuration.getRoute();
        this.shardingIndex = progressEntity.getShardIndex();
        this.mainMovingTable = this.mainTN.getMovingTable(this.shardingIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws Exception {
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias().toLowerCase();
        this.fromPK = writerBuffer.get(0).getPk();
        this.toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        this.bufferSize = writerBuffer.size();
        StringBuilder sql = new StringBuilder();
        if (this.useIndexPK) {
            String pkTable = this.mainTN.getPKTable();
            if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
                sql.setLength(0);
                sql.append("delete from ").append(pkTable).append(" where findex=? and fpk>=? and fpk<=?");
                Semaphore sp = this.progress.getParentSp().getDeletePKSemaphore();
                sp.acquire();
                try {
                    DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.shardingIndex, this.fromPK, this.toPK});
                }
                finally {
                    sp.release();
                }
            }
            sql.setLength(0);
            IndexDefine[] defs = this.mainShardingConfig.getOptions().getIndexDefines();
            if (defs == null || defs.length == 0) {
                sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
                sql.append(" into ").append(pkTable).append("(fpk,findex) select FID,").append(this.shardingIndex).append(" from ").append(this.mainMovingTable).append(" where FID >=? and FID<=? ");
            } else {
                HashMap<String, Character> joinTableAliasMap = new HashMap<String, Character>();
                for (IndexDefine def : defs) {
                    Character alias = (Character)joinTableAliasMap.get(def.getTable());
                    if (alias != null) continue;
                    alias = Character.valueOf((char)(66 + joinTableAliasMap.size()));
                    joinTableAliasMap.put(def.getTable(), alias);
                }
                sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
                sql.append(" into ").append(pkTable).append("(fpk,findex");
                for (IndexDefine def : defs) {
                    sql.append(',').append(def.getField());
                }
                sql.append(") select A.FID,").append(this.shardingIndex);
                for (IndexDefine def : defs) {
                    sql.append(',').append(joinTableAliasMap.get(def.getTable())).append('.').append(def.getField());
                }
                sql.append(" from ").append(this.mainMovingTable).append(" A");
                for (Map.Entry entry : joinTableAliasMap.entrySet()) {
                    sql.append(" inner join ").append((String)entry.getKey()).append(' ').append(entry.getValue()).append(" on A.FID=").append(entry.getValue()).append('.').append(pkField);
                }
                sql.append(" where A.FID >=? and A.FID<=? ");
            }
            DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
        }
        String mainShardingTable = this.mainTN.getShardingTable(this.shardingIndex);
        if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
            sql.setLength(0);
            sql.append("select ").append(pkField).append(" from ").append(mainShardingTable).append(" where ").append(pkField).append(" >=? and ").append(pkField).append(" <=?");
            List existsList = (List)DB.query((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK}, rs -> {
                ArrayList<Object> dataList = new ArrayList<Object>(10);
                while (rs.next()) {
                    dataList.add(rs.getObject(1));
                }
                return dataList;
            });
            if (existsList.size() > 0) {
                sql.setLength(0);
                sql.append("delete from ").append(mainShardingTable).append(" where ").append(pkField).append(" >= ? and ").append(pkField).append("<=?");
                DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
                this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_4", (String)"Header data migration exception recovery Clear exception data, index:{0},fromPK={1},toPK={2},size={3}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.fromPK, this.toPK, this.bufferSize}));
                this.progress.setExecSql(sql.toString());
                this.progress.store();
            }
        }
        sql.setLength(0);
        sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
        sql.append(" into ").append(mainShardingTable).append(" select B.* from ").append(this.mainMovingTable).append(" A inner join ").append(this.mainTN.getOriginalName()).append(" B on B.").append(pkField).append("=A.FID where A.FID>=? and A.FID<=?");
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_5", (String)"Header data migration, index:{0},fromPK={1},toPK={2},size={3}", (Object[])new Object[]{this.progressEntity.getShardIndex(), this.fromPK, this.toPK, this.bufferSize}));
        this.progress.setExecSql(sql.toString());
        this.progress.store();
        DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
        this.doMovingExpand();
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(this.toPK);
        this.progress.setExecSql(null);
        ProgressUtil.incrMoveRecordAndStore((ITaskEntity)this.progressEntity, this.shardingIndex, (long)this.bufferSize, this.progress);
    }

    private void doMovingExpand() throws SQLException {
        Multimap<ShardingConfig, ShardingConfig> multimap = this.configuration.getMultimap();
        TreeSet<ShardingConfig> sortKey = this.getSortConfigKey(multimap);
        Iterator<ShardingConfig> iterator = sortKey.iterator();
        block0: while (iterator.hasNext()) {
            Range entryRange;
            ShardingConfig shardingConfig;
            ShardingConfig key = shardingConfig = iterator.next();
            Object[] value = multimap.get((Object)key).toArray();
            String entryPKField = ShardConfigEntity.isTcTableShardingDBConfig(key) ? "FID" : (ShardConfigEntity.isWbTableShardingDBConfig(key) ? "FEntryId" : ORM.create().getDataEntityType(key.getName()).getPrimaryKey().getAlias());
            if (key == this.mainShardingConfig) {
                for (Object sc : value) {
                    if (sc == this.mainShardingConfig) continue;
                    Range range = new Range();
                    range.fromPK = this.fromPK;
                    range.toPK = this.toPK;
                    range.size = this.bufferSize;
                    this.movingExpandInsert((ShardingConfig)sc, this.mainMovingTable, range, entryPKField);
                }
                continue;
            }
            ChildrenTableConfig childrenShardingConfig = (ChildrenTableConfig)key;
            TableName entryTN = TableName.of((String)childrenShardingConfig.getTable());
            String childrenMovingTable = entryTN.getMovingTable(this.shardingIndex);
            ShardingConfig parentConfig = childrenShardingConfig.getParent();
            boolean isMain = parentConfig instanceof MainTableConfig;
            String parentMovingTable = isMain ? this.mainMovingTable : TableName.of((String)parentConfig.getTable()).getMovingTable(this.shardingIndex);
            String joinField = childrenShardingConfig.getJoinField();
            if (!this.tm.existTable(childrenMovingTable)) {
                PKTempTableUtil.createPKTable((DBRoute)this.route, (PKTempTableType)ActionUtil.getPKTempTableTypeEnum(this.progressEntity.getEntitynumber()), (String)childrenMovingTable);
            } else {
                PKTempTableUtil.truncateTable((DBRoute)this.route, (String)childrenMovingTable);
            }
            StringBuilder sql = new StringBuilder(128);
            sql.setLength(0);
            sql.append("insert into ").append(childrenMovingTable).append(" select B.").append(entryPKField).append(" from ").append(parentMovingTable).append(" A").append(" inner join ").append(entryTN.getOriginalName()).append(" B on A.FID=B.").append(joinField);
            if (isMain) {
                sql.append(" where A.FID>=? and A.FID<=? ");
                DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
            } else {
                DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true));
            }
            Object entryFormPK = null;
            while ((entryRange = this.reader(childrenMovingTable, "fid", entryFormPK, this.route)).size != 0L) {
                List<Range> insertRanges = this.splitRange(entryRange.pks, XDBManagerConstant.INSERT_PAGE_SIZE);
                for (Range subRange : insertRanges) {
                    for (Object sc : value) {
                        this.movingExpandInsert((ShardingConfig)sc, childrenMovingTable, subRange, entryPKField);
                    }
                }
                if (entryRange.size != (long)XDBManagerConstant.PAGE_SIZE) continue block0;
                entryFormPK = entryRange.toPK;
                this.progress.setExecSql(null);
            }
        }
    }

    private void movingExpandInsert(ShardingConfig childrenShardingConfig, String childrenMovingTable, Range range, String entryPKField) {
        StringBuilder sql = new StringBuilder(128);
        TableName entryTN = TableName.of((String)childrenShardingConfig.getTable());
        String childrenShardingTable = entryTN.getShardingTable(this.shardingIndex);
        if (ShardConfigEntity.isPrivacyTableShardingDBConfig(childrenShardingConfig)) {
            entryPKField = "FBizId";
        }
        if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
            this.checkDuplicate(childrenShardingConfig, childrenMovingTable, range, entryPKField);
        }
        sql.setLength(0);
        sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
        sql.append(" into ").append(childrenShardingTable).append(" select B.* from ").append(childrenMovingTable).append(" A inner join ").append(entryTN.getOriginalName()).append(" B on B.").append(entryPKField).append("=A.FID where A.FID>=? and A.FID<=?");
        DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{range.fromPK, range.toPK});
        this.progress.setProgressDesc_3(BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_8", (String)"E-R level: {0}, index: {1}, data in subtable{2}, fromPK={3}, toPK={4}, size={5}", (Object[])new Object[]{childrenShardingConfig.getName(), this.shardingIndex, childrenShardingTable, range.fromPK, range.toPK, range.size}));
        this.progress.setExecSql(sql.toString());
        this.progress.store();
    }

    private void checkDuplicate(ShardingConfig childrenShardingConfig, String childrenMovingTable, Range subRange, String entryPKField) {
        TableName entryTN = TableName.of((String)childrenShardingConfig.getTable());
        String childrenShardingTable = entryTN.getShardingTable(this.shardingIndex);
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        sql.append("select B.").append(entryPKField).append(" from ").append(childrenMovingTable).append(" A inner join ").append(childrenShardingTable).append(" B on B.").append(entryPKField).append("=A.FID where A.FID>=? and A.FID<=?");
        List existsList = (List)DB.query((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{subRange.fromPK, subRange.toPK}, rs -> {
            ArrayList<Object> dataList = new ArrayList<Object>(10);
            while (rs.next()) {
                dataList.add(rs.getObject(1));
            }
            return dataList;
        });
        if (existsList.size() > 0) {
            List<Range> deleteRanges = this.splitRange(existsList, XDBManagerConstant.DELETE_PAGE_SIZE);
            for (Range subDelRange : deleteRanges) {
                sql.setLength(0);
                sql.append("delete from ").append(childrenShardingTable).append(" where ").append(entryPKField).append(" in (");
                for (int i = 0; i < subDelRange.pks.size(); ++i) {
                    sql.append("?");
                    if (i == subDelRange.pks.size() - 1) continue;
                    sql.append(",");
                }
                sql.append(")");
                DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])subDelRange.pks.toArray());
            }
            this.progress.setProgressDesc_3(childrenShardingConfig.getName() + "," + childrenShardingConfig.getTable() + BosRes.get((String)"bos-xdb-manager", (String)"DataMoveCallableMove_9", (String)"E-R level: {0}, index: {1}, subtable{2} data migration abnormal recovery and clear abnormal data, fromPK={3}, toPK={4}, size={5}", (Object[])new Object[]{childrenShardingConfig.getName(), this.shardingIndex, childrenShardingTable, subRange.fromPK, subRange.toPK, subRange.size}));
            this.progress.setExecSql(sql.toString());
            this.progress.store();
        }
    }

    private TreeSet<ShardingConfig> getSortConfigKey(Multimap<ShardingConfig, ShardingConfig> multimap) {
        TreeSet<ShardingConfig> sortKey = new TreeSet<ShardingConfig>((o1, o2) -> {
            int level1 = 0;
            if (o1 instanceof ChildrenTableConfig) {
                ShardingConfig t01 = o1;
                while (t01 instanceof ChildrenTableConfig) {
                    ++level1;
                    t01 = ((ChildrenTableConfig)t01).getParent();
                }
            }
            int level2 = 0;
            if (o2 instanceof ChildrenTableConfig) {
                ShardingConfig t02 = o2;
                while (t02 instanceof ChildrenTableConfig) {
                    ++level2;
                    t02 = ((ChildrenTableConfig)t02).getParent();
                }
            }
            if (level1 == level2) {
                return o1.getTable().compareToIgnoreCase(o2.getTable());
            }
            return level1 - level2;
        });
        Map map = multimap.asMap();
        for (Map.Entry entry : map.entrySet()) {
            sortKey.add((ShardingConfig)entry.getKey());
        }
        return sortKey;
    }

    private Range reader(String tableName, String pkField, Object fromPK, DBRoute route) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE).append(" ").append(pkField).append(" from ").append(tableName);
        Object[] params = null;
        if (fromPK != null) {
            params = new Object[]{fromPK};
            sql.append(" where ").append(pkField).append(">?");
        }
        sql.append(" order by ").append(pkField);
        String s = ActionUtil.wrapSQL(sql.toString(), false, true);
        return (Range)DB.query((DBRoute)route, (String)s, (Object[])params, rs -> {
            rs = rs.unwrap(KDResultSetUnwrapper.class).get().getInternalResultSet();
            Range range = new Range();
            range.pks = new ArrayList(XDBManagerConstant.PAGE_SIZE);
            int size = 0;
            if (rs.next()) {
                range.fromPK = rs.getObject(1);
                range.pks.add(range.fromPK);
                ++size;
            }
            Object last = range.fromPK;
            while (rs.next()) {
                Object temp;
                last = temp = rs.getObject(1);
                range.pks.add(temp);
                ++size;
            }
            range.toPK = last;
            range.size = size;
            return range;
        });
    }

    private List<Range> splitRange(List<Object> pks, int pageSize) {
        ArrayList<Range> ranges = new ArrayList<Range>(pks.size() / pageSize + 1);
        if (pks.size() <= pageSize) {
            Range range = new Range();
            range.fromPK = pks.get(0);
            range.toPK = pks.get(pks.size() - 1);
            range.pks = pks;
            range.size = pks.size();
            ranges.add(range);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                Range range = new Range();
                range.fromPK = pks.get(fromIndex);
                range.toPK = pks.get(toIndex);
                range.pks = pks.subList(fromIndex, toIndex + 1);
                range.size = toIndex - fromIndex + 1;
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }

    static class Range {
        private Object fromPK;
        private Object toPK;
        private List<Object> pks;
        private long size;

        Range() {
        }
    }
}

