/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.indexmove;

import com.alibaba.druid.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.service.calc.CountShardingTableCall;
import kd.bos.xdb.service.calc.CountTableCall;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.indexmove.work.IndexMoveWork;
import kd.bos.xdb.task.service.indexmove.work.IndexMoveWorkRunner;
import kd.bos.xdb.util.Threads;

public class ShardingIndexMoveService
extends ShardingTaskServiceAbst {
    public ShardingIndexMoveService(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.INDEXMOVE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doSharding() throws Exception {
        boolean isPaused;
        TableName mainTN;
        TableManager tm;
        block47: {
            Object threadPool;
            block49: {
                String runtimeException;
                List<ShardProgressEntity> shardProgressEntities;
                Object shardTables;
                block48: {
                    Set<IndexDefine> fastIndexDefineSet = this.configuration.getFastIndexDefineSet();
                    if (!XDBManagerUtil.validateFastIndexConfigurable(this.configuration.getFastIndex(), this.configuration.getLastFastIndex())) {
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_1", (String)"Continue Index Data Migration", (Object[])new Object[0]));
                        this.mainProgress.store(true);
                        return false;
                    }
                    tm = XDBConfig.getTableManager();
                    boolean useIndexPK = this.configuration.getMainShardingConfig().isIndexPK();
                    mainTN = TableName.of((String)this.configuration.getMainTable());
                    if (useIndexPK && !tm.existTable(mainTN.getPKTempTable())) {
                        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(this.taskEntity.getEntitynumber());
                        Set allShardRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
                        allShardRoutes.add(this.configuration.getRoute().getRouteKey());
                        for (String shardRoute : allShardRoutes) {
                            String pkTempTable = TableName.of((String)mainTN.getPKTempTable()).getPKTempTable();
                            if (DB.exitsTable((DBRoute)DBRoute.of((String)shardRoute), (String)pkTempTable)) continue;
                            tm.createPKTempTable(shardRoute, pkTempTable, XDBManagerUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()), this.configuration.getMainShardingConfig().getOptions().getDataRowsRange(), fastIndexDefineSet.toArray(new IndexDefine[fastIndexDefineSet.size()]));
                        }
                    }
                    if (this.mainProgress.isCurStepExecuted()) {
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_1", (String)"Continue Index Data Migration", (Object[])new Object[0]));
                        this.mainProgress.setTotalRecord(this.taskEntity.getTotalRecord());
                        this.mainProgress.setMovedRecord(this.taskEntity.getMovingRecord());
                        this.mainProgress.store(true);
                    } else {
                        Iterator shardTable;
                        AtomicLong totalCount = new AtomicLong(0L);
                        ShardingConfig sc = this.configuration.getMainShardingConfig();
                        String originalName = TableName.of((String)sc.getTable()).getOriginalName();
                        shardTables = Arrays.asList(tm.getShardingTable(originalName));
                        ArrayList results = new ArrayList(shardTables.size());
                        if (shardTables.size() == 0) {
                            results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(this.configuration.getRoute(), TableName.of((String)originalName).getPrototypeTable(), originalName))));
                        } else {
                            Iterator<String> iterator = shardTables.iterator();
                            while (iterator.hasNext()) {
                                shardTable = iterator.next();
                                DBRoute dBRoute = DBRoute.of((String)this.getRouteOfTable((String)((Object)shardTable)));
                                results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(dBRoute, (String)((Object)shardTable), originalName))));
                            }
                        }
                        ArrayList countTableCalls = new ArrayList(results.size());
                        for (Future future : results) {
                            countTableCalls.add(future.get());
                        }
                        shardTable = countTableCalls.iterator();
                        while (shardTable.hasNext()) {
                            CountTableCall countTableCall = (CountTableCall)shardTable.next();
                            String shardTable2 = countTableCall.getShardTable();
                            TableName tableName = TableName.of((String)shardTable2);
                            long count = countTableCall.getCount();
                            totalCount.addAndGet(count);
                            long shardingIndex = tableName.isPrototypeTable() ? -1L : tableName.getShardingIndex();
                            String mvTable = tableName.getMovingTable(shardingIndex);
                            if (tm.existTable(mvTable)) continue;
                            tm.createMovingTable(mvTable, shardingIndex, ActionUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()));
                            ProgressUtil.insertProgressTable(this.taskEntity, shardTable2, shardingIndex, count, this.configuration.getRoute().getRouteKey(), this.getRouteOfTable(shardTable2));
                        }
                        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_0", (String)"Start index data migration, first execution...", (Object[])new Object[0]));
                        this.mainProgress.setMovedRecord(0L);
                        this.mainProgress.setSourceTableCount(shardTables.size());
                        this.mainProgress.setCurStepExecuted(true);
                        ProgressUtil.storeTotalRecord(this.taskEntity, totalCount.get(), this.mainProgress);
                    }
                    shardProgressEntities = ShardProgressRepository.get().loadUnexecutedProgressList(this.taskEntity.getId(), null);
                    isPaused = false;
                    if (!shardProgressEntities.isEmpty()) break block48;
                    if (ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId()) > 0L) {
                        throw ExceptionUtil.wrap((String)BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_2", (String)"There are outstanding parallel index migration task", (Object[])new Object[0]));
                    }
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler indexMove doIndexMoving end,entitynumber:{0}, taskId:{1}, progressCount:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), shardProgressEntities.size()));
                    break block47;
                }
                if (ShardTaskConfig.isEnableMovingParallel()) {
                    threadPool = new ShardThreadPool();
                    shardTables = null;
                    try {
                        ((ShardThreadPool)threadPool).setTable(this.taskEntity.getEntitynumber());
                        ((ShardThreadPool)threadPool).setName("XDB-IndexMoveParallelThread-");
                        ((ShardThreadPool)threadPool).start();
                        ArrayList futureList = new ArrayList(shardProgressEntities.size());
                        for (ShardProgressEntity progressEntity : shardProgressEntities) {
                            SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                            subProgress.setParentSp(this.mainProgress);
                            subProgress.setMovingTable(progressEntity.getShardTable());
                            Future future = ((ShardThreadPool)threadPool).submit(Threads.wrapCallable((Callable)new IndexMoveWorkRunner(new IndexMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), progressEntity)));
                            futureList.add(future);
                        }
                        boolean isException = false;
                        runtimeException = "";
                        for (Future future : futureList) {
                            try {
                                if (isException) {
                                    future.cancel(true);
                                    continue;
                                }
                                if (!isPaused) {
                                    isPaused = (Boolean)future.get();
                                    continue;
                                }
                                future.get();
                            }
                            catch (Throwable e) {
                                StringWriter sw = new StringWriter();
                                e.printStackTrace(new PrintWriter(sw));
                                String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), isException, sw.toString());
                                XDBManagerUtil.logError(error, e);
                                ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                                if (isException) continue;
                                runtimeException = sw.toString();
                                isException = true;
                            }
                        }
                        if (isException) {
                            ((ShardThreadPool)threadPool).shutdown();
                        }
                        break block47;
                    }
                    catch (Throwable futureList) {
                        shardTables = futureList;
                        throw futureList;
                    }
                    finally {
                        if (threadPool != null) {
                            if (shardTables != null) {
                                try {
                                    ((ShardThreadPool)threadPool).close();
                                }
                                catch (Throwable futureList) {
                                    ((Throwable)shardTables).addSuppressed(futureList);
                                }
                            } else {
                                ((ShardThreadPool)threadPool).close();
                            }
                        }
                    }
                }
                threadPool = shardProgressEntities.iterator();
                break block49;
                while (true) {
                    if (((ShardThreadPool)threadPool).isTerminated()) {
                        throw ExceptionUtil.wrap((String)runtimeException);
                    }
                    Thread.sleep(200L);
                }
            }
            while (threadPool.hasNext()) {
                ShardProgressEntity progressEntity = (ShardProgressEntity)threadPool.next();
                if (this.shardTaskRuntime.isTaskPaused(this.configuration.getMainTable())) {
                    isPaused = true;
                    break;
                }
                SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                subProgress.setParentSp(this.mainProgress);
                subProgress.setMovingTable(progressEntity.getShardTable());
                IndexMoveWork indexMoveWork = new IndexMoveWork(progressEntity, this.taskEntity, this.configuration, subProgress);
                isPaused = indexMoveWork.doWork();
                if (isPaused) break;
                this.mainProgress.setExecSql(null);
                this.mainProgress.store(false);
            }
        }
        long unclosed = ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId());
        if (isPaused) {
            if (unclosed != 0L) {
                ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
                XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingIndexMoveService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_3", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
                return true;
            }
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        } else if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
            ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
            ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
        }
        if (unclosed > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_4", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
        }
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_5", (String)"Delete Intermediate Table", (Object[])new Object[0]));
        this.mainProgress.store(true);
        ShardingConfig sc = this.configuration.getMainShardingConfig();
        List<String> shardTables = Arrays.asList(tm.getShardingTable(TableName.of((String)sc.getTable()).getOriginalName()));
        if (shardTables.isEmpty()) {
            String mvTable = mainTN.getMovingTable(-1L);
            ActionUtil.dropTable(this.configuration.getRoute(), mvTable);
            tm.removeCahce(mvTable);
        } else {
            for (String string : shardTables) {
                TableName tableName = TableName.of((String)string);
                String mvTable = tableName.getMovingTable(tableName.getShardingIndex());
                ActionUtil.dropTable(this.configuration.getRoute(), mvTable);
                tm.removeCahce(mvTable);
            }
        }
        if (!this.mainProgress.isRenamePkTempTable()) {
            MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(this.taskEntity.getEntitynumber());
            Set set = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
            set.add(this.configuration.getRoute().getRouteKey());
            for (String routeStr : set) {
                DBRoute archiveRoute = DBRoute.of((String)routeStr);
                boolean existPKTempData = this.countPKData(mainTN.getPKTempTable(), archiveRoute);
                boolean existPKData = this.countPKData(mainTN.getPKTable(), archiveRoute);
                if (!existPKTempData && existPKData) {
                    ActionUtil.dropTable(archiveRoute, mainTN.getPKTempTable());
                    this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_6", (String)"Remove PK Temporary Table", (Object[])new Object[0]));
                    continue;
                }
                ActionUtil.dropTable(archiveRoute, mainTN.getPKTable());
                ActionUtil.renameTable(mainTN.getPKTempTable(), mainTN.getPKTable(), routeStr);
                List<Integer> partitionsWithInPGSeries = this.getPartitionsWithInPGSeries(XDBManagerUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()), this.configuration.getMainShardingConfig().getOptions().getDataRowsRange());
                for (Integer partition : partitionsWithInPGSeries) {
                    String partitionSuffix = "_p" + partition;
                    ActionUtil.renameTable(mainTN.getPKTempTable() + partitionSuffix, mainTN.getPKTable() + partitionSuffix, routeStr);
                }
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_7", (String)"Rename Temporary Table", (Object[])new Object[0]));
            }
            this.mainProgress.setRenamePkTempTable();
            this.mainProgress.store(true);
        }
        String fastIndex = this.configuration.getFastIndex();
        String string = this.configuration.getConfigEntity().getStrategyparams();
        String shardingParams = this.rebuildShardingStrategtParameter(string, fastIndex);
        ShardConfigRepository.get().setConfigParameter(this.configuration.getConfigEntity().getId(), shardingParams);
        this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingIndexMoveService_8", (String)"Index Data Migration Completed", (Object[])new Object[0]));
        this.mainProgress.store(true);
        return false;
    }

    private List<Integer> getPartitionsWithInPGSeries(PkTypeEnum typeEnum, DataRowsRange drr) {
        int p = drr.getPartitions();
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        ArrayList<Integer> partTableSuffixList = new ArrayList<Integer>();
        if (p > 0 && typeEnum == PkTypeEnum.pk_long) {
            switch (dbType) {
                case postgresql: 
                case gs: 
                case gs100: 
                case gaussdb: 
                case gauss200: 
                case gbase: 
                case kingbase: 
                case vastbase: {
                    for (int i = 0; i < p; ++i) {
                        partTableSuffixList.add(i);
                    }
                    break;
                }
            }
        }
        return partTableSuffixList;
    }

    private boolean countPKData(String pkTable, DBRoute route) {
        if (!DB.exitsTable((DBRoute)route, (String)pkTable)) {
            return false;
        }
        return (Boolean)DB.query((DBRoute)route, (String)("select top 1 fpk from " + pkTable), rs -> {
            if (rs.next()) {
                return true;
            }
            return false;
        });
    }

    private String rebuildShardingStrategtParameter(String strategyParams, String fastIndex) {
        Properties ps = new Properties();
        try {
            ps.load(new StringReader(strategyParams));
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
        String ret = (ps.getProperty("range") != null ? "range=" + ps.getProperty("range") + '\n' : "") + "indices=" + fastIndex + '\n';
        String customClass = ps.getProperty("cust_class");
        if (customClass != null) {
            int pos = strategyParams.indexOf(customClass) + customClass.length() + 1;
            ret = ret + "cust_class=" + customClass + '\n' + strategyParams.substring(pos);
        }
        ret = ret + (ps.getProperty("mod") != null ? "mod=" + ps.getProperty("mod") + '\n' : "") + (ps.getProperty("delim") != null ? "delim=" + ps.getProperty("delim") + '\n' : "");
        String pattern = ps.getProperty("pattern");
        if (pattern != null) {
            ret = ret + "pattern=" + ps.getProperty("pattern") + '\n';
            int pos = strategyParams.indexOf(pattern) + pattern.length() + 1;
            if (pos != strategyParams.length() && strategyParams.length() >= pos) {
                ret = ret + strategyParams.substring(pos);
            }
        }
        return ret;
    }

    private String getRouteOfTable(String tableName) {
        String originalName = TableName.of((String)tableName).getOriginalName();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(originalName);
        String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(tableName);
        return StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
    }
}

