/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.indexmove.reader;

import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.orm.ORM;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class AdaptiveIndexMoveReader
implements Reader {
    private Configuration configuration;
    private ShardProgressEntity progressEntity;
    private Object lastPk;
    private DBRoute shardDBRoute;
    private boolean isSameRouteMove;

    public AdaptiveIndexMoveReader(ShardProgressEntity progressEntity, Configuration configuration, Object lastPk) {
        this.progressEntity = progressEntity;
        this.configuration = configuration;
        this.lastPk = lastPk;
        this.shardDBRoute = kd.bos.util.StringUtils.isEmpty((String)progressEntity.getTargetRoute()) ? configuration.getRoute() : DBRoute.of((String)this.getRouteOfTable(progressEntity.getShardTable()));
        this.isSameRouteMove = progressEntity.getTargetRoute().equalsIgnoreCase(progressEntity.getOriginalRoute());
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        IDataEntityType mainDT = ORM.create().getDataEntityType(this.configuration.getMainShardingConfig().getName());
        String pkField = mainDT.getPrimaryKey().getAlias().toLowerCase();
        String shardTable = this.progressEntity.getShardTable();
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            StringBuilder sql = new StringBuilder(128);
            Object[] params = null;
            ArrayList<String> indexColumns = new ArrayList<String>();
            if (this.isSameRouteMove) {
                sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE).append(" ").append(pkField);
                sql.append(" from ").append(shardTable);
                if (fromPK != null) {
                    params = new Object[]{fromPK};
                    sql.append(" where ").append(pkField).append(" > ?");
                }
                sql.append(" order by ").append(pkField).append(" asc ");
            } else {
                Character alias;
                Set<IndexDefine> fastIndexDefineSet = this.configuration.getFastIndexDefineSet();
                IndexDefine[] defs = fastIndexDefineSet.toArray(new IndexDefine[fastIndexDefineSet.size()]);
                long shardingIndex = this.progressEntity.getShardIndex();
                HashMap<String, Character> joinTableAliasMap = new HashMap<String, Character>();
                for (IndexDefine def : defs) {
                    alias = (Character)joinTableAliasMap.get(def.getTable());
                    if (alias != null) continue;
                    alias = Character.valueOf((char)(66 + joinTableAliasMap.size()));
                    joinTableAliasMap.put(def.getTable(), alias);
                }
                joinTableAliasMap.remove(this.configuration.getMainShardingConfig().getTable());
                sql.append("select top ").append(XDBManagerConstant.CROSS_PAGE_SIZE).append(" A.").append(pkField);
                for (IndexDefine def : defs) {
                    alias = (Character)joinTableAliasMap.get(def.getTable());
                    sql.append(',').append(alias != null ? (char)alias.charValue() : (char)'A').append('.').append(def.getField());
                    indexColumns.add(def.getField());
                }
                sql.append(" from ").append(shardTable).append(" A");
                for (Map.Entry join : joinTableAliasMap.entrySet()) {
                    sql.append(" inner join ").append(TableName.of((String)((String)join.getKey())).getShardingTable(shardingIndex)).append(' ').append(join.getValue()).append(" on A.FID=").append(join.getValue()).append('.').append(pkField);
                }
                if (fromPK != null) {
                    params = new Object[]{fromPK};
                    sql.append(" where ").append(pkField).append(" > ?");
                }
                sql.append(" order by A.").append(pkField).append(" asc ");
            }
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"IndexMoveReader", (DBRoute)this.shardDBRoute, (String)s, (Object[])params);){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(indexColumns.size() + 1);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    if (!this.isSameRouteMove) {
                        rowRecord.setColumn(0, pkValue);
                        for (int i = 1; i <= indexColumns.size(); ++i) {
                            rowRecord.setColumn(i, row.get(i));
                        }
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= (this.isSameRouteMove ? XDBManagerConstant.PAGE_SIZE : XDBManagerConstant.CROSS_PAGE_SIZE));
        return false;
    }

    private String getRouteOfTable(String tableName) {
        String originalName = TableName.of((String)tableName).getOriginalName();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(originalName);
        String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(tableName);
        return StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
    }
}

