/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.indexmove.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.IWork;
import kd.bos.xdb.task.service.indexmove.reader.AdaptiveIndexMoveReader;
import kd.bos.xdb.task.service.indexmove.reader.IndexMoveReader;
import kd.bos.xdb.task.service.indexmove.writer.AdaptiveIndexMoveWriter;
import kd.bos.xdb.task.service.indexmove.writer.IndexMoveWriter;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.taskgroup.TaskGroupExecutor;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public class IndexMoveWork
implements IWork {
    protected ShardProgressEntity progressEntity;
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected SubProgress subProgress;
    protected Object prePk = null;

    public IndexMoveWork(ShardProgressEntity progressEntity, ShardTaskEntity taskEntity, Configuration configuration, SubProgress subProgress) {
        this.progressEntity = progressEntity;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.subProgress = subProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        TableName mainTN;
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork begin,entitynumber:{0}, tableName:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork interrupted,entitynumber:{0}, tableName:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
            return false;
        }
        TableManager tm = XDBConfig.getTableManager();
        if (!tm.existTable((mainTN = TableName.of((String)this.configuration.getMainTable())).getPKTempTable())) {
            tm.createPKTempTable(ExtContext.get().getDBRoute(), mainTN.getPKTempTable(), XDBManagerUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()), this.configuration.getMainShardingConfig().getOptions().getDataRowsRange(), this.configuration.getFastIndexDefineSet().toArray(new IndexDefine[this.configuration.getFastIndexDefineSet().size()]));
        }
        try (TXHandle tx = TX.notSupported((String)"IndexMoveWork.doWork");
             DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            WriterAbst pkWriter;
            Reader pkReader;
            int c = ShardProgressRepository.get().updateExecuting(this.progressEntity.getId());
            if (c <= 0) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork updateExecuting error,entitynumber:{0}, shardTable:{1},taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = false;
                return bl;
            }
            boolean isContinue = false;
            if (this.subProgress.getToPk() != null) {
                this.prePk = this.subProgress.getToPk();
                isContinue = true;
            }
            if (isContinue) {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWork_0", (String)"Continue index migration, shardTable: {0}, header pks: {1}, lastPk: {2}", (Object[])new Object[]{this.progressEntity.getShardTable(), this.progressEntity.getShardTotalRecord(), this.prePk}));
            } else {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWork_1", (String)"Start index migration, shardTable: {0}, header pks: {1}", (Object[])new Object[]{this.progressEntity.getShardTable(), this.progressEntity.getShardTotalRecord()}));
            }
            this.subProgress.store();
            boolean isCross = false;
            MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(this.taskEntity.getEntitynumber());
            Set archiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
            boolean oldMethodForce = ShardTaskConfig.isShardDisableOldMethodForce();
            if (archiveRoutes.isEmpty() && oldMethodForce) {
                pkReader = new IndexMoveReader(this.progressEntity, this.configuration, this.prePk);
                pkWriter = new IndexMoveWriter(this.progressEntity, this.configuration, this.subProgress);
            } else {
                pkReader = new AdaptiveIndexMoveReader(this.progressEntity, this.configuration, this.prePk);
                pkWriter = new AdaptiveIndexMoveWriter(this.progressEntity, this.configuration, this.subProgress);
                if (!this.progressEntity.getTargetRoute().equalsIgnoreCase(this.progressEntity.getOriginalRoute())) {
                    pkWriter.setBufferSize(XDBManagerConstant.CROSS_INSERT_PAGE_SIZE);
                    isCross = true;
                }
            }
            Communication runnerCommunication = new Communication();
            TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "INDEXMOVE#" + isCross + "#" + this.progressEntity.getShardTable(), isCross);
            pkGroupExecutor.doStart();
            if (runnerCommunication.getState() == State.FAILED) {
                StringWriter sw = new StringWriter();
                runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ShardTaskMovingHandler IndexMoveWork stateReturnFailed,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), sw.toString());
                XDBManagerUtil.logError(error, runnerCommunication.getThrowable());
                ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), error, "INDEXMOVE#" + this.progressEntity.getShardTable());
                throw ExceptionUtil.asRuntimeException((String)sw.toString(), (Throwable)runnerCommunication.getThrowable());
            }
            if (runnerCommunication.getState() == State.PAUSED) {
                ShardProgressRepository.get().setProgressSuspended(this.progressEntity.getId());
                ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWork_2", (String)"task paused, shardTable: {0}", (Object[])new Object[]{this.progressEntity.getShardTable()}), "INDEXMOVE#" + this.progressEntity.getShardTable());
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork paused,entitynumber:{0}, shardTable:{1}, taskId:{1}, splitTaskId:{2}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = true;
                return bl;
            }
            if (Thread.currentThread().isInterrupted()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork interrupted,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = false;
                return bl;
            }
            this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWork_3", (String)"Index migration completed, shardTable: {0}", (Object[])new Object[]{this.progressEntity.getShardTable()}));
            this.subProgress.setExecSql(null);
            this.subProgress.store();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            XDBManagerUtil.logError(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork error, entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), runtimeException), e);
            ShardProgressRepository.get().setProgressFailedByTaskId(this.progressEntity.getId());
            throw ExceptionUtil.asRuntimeException((String)runtimeException, (Throwable)e);
        }
        ShardProgressRepository.get().updateProgressSuccess(this.progressEntity.getId());
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler IndexMoveWork end,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        return false;
    }
}

