/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.taskgroup.Writer;
import kd.bos.xdb.transport.exchanger.RecordReceiver;
import kd.bos.xdb.transport.record.PausedRecord;
import kd.bos.xdb.transport.record.Record;
import kd.bos.xdb.transport.record.RowRecord;

public abstract class WriterAbst
implements Writer {
    protected Configuration configuration;
    protected IChildProgress progress;
    protected int bufferSize;
    protected DBType dbType;

    public WriterAbst(Configuration configuration, IChildProgress progress) {
        this.configuration = configuration;
        this.progress = progress;
        this.bufferSize = XDBManagerConstant.INSERT_PAGE_SIZE;
        this.dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean startWrite(RecordReceiver recordReceiver) throws Exception {
        Throwable throwable;
        DtsExcludeSyncContext context;
        Record record;
        ArrayList<RowRecord> writerBuffer = new ArrayList<RowRecord>(this.bufferSize);
        boolean isPaused = false;
        while ((record = recordReceiver.getFromReader()) != null && !ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
            if (record instanceof PausedRecord) {
                isPaused = true;
                continue;
            }
            writerBuffer.add((RowRecord)record);
            if (writerBuffer.size() < this.bufferSize) continue;
            context = DtsExcludeSyncContext.create();
            throwable = null;
            try {
                this.doBatchInsert(writerBuffer);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context != null) {
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            writerBuffer.clear();
        }
        if (!writerBuffer.isEmpty()) {
            context = DtsExcludeSyncContext.create();
            throwable = null;
            try {
                this.doBatchInsert(writerBuffer);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (context != null) {
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            writerBuffer.clear();
        }
        return isPaused;
    }

    protected abstract void doBatchInsert(List<RowRecord> var1) throws Exception;

    protected boolean existsPK(DBRoute route, String tableName, String pkField, Object pkValue) {
        String sql = "select 1 from " + tableName + " where " + pkField + "=?";
        sql = ActionUtil.wrapSQL(sql, true, true);
        return (Boolean)DB.query((DBRoute)route, (String)sql, (Object[])new Object[]{pkValue}, rs -> rs.next());
    }

    protected void deleteDuplicate(DBRoute route, String tableName, String pkField, List<Object> pks) {
        List<List> splitList = this.splitList(pks);
        for (List range : splitList) {
            SqlBuilder delSqlBuilder = new SqlBuilder();
            delSqlBuilder.append("/*dialect*/", new Object[0]);
            delSqlBuilder.append("/*XDB:NO_SHARDING*/", new Object[0]);
            delSqlBuilder.append("delete from ", new Object[0]).append(tableName, new Object[0]);
            delSqlBuilder.append(" where ", new Object[0]).appendIn(pkField, range);
            ActionUtil.wrapSqlBuilderExecute(route, delSqlBuilder);
        }
    }

    protected List<List> splitList(List<Object> pks) {
        ArrayList<List> ranges = new ArrayList<List>(10);
        int pageSize = XDBManagerConstant.DELETE_PAGE_SIZE;
        if (pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }
}

