/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup.runner;

import java.text.MessageFormat;
import java.util.ArrayList;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.MainProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.service.analysis.ShardingAnalysisService;
import kd.bos.xdb.task.service.analysis.entity.SplitInfo;
import kd.bos.xdb.taskgroup.runner.AbstractRunner;

public class AnalysisReaderRunner
extends AbstractRunner
implements Runnable {
    private ShardTaskEntity taskEntity;
    private Configuration configuration;
    private MainProgress mainProgress;
    private ShardingAnalysisService analysisProService;
    private Object minPk;

    public AnalysisReaderRunner(ShardingAnalysisService analysisProService, ShardTaskEntity taskEntity, Configuration configuration, Object minPk, MainProgress mainProgress) {
        this.analysisProService = analysisProService;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.mainProgress = mainProgress;
        this.minPk = minPk;
    }

    @Override
    protected void shutDown() {
    }

    @Override
    public void run() {
        Thread.currentThread().setName("XDB-AnalysisReaderRunner-" + this.taskEntity.getEntitynumber());
        try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"xdb.AnalysisReaderRunner");
             Cache cc = CacheContext.get().createExecutorCache();
             DBAnyRWContext dbAnyRWContextctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();
             ShardingContext ctx = ShardingContext.create();){
            ctx.setStatementType(StatementType.insert);
            boolean isPaused = (Boolean)DB.__call((boolean)true, () -> (Boolean)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.configuration.getRoute(), (boolean)false, () -> this.doWork()));
            if (isPaused) {
                super.markPaused();
            } else {
                super.markSuccsess();
            }
        }
        catch (Throwable e) {
            super.markFailed(e);
        }
    }

    public boolean doWork() throws Exception {
        long id;
        SplitInfo splitInfo;
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler AnalysisReaderRunner begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias().toLowerCase();
        boolean isContinue = false;
        Object lastPk = this.minPk;
        long lastNum = 0L;
        if (this.mainProgress.getToPk() != null) {
            lastPk = this.mainProgress.getToPk();
            lastNum = this.mainProgress.getMovingShardingIndex();
            isContinue = true;
        }
        if (isContinue) {
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"AnalysisWork_0", (String)"Continue to segment segmentation, interrupt position pk:{0},num:{1}", (Object[])new Object[]{lastPk, lastNum}));
        } else {
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"AnalysisWork_1", (String)"Start segment segmentation, the first execution...", (Object[])new Object[0]));
        }
        this.mainProgress.store();
        Object headPk = lastPk;
        Object tailPk = null;
        int num = Integer.parseInt(String.valueOf(lastNum)) + 1;
        while (true) {
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            tailPk = this.getSegPk(headPk, pkField);
            if (tailPk == null) break;
            splitInfo = new SplitInfo();
            splitInfo.setRemark(Integer.toString(num));
            splitInfo.setHeadPk(headPk);
            splitInfo.setTailPk(tailPk);
            splitInfo.setTotalCount(XDBManagerConstant.ID_SEG_SIZE);
            splitInfo.setNum(num);
            this.mainProgress.setToPk(tailPk);
            this.mainProgress.setMovingShardingIndex(num);
            id = ProgressUtil.insertSplitTask(this.taskEntity, splitInfo, this.mainProgress);
            this.analysisProService.getSplitTaskQueue().put(ShardSplitTaskRepository.get().loadSplitTask(id));
            headPk = tailPk;
            ++num;
        }
        splitInfo = new SplitInfo();
        splitInfo.setRemark(Integer.toString(num));
        splitInfo.setHeadPk(headPk);
        splitInfo.setTailPk(" ");
        splitInfo.setTotalCount(this.countSize(headPk, pkField));
        splitInfo.setNum(num);
        this.mainProgress.setCurStepExecuted(true);
        id = ProgressUtil.insertSplitTask(this.taskEntity, splitInfo, this.mainProgress);
        this.analysisProService.getSplitTaskQueue().put(ShardSplitTaskRepository.get().loadSplitTask(id));
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler AnalysisReaderRunner end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }

    private Object getSegPk(Object lastPk, String pkField) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(1);
        sql.append("select top 1,").append(XDBManagerConstant.ID_SEG_SIZE).append(" ");
        sql.append(pkField).append(" from ").append(this.configuration.getMainTable());
        if (lastPk != null) {
            sql.append(" where ").append(pkField).append(" >= ? ");
            params.add(lastPk);
        }
        sql.append(" order by ").append(pkField).append(" asc ");
        return DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])params.toArray(), rs -> {
            if (rs.next()) {
                return rs.getObject(1);
            }
            return null;
        });
    }

    private long countSize(Object lastPk, String pkField) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(1);
        sql.append("select count(").append(pkField).append(") ");
        sql.append(" from ").append(this.configuration.getMainTable());
        if (lastPk != null) {
            sql.append(" where ").append(pkField).append(" >= ? ");
            params.add(lastPk);
        }
        return (Long)DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), (Object[])params.toArray(), rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }
}

