/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup.runner;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.taskgroup.Writer;
import kd.bos.xdb.taskgroup.runner.AbstractRunner;
import kd.bos.xdb.transport.exchanger.RecordReceiver;

public class WriterRunner
extends AbstractRunner
implements Runnable {
    private DBRoute route;
    private Writer taskWriter;
    private RecordReceiver recordReceiver;

    public WriterRunner(Writer writer, DBRoute route) {
        this.taskWriter = writer;
        this.route = route;
    }

    public void setRecordReceiver(RecordReceiver recordReceiver) {
        this.recordReceiver = recordReceiver;
    }

    @Override
    public void run() {
        try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"xdb.ReaderRunner");
             Cache cc = CacheContext.get().createExecutorCache();
             DBAnyRWContext dbAnyRWContextctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();
             ShardingContext ctx = ShardingContext.create();){
            ctx.setStatementType(StatementType.insert);
            boolean isPaused = (Boolean)DB.__call((boolean)true, () -> (Boolean)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.route, (boolean)false, () -> this.taskWriter.startWrite(this.recordReceiver)));
            if (isPaused) {
                super.markPaused();
            } else {
                super.markSuccsess();
            }
        }
        catch (Throwable e) {
            super.markFailed(e);
        }
    }

    @Override
    protected void shutDown() {
        this.recordReceiver.shutDown();
    }
}

