/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.transport.channel.memory;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.transport.channel.Channel;
import kd.bos.xdb.transport.record.Record;

public class MemoryChannel
extends Channel {
    private int bufferSize = 0;
    private ArrayBlockingQueue<Record> queue = null;
    private ReentrantLock lock;
    private Condition notInsufficient;
    private Condition notEmpty;

    public MemoryChannel(boolean isCross) {
        super(isCross ? XDBManagerConstant.CROSS_CHANNEL_CAPACITY : XDBManagerConstant.CHANNEL_CAPACITY);
        this.bufferSize = isCross ? XDBManagerConstant.CROSS_BUFFER_SIZE : XDBManagerConstant.BUFFER_SIZE;
        this.queue = new ArrayBlockingQueue(this.getCapacity());
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notInsufficient = this.lock.newCondition();
    }

    @Override
    protected void doPush(Record r) {
        try {
            this.queue.put(r);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void doPushALL(Collection<Record> rs) {
        try {
            this.lock.lockInterruptibly();
            while (rs.size() > this.queue.remainingCapacity()) {
                this.notInsufficient.await(200L, TimeUnit.MILLISECONDS);
            }
            this.queue.addAll(rs);
            this.notEmpty.signalAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected Record doPull() {
        try {
            Record r = this.queue.take();
            return r;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void doPullAll(Collection<Record> rs) {
        rs.clear();
        try {
            this.lock.lockInterruptibly();
            while (this.queue.drainTo(rs, this.bufferSize) <= 0) {
                this.notEmpty.await(200L, TimeUnit.MILLISECONDS);
            }
            this.notInsufficient.signalAll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

