/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.transport.exchanger;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.transport.channel.Channel;
import kd.bos.xdb.transport.exchanger.RecordReceiver;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.PausedRecord;
import kd.bos.xdb.transport.record.Record;
import kd.bos.xdb.transport.record.TerminateRecord;

public class BufferdRecordExchanger
implements RecordSender,
RecordReceiver {
    private int bufferSize;
    private int bufferIndex = 0;
    private final List<Record> buffer;
    private final Channel channel;
    private volatile boolean shutDown = false;

    public BufferdRecordExchanger(Channel channel, boolean isCross) {
        this.channel = channel;
        this.bufferSize = isCross ? XDBManagerConstant.CROSS_BUFFER_SIZE : XDBManagerConstant.BUFFER_SIZE;
        this.buffer = new ArrayList<Record>(this.bufferSize);
    }

    @Override
    public Record getFromReader() {
        boolean isEmpty;
        if (this.shutDown) {
            // empty if block
        }
        boolean bl = isEmpty = this.bufferIndex >= this.buffer.size();
        if (isEmpty) {
            this.receive();
        }
        Record r = this.buffer.get(this.bufferIndex);
        ++this.bufferIndex;
        if (r instanceof TerminateRecord) {
            return null;
        }
        return r;
    }

    @Override
    public void sendToWriter(Record r) {
        boolean isFull;
        if (this.shutDown) {
            // empty if block
        }
        boolean bl = isFull = this.bufferIndex >= this.bufferSize;
        if (isFull) {
            this.flush();
        }
        this.buffer.add(r);
        ++this.bufferIndex;
    }

    @Override
    public void terminate() {
        if (this.shutDown) {
            // empty if block
        }
        this.flush();
        this.channel.pushTerminate(TerminateRecord.get());
    }

    @Override
    public void pause() {
        if (this.shutDown) {
            // empty if block
        }
        this.flush();
        this.channel.pushPaused(PausedRecord.get());
        this.channel.pushTerminate(TerminateRecord.get());
    }

    @Override
    public void flush() {
        this.channel.pushAll(this.buffer);
        this.bufferIndex = 0;
        this.buffer.clear();
    }

    @Override
    public void receive() {
        this.channel.pullAll(this.buffer);
        this.bufferIndex = 0;
        this.bufferSize = this.buffer.size();
    }

    @Override
    public void shutDown() {
        this.shutDown = true;
        this.buffer.clear();
        this.channel.clear();
    }
}

