/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kafka;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.kafka.IKafkaSender;
import kd.bos.kafka.enums.SerializerType;
import kd.bos.kafka.sender.ByteArrayKafkaSender;
import kd.bos.kafka.sender.ByteBufferKafkaSender;
import kd.bos.kafka.sender.StringKafkaSender;

public class KafkaFactory {
    private static Map<String, IKafkaSender> senderMap = new ConcurrentHashMap<String, IKafkaSender>(8);

    public static IKafkaSender getSender(SerializerType type, String host, String topic) {
        return KafkaFactory.getSender(type, host, topic, null, null);
    }

    public static IKafkaSender getSender(SerializerType type, String host, String topic, String userName, String pwd) {
        return senderMap.computeIfAbsent(type.value() + host + topic, key -> {
            if (SerializerType.STRING == type) {
                return new StringKafkaSender(host, topic, userName, pwd);
            }
            if (SerializerType.BYTE_ARRAY == type) {
                return new ByteArrayKafkaSender(host, topic, userName, pwd);
            }
            if (SerializerType.BYTE_BUFFER == type) {
                return new ByteBufferKafkaSender(host, topic, userName, pwd);
            }
            return new StringKafkaSender(host, topic, userName, pwd);
        });
    }
}

