/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kafka;

import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.kafka.common.config.ConfigException;

public class KafkamqFactory {
    private static final Log LOGGER = LogFactory.getLog(KafkamqFactory.class);
    private static ConcurrentHashMap<String, KafkaInfo> kafkaInfoMap = new ConcurrentHashMap();

    public static KafkaInfo getKafkaInfo(String serverKey) {
        KafkaInfo kafkaInfo = kafkaInfoMap.get(serverKey);
        if (kafkaInfo != null) {
            return kafkaInfo;
        }
        Class<KafkamqFactory> clazz = KafkamqFactory.class;
        synchronized (KafkamqFactory.class) {
            if (kafkaInfoMap.containsKey(serverKey)) {
                kafkaInfo = kafkaInfoMap.get(serverKey);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return kafkaInfo;
            }
            try {
                kafkaInfo = KafkamqFactory.creatKafkaInfo(serverKey);
                kafkaInfoMap.put(serverKey, kafkaInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return kafkaInfo;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.kafkaConfiguration, new Object[]{e.getMessage()});
            }
        }
    }

    private static KafkaInfo creatKafkaInfo(String serverKey) {
        String serverInfo = System.getProperty(serverKey);
        if (serverInfo == null) {
            LOGGER.error("kafka server not config for " + serverKey);
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"kafka server not config for " + serverKey});
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            KafkaInfo kafkaInfo = new KafkaInfo();
            String str = Objects.requireNonNull(prop.getProperty("host"), "kafka host can't be empty.");
            kafkaInfo.setHost(str);
            str = prop.getProperty("user");
            kafkaInfo.setUsername(str);
            str = prop.getProperty("password");
            str = Encrypters.decode((String)str);
            kafkaInfo.setPassword(str);
            str = Objects.requireNonNull(prop.getProperty("vhost"), "kafka vhost can't be empty.");
            kafkaInfo.setVhost(str);
            String securityProtocol = prop.getProperty("security.protocol");
            if (StringUtils.isNotEmpty((String)securityProtocol)) {
                kafkaInfo.setSecurityProtocol(securityProtocol);
                if (securityProtocol.equals("SASL_PLAINTEXT")) {
                    String saslMechanism = Objects.requireNonNull(prop.getProperty("sasl.mechanism"), "kafka sasl.mechanism can't be empty.");
                    kafkaInfo.setSaslMechanism(saslMechanism);
                    String kafkaAuthConfig = KafkamqFactory.getKafkaAuthConfig(kafkaInfo.getUsername(), kafkaInfo.getPassword());
                    kafkaInfo.setSaslJaasConfig(kafkaAuthConfig);
                } else if (securityProtocol.equals("SASL_SSL")) {
                    String saslMechanism = Objects.requireNonNull(prop.getProperty("sasl.mechanism"), "kafka sasl.mechanism can't be empty.");
                    kafkaInfo.setSaslMechanism(saslMechanism);
                    String kafkaAuthConfig = KafkamqFactory.getKafkaAuthConfig(kafkaInfo.getUsername(), kafkaInfo.getPassword());
                    kafkaInfo.setSaslJaasConfig(kafkaAuthConfig);
                    String sslTruststoreLocation = Objects.requireNonNull(prop.getProperty("ssl.truststore.location"), "kafka ssl.truststore.location can't be empty.");
                    kafkaInfo.setSslTruststoreLocation(sslTruststoreLocation);
                    String sslTruststorePassword = Objects.requireNonNull(prop.getProperty("ssl.truststore.password"), "kafka ssl.truststore.password can't be empty.");
                    sslTruststorePassword = Encrypters.decode((String)sslTruststorePassword);
                    kafkaInfo.setSslTruststorePassword(sslTruststorePassword);
                    kafkaInfo.setSslEndpointIdentificationAlgorithm(prop.getProperty("ssl.endpoint.identification.algorithm"));
                    kafkaInfo.setSslKeystoreType(prop.getProperty("ssl.keystore.type"));
                    kafkaInfo.setSslKeystoreLocation(prop.getProperty("ssl.keystore.location"));
                    kafkaInfo.setSslKeystorePassword(Encrypters.decode((String)prop.getProperty("ssl.keystore.password")));
                } else if (securityProtocol.equals("SSL")) {
                    String sslTruststoreLocation = Objects.requireNonNull(prop.getProperty("ssl.truststore.location"), "kafka ssl.truststore.location can't be empty.");
                    kafkaInfo.setSslTruststoreLocation(sslTruststoreLocation);
                }
            }
            return kafkaInfo;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaConfiguration, new Object[]{e.getMessage()});
        }
    }

    private static String getKafkaAuthConfig(String userName, String pw) {
        if (StringUtils.isEmpty((String)userName)) {
            throw new ConfigException("Config item 'userName' of kafka appender can't be empty when securityProtocol is not null.");
        }
        if (StringUtils.isEmpty((String)pw)) {
            throw new ConfigException("Config item 'password' of kafka appender can't be empty when securityProtocol is not null.");
        }
        return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + pw + "\";";
    }
}

