/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kafka.demo;

import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class SimpleConsumer {
    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("bootstrap.servers", "172.17.7.37:9092");
        props.put("group.id", "kafka-test-group");
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        KafkaConsumer consumer = new KafkaConsumer(props);
        consumer.subscribe(Collections.singletonList("trace_sword_topic"));
        try {
            block2: while (true) {
                ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
                Iterator iterator = records.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    ConsumerRecord record = (ConsumerRecord)iterator.next();
                    System.out.printf("offset = %d ,key =%s, value= %s, partition= %s%n", record.offset(), record.key(), record.value(), record.partition());
                }
                break;
            }
        }
        catch (Throwable throwable) {
            consumer.close();
            throw throwable;
        }
    }
}

