/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.archive.ArchiveConfigUtil;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.repository.ArchiveCascadeConfigRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.service.parallel.ArchiveThreadPool;
import kd.bos.archive.task.config.ArchiveFieldType;
import kd.bos.archive.task.config.ArchiveIndexDefine;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.temptable.pk.PKTempTableHint;
import kd.bos.xdb.util.Threads;

public final class ArchiveUtil
implements ArchiveConstant,
ArchiveLogable {
    private static Class<?> filterBuilder;
    private static Class<?> filterCondition;
    private static Class<?> mainEntityType;
    private static Class<?> basedataProp;
    private static Class<?> flexProp;
    private static Method getDataEntityType;
    private static Method getDisplayName;
    private static Method buildFilter;
    private static Method getQFilter;
    private static Method getComplexType;

    public static String wrapSQL(String sql, boolean dialect, boolean noSharding) {
        if (noSharding) {
            sql = NoShardingHint.genNoShardingSQL((String)sql);
        }
        if (dialect) {
            sql = "/*dialect*/" + sql;
        }
        return sql;
    }

    public static String joinArray(String[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String unWrapSQLTableName(String name) {
        char ch = name.charAt(0);
        if (ch == '\'' || ch == '\"' || ch == '`') {
            if (name.charAt(name.length() - 1) == ch) {
                return name.substring(1, name.length() - 1);
            }
            throw new IllegalArgumentException(BosRes.get((String)"bos-archive", (String)"ArchiveName_0", (String)"Irregular name:{0}", (Object[])new Object[]{name}));
        }
        return name;
    }

    public static String getCondition(ArchiveConfigEntity configEntity) {
        String filterType = configEntity.getFilterType().getKey();
        String condition = configEntity.getCondition();
        JSONObject jsonObject = JSONObject.parseObject((String)condition);
        return jsonObject.getString(filterType);
    }

    public static QFilter parse2QFilter(ArchiveConfigEntity configEntity) {
        return ArchiveUtil.parse2QFilter(configEntity.getEntitynumber(), ArchiveUtil.getCondition(configEntity));
    }

    public static QFilter parse2QFilter(String entityNumber, String filter) {
        try {
            Constructor<?> constructor = filterBuilder.getConstructor(mainEntityType, filterCondition);
            Object filterBuilderObj = constructor.newInstance(getDataEntityType.invoke(null, entityNumber), SerializationUtils.fromJsonString((String)filter, filterCondition));
            buildFilter.invoke(filterBuilderObj, new Object[0]);
            return (QFilter)getQFilter.invoke(filterBuilderObj, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    public static boolean isCascadeRootBill(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = ORM.create().queryOne("bos_cbs_archi_cascade", new QFilter[]{numberFilter});
        return Objects.nonNull(dynamicObject) && Objects.isNull(dynamicObject.getDynamicObject("parent"));
    }

    public static boolean isCascadeChildBill(String number) {
        ArchiveCascadeConfigEntity archiveCascadeConfigEntity = ArchiveCascadeConfigRepository.get().loadCascadeConfig(number);
        return Objects.nonNull(archiveCascadeConfigEntity) && !StringUtils.isEmpty((String)archiveCascadeConfigEntity.getParentnumber());
    }

    public static void collectDataEntityType(String entityNumber, List<IDataEntityType> dataEntityTypes) {
        QFilter numberFilter = new QFilter("longnumber", "like", (Object)(entityNumber + "%"));
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query("bos_cbs_archi_cascade", new QFilter[]{numberFilter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            IDataEntityType dt = orm.getDataEntityType((String)dynamicObject.get("number"));
            dataEntityTypes.add(dt);
        }
    }

    public static void collectBaseDataName(IDataEntityType dt, Set<String> baseSet, DBRoute entityDB) {
        DataEntityPropertyCollection properties = dt.getProperties();
        for (IDataEntityProperty dp : properties) {
            if (basedataProp.isAssignableFrom(dp.getClass()) && !flexProp.isAssignableFrom(dp.getClass())) {
                try {
                    IDataEntityType entityType = (IDataEntityType)getComplexType.invoke((Object)dp, new Object[0]);
                    DBRoute baseDataDB = DBRoute.of((String)entityType.getDBRouteKey());
                    if (!baseDataDB.equals(entityDB) || baseDataDB.equals(DBRoute.base)) continue;
                    String baseName = entityType.getName();
                    baseSet.add(baseName);
                    continue;
                }
                catch (Exception e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
            if (!(dp instanceof ICollectionProperty) || dp instanceof DynamicLocaleProperty) continue;
            IDataEntityType itemType = ((ICollectionProperty)dp).getItemType();
            ArchiveUtil.collectBaseDataName(itemType, baseSet, entityDB);
        }
    }

    public static String getDisplayName(String entityNumber) {
        try {
            Object obj = getDataEntityType.invoke(null, entityNumber);
            String bdname = getDisplayName.invoke(obj, new Object[0]).toString();
            return bdname;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Deprecated
    public static String getPkField(ArchiveConfig key) {
        String pkField = ArchiveConfigUtil.isTcTableDBConfig(key) ? "FID" : (ArchiveConfigUtil.isWbTableDBConfig(key) ? "FEntryId" : ORM.create().getDataEntityType(key.getName()).getPrimaryKey().getAlias());
        return pkField;
    }

    public static void logInfo(String lot) {
        if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
            log.info(lot);
        }
    }

    public static void logError(String error, Throwable e) {
        log.error(error, e);
    }

    public static void wrapSqlBuilderExecute(DBRoute dbRoute, SqlBuilder sqlBuilder) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        if (dbType == DBType.MySQL) {
            try (PKTempTableHint hint = PKTempTableHint.skip();){
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
            }
        } else {
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        }
    }

    public static PkTypeEnum getPkTypeEnum(String entitynumber) {
        ISimpleProperty property = ORM.create().getDataEntityType(entitynumber).getPrimaryKey();
        PkTypeEnum type = null;
        type = property.getPropertyType() == String.class ? PkTypeEnum.pk_string : PkTypeEnum.pk_long;
        return type;
    }

    public static void newThreadAndCall(boolean isNew, Callable call) {
        block21: {
            if (isNew) {
                try (ArchiveThreadPool archiveThreadPool = new ArchiveThreadPool(1, 1);){
                    archiveThreadPool.start();
                    Future future = archiveThreadPool.submit(Threads.wrapCallable((Callable)call));
                    try {
                        future.get();
                        break block21;
                    }
                    catch (Throwable e) {
                        archiveThreadPool.shutdown();
                        while (!archiveThreadPool.isTerminated()) {
                            Thread.sleep(200L);
                        }
                        throw ExceptionUtil.wrap(e);
                    }
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
            try {
                call.call();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    // empty if block
                }
                throw ExceptionUtil.wrap(e);
            }
        }
    }

    public static ArchiveIndexDefine[] buildIndexDefines(IDataEntityType dt, String indices) {
        if (StringUtils.isNotEmpty((String)indices)) {
            String[] indexArray = indices.split(",");
            ArrayList<ArchiveIndexDefine> ret = new ArrayList<ArchiveIndexDefine>(indexArray.length);
            for (String property : indexArray) {
                ArchiveIndexDefine def = ArchiveUtil.createIndexDefile(property, dt);
                if (def == null) continue;
                ret.add(def);
            }
            return ret.toArray(new ArchiveIndexDefine[ret.size()]);
        }
        return null;
    }

    public static ArchiveIndexDefine createIndexDefile(String property, IDataEntityType dt) {
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)property);
        if (dp == null) {
            return null;
        }
        Class propertyType = dp instanceof IComplexProperty ? ((IComplexProperty)dp).getComplexType().getPrimaryKey().getPropertyType() : dp.getPropertyType();
        ArchiveFieldType archiveFieldType = ArchiveUtil.findFieldType(propertyType);
        String table = dt.getAlias();
        String group = dp.getTableGroup();
        if (group != null && group.length() > 0) {
            table = table + '_' + group;
        }
        return new ArchiveIndexDefine(table, dp.getAlias(), archiveFieldType);
    }

    public static ArchiveFieldType findFieldType(Class<?> propertyType) {
        if (propertyType == Integer.class) {
            return ArchiveFieldType.INTEGER;
        }
        if (propertyType == String.class) {
            return ArchiveFieldType.STRING;
        }
        if (propertyType == Date.class) {
            return ArchiveFieldType.DATE;
        }
        return ArchiveFieldType.LONG;
    }

    static {
        try {
            filterBuilder = Class.forName("kd.bos.entity.filter.FilterBuilder");
            buildFilter = filterBuilder.getMethod("buildFilter", new Class[0]);
            getQFilter = filterBuilder.getMethod("getQFilter", new Class[0]);
            filterCondition = Class.forName("kd.bos.entity.filter.FilterCondition");
            mainEntityType = Class.forName("kd.bos.entity.MainEntityType");
            getDataEntityType = Class.forName("kd.bos.entity.EntityMetadataCache").getMethod("getDataEntityType", String.class);
            getDisplayName = Class.forName("kd.bos.entity.MainEntityType").getMethod("getDisplayName", new Class[0]);
            basedataProp = Class.forName("kd.bos.entity.property.BasedataProp");
            getComplexType = basedataProp.getMethod("getComplexType", new Class[0]);
            flexProp = Class.forName("kd.bos.entity.property.FlexProp");
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

