/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveManager;
import kd.bos.archive.api.ArchiveApiConstant;
import kd.bos.archive.api.dto.ArchivePlan;
import kd.bos.archive.api.dto.ArchiveRule;
import kd.bos.archive.api.dto.ArchiveSchedule;
import kd.bos.archive.api.service.ArchiveScheduleApi;
import kd.bos.archive.api.util.EntityCoreInvokeUtils;
import kd.bos.archive.api.util.ScheduleApiInvokeUtils;
import kd.bos.archive.config.AccountEnable;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveConfigMovingTypeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveSubTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class ArchiveScheduleApiImpl
implements ArchiveScheduleApi,
ArchiveApiConstant {
    private static final ORM orm = ORM.create();
    public static final Object dataEntityType;
    private static final ArchiveScheduleApiImpl INSTANCE;

    @Override
    public ArchiveSchedule add(String name, ArchivePlan archivePlan, List<ArchiveRule> archiveRuleEntities) {
        return this.add(new LocaleString(name), archivePlan, archiveRuleEntities);
    }

    @Override
    public ArchiveSchedule add(LocaleString name, ArchivePlan archivePlan, List<ArchiveRule> archiveRuleEntities) {
        long scheduleId = ID.genLongId();
        String jobNumber = "ARCHIVE_SCHAPI_" + DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS").format(LocalDateTime.now());
        String jobId = ScheduleApiInvokeUtils.createJob(scheduleId, jobNumber);
        String planId = ScheduleApiInvokeUtils.createPlan(archivePlan, jobId, jobNumber);
        DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_sch_schedule_entry (fid, fentryid, fseq, fjobnumber) values (?, ?, ?, ?)", (Object[])new Object[]{planId, ID.genLongId(), 0, jobId});
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject schemaEntity = orm.newDynamicObject("bos_cbs_archi_schema");
        schemaEntity.set("number", (Object)jobNumber);
        schemaEntity.set("name", (Object)name);
        schemaEntity.set("executor", (Object)userId);
        String execPlan = this.getExecPlan(planId);
        schemaEntity.set("execplan", (Object)execPlan);
        schemaEntity.set("scheduleplanid", (Object)planId);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(archivePlan.getEndTime());
        schemaEntity.set("endtime", (Object)endCalendar);
        schemaEntity.set("movingtype", (Object)"0");
        schemaEntity.set("creator", (Object)userId);
        schemaEntity.set("modifier", (Object)userId);
        schemaEntity.set("createtime", (Object)new Date());
        schemaEntity.set("masterid", (Object)scheduleId);
        schemaEntity.set("id", (Object)scheduleId);
        schemaEntity.set("status", (Object)"C");
        schemaEntity.set("enable", (Object)"0");
        this.checkRules(0L, archiveRuleEntities);
        DynamicObjectCollection entryEntity = schemaEntity.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < archiveRuleEntities.size(); ++i) {
            DynamicObject entry = orm.newDynamicObject("bos_cbs_archi_schema.entryentity");
            entry.set("seq", (Object)(i + 1));
            entry.set("config", (Object)archiveRuleEntities.get(i).getId());
            entryEntity.add((Object)entry);
        }
        try {
            EntityCoreInvokeUtils.businessDataWriter_save.invoke(null, dataEntityType, new Object[]{schemaEntity});
            DynamicObject queryObj = this.findDynamicObjectById(scheduleId);
            return this.convert2Pojo(queryObj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public List<ArchiveSchedule> findAll() {
        QFilter movingTypeFilter = new QFilter("movingtype", "=", (Object)ArchiveConfigMovingTypeEnum.ARCHIVE.getKey());
        DynamicObjectCollection queryCol = orm.query("bos_cbs_archi_schema", movingTypeFilter.toArray());
        queryCol = Optional.ofNullable(queryCol).orElseGet(DynamicObjectCollection::new);
        Object[] pkList = queryCol.stream().map(DataEntityBase::getPkValue).toArray();
        try {
            DynamicObject[] queryObjs = (DynamicObject[])EntityCoreInvokeUtils.businessDataReader_load.invoke(null, pkList, dataEntityType, Boolean.TRUE);
            return Arrays.stream(queryObjs).map(this::convert2Pojo).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public ArchiveSchedule find(long id) {
        return this.convert2Pojo(this.findDynamicObjectById(id));
    }

    @Override
    public void delete(long id) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        String enable = queryObj.getString("enable");
        if (Objects.equals("1", enable)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot delete data that is enabled.", (String)"ArchiveScheduleImpl_0", (String)"bos-archive", (Object[])new Object[0]));
        }
        if (!ArchiveManager.get().checkScheduleEnd(id)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot delete the schedule as the schedule task is running.", (String)"ArchiveScheduleImpl_1", (String)"bos-archive", (Object[])new Object[0]));
        }
        try {
            EntityCoreInvokeUtils.businessDataWriter_delete.invoke(null, dataEntityType, new Object[]{id});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void enable(long id) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        if (StringUtils.isEmpty((CharSequence)queryObj.getString("scheduleplanid"))) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Failed to enable. Reason: No execution plan is configured.", (String)"ArchiveScheduleImpl_2", (String)"bos-archive", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjectCollection = queryObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Failed to enable. Reason: No archiving rules are configured.", (String)"ArchiveScheduleImpl_12", (String)"bos-archive", (Object[])new Object[0]));
        }
        queryObj.set("enable", (Object)"1");
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void disable(long id) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        queryObj.set("enable", (Object)"0");
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void update(long id, String name) {
        this.update(id, new LocaleString(name));
    }

    @Override
    public void update(long id, LocaleString name) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        queryObj.set("name", (Object)name);
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void update(long id, ArchivePlan archivePlan) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        this.updateExecPlan(queryObj, archivePlan);
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public void update(long id, List<ArchiveRule> archiveRuleEntities) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        this.updateArchiveRule(id, archiveRuleEntities);
    }

    @Override
    public void update(long id, String name, ArchivePlan archivePlan, List<ArchiveRule> archiveRuleEntities) {
        this.update(id, new LocaleString(name), archivePlan, archiveRuleEntities);
    }

    @Override
    public void update(long id, LocaleString name, ArchivePlan archivePlan, List<ArchiveRule> archiveRuleEntities) {
        DynamicObject queryObj = this.findDynamicObjectById(id);
        this.assertCanEdit(queryObj);
        queryObj.set("name", (Object)name);
        this.updateExecPlan(queryObj, archivePlan);
        this.updateArchiveRule(id, archiveRuleEntities);
        try {
            EntityCoreInvokeUtils.businessDataWriter_update.invoke(null, dataEntityType, new Object[]{queryObj});
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void retry(long taskId) {
        ArchiveTaskEntity archiveTaskEntity = ArchiveTaskRepository.get().loadTask(taskId);
        ArchiveTaskStatusEnum taskStatus = archiveTaskEntity.getTaskstatus();
        String entityNumber = archiveTaskEntity.getEntitynumber();
        if (taskStatus != ArchiveTaskStatusEnum.EXECUTING && taskStatus != ArchiveTaskStatusEnum.FAILED) throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Tasks that fail or are in execution can be retried, and other status operations are invalid.", (String)"ArchiveScheduleImpl_11", (String)"bos-archive", (Object[])new Object[0]));
        String lockKey = ArchiveService.getArchiveTaskLockKey(RequestContext.get().getAccountId(), entityNumber);
        DLock lock = DLock.create((String)lockKey);
        if (!lock.tryLock()) throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The operation is invalid during the normal execution of the task.", (String)"ArchiveScheduleImpl_10", (String)"bos-archive", (Object[])new Object[0]));
        try {
            ArchiveSplitTaskRepository.get().setSplitTaskUnexecuted(taskId);
            List<ArchiveSplitTaskEntity> splitTaskEntityList = ArchiveSplitTaskRepository.get().loadSplitTaskList(taskId);
            List<Long> idList = splitTaskEntityList.stream().map(ArchiveSplitTaskEntity::getId).collect(Collectors.toList());
            idList.add(taskId);
            ArchiveSubTaskRepository.get().setSubTaskUnexecuted(idList);
            ArchiveTaskRepository.get().setTaskUnexecuted(taskId);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    private void assertCanEdit(DynamicObject queryObj) {
        String enable = queryObj.getString("enable");
        if (Objects.equals(enable, "1")) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot perform action on enabled item.", (String)"ArchiveScheduleImpl_3", (String)"bos-archive", (Object[])new Object[0]));
        }
    }

    private void updateExecPlan(DynamicObject queryObj, ArchivePlan archivePlan) {
        long scheduleId = queryObj.getLong("id");
        String planId = queryObj.getString("scheduleplanid");
        DynamicObject scheduleObj = ORM.create().queryOne("sch_schedule", new QFilter("id", "=", (Object)planId).toArray());
        if (Objects.isNull(scheduleObj)) {
            String jobNumber = "ARCHIVE_SCHAPI_" + DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS").format(LocalDateTime.now());
            String jobId = ScheduleApiInvokeUtils.createJob(scheduleId, jobNumber);
            planId = ScheduleApiInvokeUtils.createPlan(archivePlan, jobId, jobNumber);
            DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_sch_schedule_entry (fid, fentryid, fseq, fjobnumber) values (?, ?, ?, ?)", (Object[])new Object[]{planId, ID.genLongId(), 0, jobId});
        } else {
            ScheduleApiInvokeUtils.updatePlan(scheduleObj, archivePlan);
        }
        String execPlan = this.getExecPlan(planId);
        queryObj.set("scheduleplanid", (Object)planId);
        queryObj.set("execplan", (Object)execPlan);
        queryObj.set("endtime", (Object)archivePlan.getEndTime());
    }

    private String getExecPlan(String planId) {
        String execPlan = orm.queryOne("sch_schedule", "id,txtdesc", new QFilter("id", "=", (Object)planId).toArray()).getString("txtdesc");
        if (StringUtils.isNotEmpty((CharSequence)execPlan) && execPlan.length() > 153) {
            execPlan = execPlan.substring(0, 150) + "...";
        }
        return execPlan;
    }

    private void updateArchiveRule(long id, List<ArchiveRule> archiveRuleEntities) {
        if (!ArchiveManager.get().checkScheduleEnd(id)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Cannot modify the archive rule as the schedule task is running.", (String)"ArchiveScheduleImpl_4", (String)"bos-archive", (Object[])new Object[0]));
        }
        this.checkRules(id, archiveRuleEntities);
        String deleteSql = "delete from t_cbs_archi_scheduleentry where fid = ?";
        DB.execute((DBRoute)DBRoute.base, (String)deleteSql, (Object[])new Object[]{id});
        String insertSql = "insert into t_cbs_archi_scheduleentry(fid, fentryid, fseq, fconfigid) values (?, ?, ?, ?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(archiveRuleEntities.size());
        for (int i = 0; i < archiveRuleEntities.size(); ++i) {
            paramList.add(new Object[]{id, ID.genLongId(), i + 1, archiveRuleEntities.get(i).getId()});
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)insertSql, paramList);
    }

    private DynamicObject findDynamicObjectById(long id) {
        try {
            return (DynamicObject)EntityCoreInvokeUtils.businessDataReader_loadSingle.invoke(null, id, dataEntityType);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private ArchiveSchedule convert2Pojo(DynamicObject dynamicObj) {
        String localeValue = dynamicObj.getLocaleString("name").getLocaleValue();
        if (StringUtils.isEmpty((CharSequence)localeValue)) {
            localeValue = (String)dynamicObj.getLocaleString("name").getItem("GLang");
        }
        ArchiveSchedule entity = new ArchiveSchedule();
        entity.setId(dynamicObj.getLong("id"));
        entity.setNumber(dynamicObj.getString("number"));
        entity.setName(localeValue);
        entity.setExecPlan(dynamicObj.getString("execplan"));
        entity.setPlanId(dynamicObj.getString("scheduleplanid"));
        entity.setEndTime(dynamicObj.getDate("endtime"));
        entity.setMovingTypeEnum(ArchiveConfigMovingTypeEnum.from(dynamicObj.getString("movingtype")));
        entity.setMasterId(entity.getId());
        entity.setStatus(dynamicObj.getString("status"));
        entity.setEnable(dynamicObj.getString("enable"));
        return entity;
    }

    private void checkRules(long id, List<ArchiveRule> archiveRuleEntities) {
        DynamicObject[] load;
        if (CollectionUtils.isEmpty(archiveRuleEntities)) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The archive rule is required.", (String)"ArchiveScheduleImpl_5", (String)"bos-archive", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        QFilter movingTypeFilter = new QFilter("movingtype", "=", (Object)ArchiveConfigMovingTypeEnum.ARCHIVE.getKey());
        qFilters.add(movingTypeFilter);
        if (id != 0L) {
            qFilters.add(new QFilter("id", "!=", (Object)id));
        }
        try {
            load = (DynamicObject[])EntityCoreInvokeUtils.businessDataServiceHelper_load.invoke(null, "bos_cbs_archi_schema", "entryentity.config", qFilters.toArray(new QFilter[0]));
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        HashSet<Object> loadEntryPkSet = new HashSet<Object>(load.length * 2);
        for (DynamicObject dynamicObject : load) {
            DynamicObjectCollection entryLoad = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryLoad) {
                loadEntryPkSet.add(object.getDynamicObject("config").getPkValue());
            }
        }
        HashSet refRuleSet = new HashSet(archiveRuleEntities.size());
        archiveRuleEntities.forEach(archiveRule -> {
            if (loadEntryPkSet.contains(archiveRule.getId())) {
                refRuleSet.add(archiveRule.getNumber());
            }
        });
        long distinctCount = archiveRuleEntities.stream().map(ArchiveRule::getId).distinct().count();
        if (distinctCount != (long)archiveRuleEntities.size()) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"The same archive rule exists, please reconfigure.", (String)"ArchiveScheduleImpl_6", (String)"bos-archive", (Object[])new Object[0]));
        }
        if (!refRuleSet.isEmpty()) {
            String tips = String.join((CharSequence)",", refRuleSet);
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"It has been called by another schedule, please reconfigure.", (String)"ArchiveScheduleImpl_7", (String)"bos-archive", (Object[])new Object[]{tips}));
        }
    }

    private ArchiveScheduleApiImpl() {
    }

    public static ArchiveScheduleApiImpl get() {
        if (!AccountEnable.isAccountEnable()) {
            throw ExceptionUtil.wrap(ResManager.loadKDString((String)"Please turn on the data archiving configuration first.", (String)"ArchiveScheduleImpl_8", (String)"bos-archive", (Object[])new Object[0]));
        }
        return INSTANCE;
    }

    static {
        try {
            dataEntityType = EntityCoreInvokeUtils.getDataEntityType.invoke(null, "bos_cbs_archi_schema");
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
        INSTANCE = new ArchiveScheduleApiImpl();
    }
}

