/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;

public class ArchiveDatabaseUtils {
    private ArchiveDatabaseUtils() {
    }

    public static List<ArchiveInfo> findAllArchiveInfo() {
        List routeInfoList = MCArchive.get();
        ArrayList<ArchiveInfo> archiveInfoList = new ArrayList<ArchiveInfo>();
        for (RouteInfo routeInfo : routeInfoList) {
            String routeKey = routeInfo.getRouteKey();
            List archiveInfo = routeInfo.getArchiveInfo();
            for (ArchiveInfo archive : archiveInfo) {
                if (routeKey.equals(archive.getKey())) continue;
                archiveInfoList.add(archive);
            }
        }
        Optional.ofNullable(MCArchive.getESArchiveInfo()).ifPresent(archiveInfoList::addAll);
        return archiveInfoList;
    }

    public static List<ArchiveInfo> findArchiveInfoByArchiveRouteType(ArchiveRouteType archiveRouteType) {
        return ArchiveDatabaseUtils.findAllArchiveInfo().stream().filter(archiveInfo -> archiveInfo.getRouteType() == archiveRouteType).collect(Collectors.toList());
    }

    public static boolean existsDBArchiveRoute() {
        List<ArchiveInfo> archiveInfos = ArchiveDatabaseUtils.findArchiveInfoByArchiveRouteType(ArchiveRouteType.DB);
        return CollectionUtils.isNotEmpty(archiveInfos);
    }

    public static boolean isArchiveRoute(String databaseKey) {
        List<ArchiveInfo> archiveInfos = ArchiveDatabaseUtils.findArchiveInfoByArchiveRouteType(ArchiveRouteType.DB);
        return archiveInfos.stream().anyMatch(archiveInfo -> archiveInfo.getKey().equals(databaseKey));
    }

    public static boolean hasArchiveData(String archiveRouteKey) {
        QFilter archiveRouteFilter = new QFilter("archiveroute", "=", (Object)archiveRouteKey);
        return ORM.create().count("ArchiveDatabaseUtils#hasArchiveData", "bos_cbs_archi_entity", archiveRouteFilter.toArray()) != 0;
    }
}

