/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.archive.config.ArchiveParameterValues;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;

public final class ArchiveParameters {
    private static final Map<String, ArchiveParameterValues> accountArchiveParameterMap = new ConcurrentHashMap<String, ArchiveParameterValues>();

    private static String getAccountRegion(String accountId) {
        return Instance.getClusterName() + '.' + accountId;
    }

    public static ArchiveParameterValues get() {
        return ArchiveParameters.get(RequestContext.get().getAccountId());
    }

    private static ArchiveParameterValues get(String accountId) {
        return accountArchiveParameterMap.computeIfAbsent(ArchiveParameters.getAccountRegion(accountId), k -> new ArchiveParameterValues());
    }

    public static ArchiveParameterValues setMap(Map<String, Object> param) {
        ArchiveParameterValues ret = ArchiveParameters.get();
        ret.putAll(param);
        return ret;
    }

    public static void onAccountArchiveEnableChanged(String accountId, boolean enable) {
        ArchiveParameterValues pm = ArchiveParameters.get(accountId);
        pm.setEnable(enable);
        pm.flushToMovingService(accountId);
    }
}

